/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.ff4j.FF4j;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.services.FeatureStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.services.domain.FeatureStoreApiBean;
import org.ff4j.services.domain.GroupDescApiBean;
import org.ff4j.services.exceptions.FeatureStoreNotCached;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0016J>\u0010\u0014\u001a\u00020\b2\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e`\u00182\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/ff4j/services/FeatureStoreServices;", "", "fF4j", "Lorg/ff4j/FF4j;", "(Lorg/ff4j/FF4j;)V", "getFF4j", "()Lorg/ff4j/FF4j;", "clearCachedFeatureStore", "", "deleteAllFeatures", "getAllFeatures", "Lreactor/core/publisher/Flux;", "Lorg/ff4j/services/domain/FeatureApiBean;", "getAllGroups", "Lorg/ff4j/services/domain/GroupDescApiBean;", "getFeatureStore", "Lreactor/core/publisher/Mono;", "Lorg/ff4j/services/domain/FeatureStoreApiBean;", "getFeaturesFromCache", "Lorg/ff4j/services/domain/CacheApiBean;", "initGroup", "groups", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "uid", "groupName", "ff4j-spring-services"})
@SourceDebugExtension(value={"SMAP\nFeatureStoreServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureStoreServices.kt\norg/ff4j/services/FeatureStoreServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1855#2,2:93\n*S KotlinDebug\n*F\n+ 1 FeatureStoreServices.kt\norg/ff4j/services/FeatureStoreServices\n*L\n60#1:93,2\n*E\n"})
public class FeatureStoreServices {
    @NotNull
    private final FF4j fF4j;

    public FeatureStoreServices(@Autowired @NotNull FF4j fF4j) {
        Intrinsics.checkNotNullParameter((Object)fF4j, (String)"fF4j");
        this.fF4j = fF4j;
    }

    @NotNull
    public FF4j getFF4j() {
        return this.fF4j;
    }

    @NotNull
    public Mono<FeatureStoreApiBean> getFeatureStore() {
        FeatureStore featureStore = this.getFF4j().getFeatureStore();
        Intrinsics.checkNotNullExpressionValue((Object)featureStore, (String)"getFeatureStore(...)");
        Mono mono = Mono.just((Object)new FeatureStoreApiBean(featureStore));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        return mono;
    }

    @NotNull
    public Flux<FeatureApiBean> getAllFeatures() {
        Flux flux;
        Map allFeatures = this.getFF4j().getFeatureStore().readAll();
        if (CollectionUtils.isEmpty((Map)allFeatures)) {
            Flux flux2 = Flux.empty();
            Intrinsics.checkNotNull((Object)flux2);
            flux = flux2;
        } else {
            ArrayList features = new ArrayList(allFeatures.size());
            features.addAll(allFeatures.values().stream().map(arg_0 -> FeatureStoreServices.getAllFeatures$lambda$0(getAllFeatures.1.INSTANCE, arg_0)).collect(Collectors.toList()));
            Flux flux3 = Flux.fromIterable((Iterable)features);
            Intrinsics.checkNotNull((Object)flux3);
            flux = flux3;
        }
        return flux;
    }

    @NotNull
    public Flux<GroupDescApiBean> getAllGroups() {
        Map allFeatures;
        HashMap<String, GroupDescApiBean> groups = new HashMap<String, GroupDescApiBean>();
        Map map = allFeatures = this.getFF4j().getFeatureStore().readAll();
        if (map != null) {
            Map it = map;
            boolean bl = false;
            Iterable $this$forEach$iv = allFeatures.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Feature it2 = (Feature)element$iv;
                boolean bl2 = false;
                String string = it2.getUid();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUid(...)");
                this.initGroup(groups, string, it2.getGroup());
            }
        }
        Flux flux = Flux.fromIterable((Iterable)groups.values());
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"fromIterable(...)");
        return flux;
    }

    private void initGroup(HashMap<String, GroupDescApiBean> groups, String uid, String groupName) {
        block3: {
            String string = groupName;
            if (string == null) break block3;
            String it = string;
            boolean bl = false;
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                Object object;
                if (!groups.containsKey(groupName)) {
                    ((Map)groups).put(groupName, new GroupDescApiBean(groupName, new ArrayList()));
                }
                if ((object = groups.get(groupName)) != null && (object = ((GroupDescApiBean)object).getFeatures()) != null) {
                    object.add(uid);
                }
            }
        }
    }

    public void deleteAllFeatures() {
        this.getFF4j().getFeatureStore().clear();
    }

    @NotNull
    public Mono<CacheApiBean> getFeaturesFromCache() {
        if (this.getFF4j().getCacheProxy() == null) {
            throw new FeatureStoreNotCached();
        }
        FeatureStore featureStore = this.getFF4j().getFeatureStore();
        Intrinsics.checkNotNullExpressionValue((Object)featureStore, (String)"getFeatureStore(...)");
        Mono mono = Mono.just((Object)new CacheApiBean(featureStore));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        return mono;
    }

    public void clearCachedFeatureStore() {
        FF4jCacheProxy fF4jCacheProxy = this.getFF4j().getCacheProxy();
        if (fF4jCacheProxy == null) {
            throw new FeatureStoreNotCached();
        }
        FF4jCacheProxy cacheProxy = fF4jCacheProxy;
        cacheProxy.getCacheManager().clearFeatures();
    }

    private static final FeatureApiBean getAllFeatures$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FeatureApiBean)$tmp0.invoke(p0);
    }
}

