/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.FF4j;
import org.ff4j.services.GroupServices;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.services.validator.FeatureValidator;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/ff4j/services/GroupServices;", "", "fF4j", "Lorg/ff4j/FF4j;", "ff4jValidator", "Lorg/ff4j/services/validator/FeatureValidator;", "(Lorg/ff4j/FF4j;Lorg/ff4j/services/validator/FeatureValidator;)V", "getFF4j", "()Lorg/ff4j/FF4j;", "getFf4jValidator", "()Lorg/ff4j/services/validator/FeatureValidator;", "disableGroup", "", "groupName", "", "enableGroup", "getFeaturesByGroup", "Lreactor/core/publisher/Flux;", "Lorg/ff4j/services/domain/FeatureApiBean;", "ff4j-spring-services"})
public class GroupServices {
    @NotNull
    private final FF4j fF4j;
    @NotNull
    private final FeatureValidator ff4jValidator;

    public GroupServices(@Autowired @NotNull FF4j fF4j, @Autowired @NotNull FeatureValidator ff4jValidator) {
        Intrinsics.checkNotNullParameter((Object)fF4j, (String)"fF4j");
        Intrinsics.checkNotNullParameter((Object)ff4jValidator, (String)"ff4jValidator");
        this.fF4j = fF4j;
        this.ff4jValidator = ff4jValidator;
    }

    @NotNull
    public FF4j getFF4j() {
        return this.fF4j;
    }

    @NotNull
    public FeatureValidator getFf4jValidator() {
        return this.ff4jValidator;
    }

    @NotNull
    public Flux<FeatureApiBean> getFeaturesByGroup(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getFf4jValidator().assertGroupExist(groupName);
        Flux flux = Flux.fromStream(this.getFF4j().getFeatureStore().readGroup(groupName).values().stream().map(arg_0 -> GroupServices.getFeaturesByGroup$lambda$0(getFeaturesByGroup.1.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"fromStream(...)");
        return flux;
    }

    public void enableGroup(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getFf4jValidator().assertGroupExist(groupName);
        this.getFF4j().getFeatureStore().enableGroup(groupName);
    }

    public void disableGroup(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getFf4jValidator().assertGroupExist(groupName);
        this.getFF4j().getFeatureStore().disableGroup(groupName);
    }

    private static final FeatureApiBean getFeaturesByGroup$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FeatureApiBean)$tmp0.invoke(p0);
    }
}

