/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.FF4j;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.services.PropertyStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.PropertyApiBean;
import org.ff4j.services.domain.PropertyStoreApiBean;
import org.ff4j.services.exceptions.PropertyStoreNotCached;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/ff4j/services/PropertyStoreServices;", "", "ff4j", "Lorg/ff4j/FF4j;", "(Lorg/ff4j/FF4j;)V", "getFf4j", "()Lorg/ff4j/FF4j;", "clearCachedPropertyStore", "", "deleteAllProperties", "getAllProperties", "Lreactor/core/publisher/Flux;", "Lorg/ff4j/services/domain/PropertyApiBean;", "getPropertiesFromCache", "Lreactor/core/publisher/Mono;", "Lorg/ff4j/services/domain/CacheApiBean;", "getPropertyStore", "Lorg/ff4j/services/domain/PropertyStoreApiBean;", "ff4j-spring-services"})
public class PropertyStoreServices {
    @NotNull
    private final FF4j ff4j;

    public PropertyStoreServices(@Autowired @NotNull FF4j ff4j) {
        Intrinsics.checkNotNullParameter((Object)ff4j, (String)"ff4j");
        this.ff4j = ff4j;
    }

    @NotNull
    public FF4j getFf4j() {
        return this.ff4j;
    }

    @NotNull
    public Mono<PropertyStoreApiBean> getPropertyStore() {
        PropertyStore propertyStore = this.getFf4j().getPropertiesStore();
        Intrinsics.checkNotNullExpressionValue((Object)propertyStore, (String)"getPropertiesStore(...)");
        Mono mono = Mono.just((Object)new PropertyStoreApiBean(propertyStore));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        return mono;
    }

    @NotNull
    public Flux<PropertyApiBean> getAllProperties() {
        Flux flux;
        Map allProperties = this.getFf4j().getPropertiesStore().readAllProperties();
        if (CollectionUtils.isEmpty((Map)allProperties)) {
            Flux flux2 = Flux.empty();
            Intrinsics.checkNotNull((Object)flux2);
            flux = flux2;
        } else {
            Flux flux3 = Flux.fromStream(allProperties.values().stream().map(arg_0 -> PropertyStoreServices.getAllProperties$lambda$0(getAllProperties.1.INSTANCE, arg_0)));
            Intrinsics.checkNotNull((Object)flux3);
            flux = flux3;
        }
        return flux;
    }

    public void deleteAllProperties() {
        this.getFf4j().getPropertiesStore().clear();
    }

    @NotNull
    public Mono<CacheApiBean> getPropertiesFromCache() {
        if (this.getFf4j().getCacheProxy() == null) {
            throw new PropertyStoreNotCached();
        }
        PropertyStore propertyStore = this.getFf4j().getPropertiesStore();
        Intrinsics.checkNotNullExpressionValue((Object)propertyStore, (String)"getPropertiesStore(...)");
        Mono mono = Mono.just((Object)new CacheApiBean(propertyStore));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
        return mono;
    }

    public void clearCachedPropertyStore() {
        FF4jCacheProxy fF4jCacheProxy = this.getFf4j().getCacheProxy();
        if (fF4jCacheProxy == null) {
            throw new PropertyStoreNotCached();
        }
        FF4jCacheProxy cacheProxy = fF4jCacheProxy;
        cacheProxy.getCacheManager().clearProperties();
    }

    private static final PropertyApiBean getAllProperties$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PropertyApiBean)$tmp0.invoke(p0);
    }
}

