/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.dynamodb.feature;

import java.util.Map;
import java.util.Set;
import org.ff4j.core.Feature;
import org.ff4j.dynamodb.feature.FeatureDynamoDBClient;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

public class FeatureStoreDynamoDB
extends AbstractFeatureStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureStoreDynamoDB.class);
    private FeatureDynamoDBClient dynamoDBClient;

    public FeatureStoreDynamoDB() {
        this((DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).build());
    }

    public FeatureStoreDynamoDB(DynamoDbClient client) {
        this.initStore(client);
    }

    public boolean exist(String featId) {
        try {
            this.getClient().getItem(featId);
        }
        catch (FeatureNotFoundException e) {
            return false;
        }
        return true;
    }

    public void create(Feature feature) {
        Util.assertNotNull((Object[])new Object[]{feature});
        this.assertFeatureNotExist(feature.getUid());
        feature.getPermissions().removeIf(s -> s.length() == 0);
        this.getClient().put(feature);
        LOGGER.info("Feature " + feature.getUid() + " created");
    }

    public void enable(String uid) {
        this.assertFeatureExist(uid);
        this.getClient().updateFeatureAvailability(uid, true);
        LOGGER.info("Feature " + uid + " enabled");
    }

    public void disable(String uid) {
        this.assertFeatureExist(uid);
        this.getClient().updateFeatureAvailability(uid, false);
        LOGGER.info("Feature " + uid + " disabled");
    }

    public Feature read(String featureUid) {
        return this.getClient().get(featureUid);
    }

    public Map<String, Feature> readAll() {
        return this.getClient().getAll();
    }

    public void delete(String featureId) {
        this.assertFeatureExist(featureId);
        this.getClient().deleteItem(featureId);
        LOGGER.info("Feature " + featureId + " deleted");
    }

    public void update(Feature feature) {
        Util.assertNotNull((Object[])new Object[]{feature});
        this.delete(feature.getUid());
        this.create(feature);
    }

    public void clear() {
        this.deleteTable();
        this.createSchema();
    }

    public void createSchema() {
        if (!this.getClient().tableExists()) {
            this.getClient().createTable();
            LOGGER.info("Feature table created");
        }
    }

    public boolean existGroup(String groupName) {
        Util.assertHasLength((String[])new String[]{groupName});
        try {
            this.getClient().getItemsByGroup(groupName);
        }
        catch (GroupNotFoundException ge) {
            return false;
        }
        return true;
    }

    public Map<String, Feature> readGroup(String groupName) {
        Util.assertHasLength((String[])new String[]{groupName});
        return this.getClient().getFeaturesByGroup(groupName);
    }

    public Set<String> readAllGroups() {
        return this.getClient().getAllGroups();
    }

    public void addToGroup(String featureId, String groupName) {
        this.assertFeatureExist(featureId);
        Util.assertHasLength((String[])new String[]{groupName});
        this.getClient().addToGroup(featureId, groupName);
        LOGGER.info("Group " + groupName + " added to feature " + featureId);
    }

    public void removeFromGroup(String featureId, String groupName) {
        this.assertFeatureExist(featureId);
        this.assertGroupExist(groupName);
        this.getClient().removeFromGroup(featureId);
        LOGGER.info("Group " + groupName + " removed from feature " + featureId);
    }

    public void enableGroup(String groupName) {
        Util.assertHasLength((String[])new String[]{groupName});
        this.getClient().updateFeatureAvailabilityInGroup(groupName, true);
        LOGGER.info("Group " + groupName + " enabled");
    }

    public void disableGroup(String groupName) {
        Util.assertHasLength((String[])new String[]{groupName});
        this.getClient().updateFeatureAvailabilityInGroup(groupName, false);
        LOGGER.info("Group " + groupName + " disabled");
    }

    public void grantRoleOnFeature(String flipId, String roleName) {
        Util.assertHasLength((String[])new String[]{roleName});
        this.getClient().addFeaturePermission(flipId, roleName);
        LOGGER.info("Role " + roleName + " granted on feature " + flipId);
    }

    public void removeRoleFromFeature(String flipId, String roleName) {
        Util.assertHasLength((String[])new String[]{roleName});
        this.getClient().removeFeaturePermission(flipId, roleName);
        LOGGER.info("Role " + roleName + " revoked on feature " + flipId);
    }

    private void initStore(DynamoDbClient amazonDynamoDB) {
        this.dynamoDBClient = new FeatureDynamoDBClient(amazonDynamoDB);
        this.createSchema();
    }

    private FeatureDynamoDBClient getClient() {
        return this.dynamoDBClient;
    }

    private void deleteTable() {
        this.getClient().deleteTable();
        LOGGER.info("Feature table deleted");
    }

    void clearData() {
        this.getClient().clearTable();
    }
}

