/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.dynamodb.property;

import java.util.Collection;
import java.util.HashSet;
import org.ff4j.dynamodb.property.DynamoDbProperty;
import org.ff4j.mapper.PropertyMapper;
import org.ff4j.property.Property;
import org.ff4j.property.util.PropertyFactory;
import software.amazon.awssdk.utils.CollectionUtils;

public class PropertyDynamoDBMapper
implements PropertyMapper<DynamoDbProperty> {
    public DynamoDbProperty toStore(Property<?> property) {
        DynamoDbProperty item = new DynamoDbProperty();
        item.setName(property.getName());
        item.setValue(property.asString());
        item.setType(property.getType());
        item.setDescription(property.getDescription());
        HashSet<String> fixedValues = new HashSet<String>();
        if (!CollectionUtils.isNullOrEmpty((Collection)property.getFixedValues())) {
            for (Object fixedValue : property.getFixedValues()) {
                fixedValues.add(fixedValue.toString());
            }
            item.setValues(fixedValues);
        }
        return item;
    }

    public Property<?> fromStore(DynamoDbProperty item) {
        return PropertyFactory.createProperty((String)item.getName(), (String)item.getType(), (String)item.getValue(), (String)item.getDescription(), CollectionUtils.isNullOrEmpty(item.getValues()) ? new HashSet() : new HashSet<String>(item.getValues()));
    }
}

