/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import org.ff4j.utils.Util;

public interface FF4jCassandraSchema {
    public static final String DEFAULT_KEYSPACE = "ff4j";
    public static final String UDT_STRATEGY = "ff4j_udt_strategy";
    public static final String UDT_STRATEGY_CLASS = "class";
    public static final String UDT_STRATEGY_PARAMS = "params";
    public static final String UDT_PROPERTY = "ff4j_udt_property";
    public static final String UDT_PROPERTY_UID = "uid";
    public static final String UDT_PROPERTY_CLASS = "class";
    public static final String UDT_PROPERTY_VALUE = "value";
    public static final String UDT_PROPERTY_DESCRIPTION = "description";
    public static final String UDT_PROPERTY_FIXEDVALUES = "fixedvalues";
    public static final String FEATURES_TABLE = "ff4j_features";
    public static final String FEATURES_INDEX_GROUPNAME = "ff4j_features_index_groupname";
    public static final String FEATURES_ATT_GROUPNAME = "groupname";
    public static final String FEATURES_ATT_UID = "uid";
    public static final String FEATURES_ATT_ENABLED = "enabled";
    public static final String FEATURES_ATT_DESCRIPTION = "description";
    public static final String FEATURES_ATT_STRATEGY = "strategy";
    public static final String FEATURES_ATT_ROLES = "roles";
    public static final String FEATURES_ATT_PROPERTIES = "properties";
    public static final String PROPERTIES_TABLE = "ff4j_properties";
    public static final String PROPERTIES_ATT_UID = "uid";
    public static final String PROPERTIES_ATT_CLASS = "class";
    public static final String PROPERTIES_ATT_VALUE = "value";
    public static final String PROPERTIES_ATT_DESCRIPTION = "description";
    public static final String PROPERTIES_ATT_FIXEDVALUES = "fixedvalues";
    public static final String AUDIT_TABLE = "ff4j_audit";
    public static final String AUDIT_HITCOUNT_TABLE = "ff4j_audit_hitcount";
    public static final String AUDIT_ATT_UID = "uid";
    public static final String AUDIT_ATT_TIME = "time";
    public static final String AUDIT_ATT_TYPE = "type";
    public static final String AUDIT_ATT_NAME = "name";
    public static final String AUDIT_ATT_ACTION = "action";
    public static final String AUDIT_ATT_HOSTNAME = "hostname";
    public static final String AUDIT_ATT_SOURCE = "source";
    public static final String AUDIT_ATT_DURATION = "duration";
    public static final String AUDIT_ATT_USER = "user";
    public static final String AUDIT_ATT_VALUE = "value";
    public static final String AUDIT_ATT_CUSTOM = "custom";
    public static final SimpleStatement STMT_CREATE_TABLE_FEATURE = SchemaBuilder.createTable((String)"ff4j_features").ifNotExists().withPartitionKey("uid", DataTypes.TEXT).withColumn("groupname", DataTypes.TEXT).withColumn("enabled", DataTypes.BOOLEAN).withColumn("description", DataTypes.TEXT).withColumn("strategy", (DataType)SchemaBuilder.udt((String)"ff4j_udt_strategy", (boolean)true)).withColumn("roles", (DataType)DataTypes.setOf((DataType)DataTypes.TEXT)).withColumn("properties", (DataType)DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)SchemaBuilder.udt((String)"ff4j_udt_property", (boolean)true))).build();
    public static final SimpleStatement STMT_CREATE_UDT_STRATEGY = SchemaBuilder.createType((String)"ff4j_udt_strategy").ifNotExists().withField("class", DataTypes.TEXT).withField("params", (DataType)DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.TEXT)).build();
    public static final SimpleStatement STMT_CREATE_INDEX_FEATUREGROUP = SchemaBuilder.createIndex((String)"ff4j_features_index_groupname").ifNotExists().onTable("ff4j_features").andColumn("groupname").build();
    public static final SimpleStatement STMT_CREATE_TABLE_PROPERTY = SchemaBuilder.createTable((String)"ff4j_properties").ifNotExists().withPartitionKey("uid", DataTypes.TEXT).withColumn("class", DataTypes.TEXT).withColumn("value", DataTypes.TEXT).withColumn("description", DataTypes.TEXT).withColumn("fixedvalues", (DataType)DataTypes.setOf((DataType)DataTypes.TEXT)).build();
    public static final SimpleStatement STMT_CREATE_UDT_PROPERTY = SchemaBuilder.createType((String)"ff4j_udt_property").ifNotExists().withField("uid", DataTypes.TEXT).withField("class", DataTypes.TEXT).withField("value", DataTypes.TEXT).withField("description", DataTypes.TEXT).withField("fixedvalues", (DataType)DataTypes.setOf((DataType)DataTypes.TEXT)).build();
    public static final SimpleStatement STMT_CREATE_TABLE_AUDIT = SchemaBuilder.createTable((String)"ff4j_audit").ifNotExists().withPartitionKey("uid", DataTypes.UUID).withColumn("time", DataTypes.TIMESTAMP).withColumn("type", DataTypes.TEXT).withColumn("name", DataTypes.TEXT).withColumn("action", DataTypes.TEXT).withColumn("source", DataTypes.TEXT).withColumn("hostname", DataTypes.TEXT).withColumn("duration", DataTypes.INT).withColumn("user", DataTypes.TEXT).withColumn("value", DataTypes.TEXT).withColumn("custom", (DataType)DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.TEXT)).build();
    public static final SimpleStatement STMT_CREATE_TABLE_AUDITHITCOUNT = SchemaBuilder.createTable((String)"ff4j_audit_hitcount").ifNotExists().withPartitionKey("name", DataTypes.TEXT).withClusteringColumn("time", DataTypes.TIMESTAMP).withColumn("uid", DataTypes.UUID).withColumn("source", DataTypes.TEXT).withColumn("hostname", DataTypes.TEXT).withColumn("duration", DataTypes.INT).withColumn("user", DataTypes.TEXT).withColumn("value", DataTypes.TEXT).withColumn("custom", (DataType)DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.TEXT)).build();
    public static final SimpleStatement STMT_FEATURE_EXIST = ((Select)QueryBuilder.selectFrom((String)"ff4j_features").column("uid").whereColumn("uid").isEqualTo((Term)QueryBuilder.bindMarker())).build();
    public static final SimpleStatement STMT_FEATURE_READ = ((Select)QueryBuilder.selectFrom((String)"ff4j_features").all().whereColumn("uid").isEqualTo((Term)QueryBuilder.bindMarker())).build();
    public static final SimpleStatement STMT_FEATURE_READ_ALL = QueryBuilder.selectFrom((String)"ff4j_features").all().build();
    public static final SimpleStatement STMT_FEATURE_TOGGLE = ((Update)QueryBuilder.update((String)"ff4j_features").setColumn("enabled", (Term)QueryBuilder.bindMarker()).whereColumn("uid").isEqualTo((Term)QueryBuilder.bindMarker())).build();
    public static final SimpleStatement STMT_FEATURE_INSERT = QueryBuilder.insertInto((String)"ff4j_features").value("uid", (Term)QueryBuilder.bindMarker((String)"uid")).value("groupname", (Term)QueryBuilder.bindMarker((String)"groupname")).value("enabled", (Term)QueryBuilder.bindMarker((String)"enabled")).value("description", (Term)QueryBuilder.bindMarker((String)"description")).value("roles", (Term)QueryBuilder.bindMarker((String)"roles")).value("strategy", (Term)QueryBuilder.bindMarker((String)"strategy")).value("properties", (Term)QueryBuilder.bindMarker((String)"properties")).build();
    public static final SimpleStatement STMT_FEATURE_DELETE = ((Delete)QueryBuilder.deleteFrom((String)"ff4j_features").whereColumn("uid").isEqualTo((Term)QueryBuilder.bindMarker())).build();
    public static final SimpleStatement STMT_FEATURE_ADDTOGROUP = ((Update)QueryBuilder.update((String)"ff4j_features").setColumn("groupname", (Term)QueryBuilder.bindMarker()).whereColumn("uid").isEqualTo((Term)QueryBuilder.bindMarker())).build();
    public static final SimpleStatement STMT_FEATURE_REMOVEGROUP = ((Delete)QueryBuilder.deleteFrom((String)"ff4j_features").column("groupname").whereColumn("uid").isEqualTo((Term)QueryBuilder.bindMarker())).build();
    public static final SimpleStatement STMT_FEATUREGROUP_READ = ((Select)QueryBuilder.selectFrom((String)"ff4j_features").all().whereColumn("groupname").isEqualTo((Term)QueryBuilder.bindMarker())).build();
    public static final SimpleStatement STMT_FEATUREGROUP_LIST = QueryBuilder.selectFrom((String)"ff4j_features").column("groupname").build();
    public static final SimpleStatement STMT_PROPERTY_EXIST = ((Select)QueryBuilder.selectFrom((String)"ff4j_properties").column("uid").whereColumn("uid").isEqualTo((Term)QueryBuilder.bindMarker())).build();
    public static final SimpleStatement STMT_PROPERTY_READ = ((Select)QueryBuilder.selectFrom((String)"ff4j_properties").all().whereColumn("uid").isEqualTo((Term)QueryBuilder.bindMarker())).build();
    public static final SimpleStatement STMT_PROPERTY_READ_ALL = QueryBuilder.selectFrom((String)"ff4j_properties").all().build();
    public static final SimpleStatement STMT_PROPERTY_LISTNAMES = QueryBuilder.selectFrom((String)"ff4j_properties").column("uid").build();
    public static final SimpleStatement STMT_PROPERTY_DELETE = ((Delete)QueryBuilder.deleteFrom((String)"ff4j_properties").whereColumn("uid").isEqualTo((Term)QueryBuilder.bindMarker())).build();
    public static final SimpleStatement STMT_PROPERTY_INSERT = QueryBuilder.insertInto((String)"ff4j_properties").value("uid", (Term)QueryBuilder.bindMarker((String)"uid")).value("class", (Term)QueryBuilder.bindMarker((String)"class")).value("value", (Term)QueryBuilder.bindMarker((String)"value")).value("description", (Term)QueryBuilder.bindMarker((String)"description")).value("fixedvalues", (Term)QueryBuilder.bindMarker((String)"fixedvalues")).build();
    public static final SimpleStatement STMT_AUDIT_INSERT = QueryBuilder.insertInto((String)"ff4j_audit").value("type", (Term)QueryBuilder.bindMarker((String)"type")).value("time", (Term)QueryBuilder.bindMarker((String)"time")).value("uid", (Term)QueryBuilder.bindMarker((String)"uid")).value("name", (Term)QueryBuilder.bindMarker((String)"name")).value("action", (Term)QueryBuilder.bindMarker((String)"action")).value("source", (Term)QueryBuilder.bindMarker((String)"source")).value("hostname", (Term)QueryBuilder.bindMarker((String)"hostname")).value("duration", (Term)QueryBuilder.bindMarker((String)"duration")).value("user", (Term)QueryBuilder.bindMarker((String)"user")).value("value", (Term)QueryBuilder.bindMarker((String)"value")).value("custom", (Term)QueryBuilder.bindMarker((String)"custom")).build();
    public static final SimpleStatement STMT_AUDIT_INSERT_HITCOUNT = QueryBuilder.insertInto((String)"ff4j_audit_hitcount").value("uid", (Term)QueryBuilder.bindMarker((String)"uid")).value("time", (Term)QueryBuilder.bindMarker((String)"time")).value("name", (Term)QueryBuilder.bindMarker((String)"name")).value("source", (Term)QueryBuilder.bindMarker((String)"source")).value("hostname", (Term)QueryBuilder.bindMarker((String)"hostname")).value("duration", (Term)QueryBuilder.bindMarker((String)"duration")).value("user", (Term)QueryBuilder.bindMarker((String)"user")).value("value", (Term)QueryBuilder.bindMarker((String)"value")).value("custom", (Term)QueryBuilder.bindMarker((String)"custom")).build();
    public static final SimpleStatement STMT_AUDIT_READ_BY_ID = ((Select)QueryBuilder.selectFrom((String)"ff4j_audit").all().whereColumn("uid").isEqualTo((Term)QueryBuilder.bindMarker())).build();

    default public void dropTableIfExists(CqlSession session, String tableName) {
        Util.assertNotNull((Object[])new Object[]{session});
        Util.assertHasLength((String[])new String[]{tableName});
        session.execute((Statement)SchemaBuilder.dropTable((String)tableName).ifExists().build());
    }

    default public void dropTypeIffExists(CqlSession session, String typeName) {
        Util.assertNotNull((Object[])new Object[]{session});
        Util.assertHasLength((String[])new String[]{typeName});
        session.execute((Statement)SchemaBuilder.dropType((String)typeName).ifExists().build());
    }

    default public void truncateTable(CqlSession session, String tableName) {
        session.execute((Statement)QueryBuilder.truncate((String)tableName).build());
    }

    default public boolean isTableExist(CqlSession cqlSession, String tableName) {
        Util.assertNotNull((Object[])new Object[]{cqlSession});
        Util.assertHasLength((String[])new String[]{tableName});
        return ((KeyspaceMetadata)cqlSession.getMetadata().getKeyspace((CqlIdentifier)cqlSession.getKeyspace().get()).get()).getTable(tableName).isPresent();
    }
}

