/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cassandra.store;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.EventSeries;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.TimeSeriesChart;
import org.ff4j.audit.repository.AbstractEventRepository;
import org.ff4j.cassandra.FF4jCassandraSchema;
import org.ff4j.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRepositoryCassandra
extends AbstractEventRepository
implements FF4jCassandraSchema {
    private static Logger LOGGER = LoggerFactory.getLogger(EventRepositoryCassandra.class);
    private CqlSession cqlSession;
    private Duration duration = Duration.ofMinutes(10L);
    private PreparedStatement psInsertEvent;
    private PreparedStatement psInsertEventByType;
    private PreparedStatement psReadEventById;

    public EventRepositoryCassandra() {
    }

    public EventRepositoryCassandra(CqlSession cqlSession) {
        this.cqlSession = cqlSession;
    }

    public void createSchema() {
        this.cqlSession.execute((Statement)STMT_CREATE_TABLE_AUDIT);
        this.cqlSession.execute((Statement)STMT_CREATE_TABLE_AUDITHITCOUNT);
    }

    public boolean saveEvent(Event e) {
        Util.assertEvent((Event)e);
        CqlSession cqlSession = this.getCqlSession();
        BatchStatementBuilder batchBuilder = new BatchStatementBuilder(BatchType.LOGGED);
        BoundStatement bsInsertEvent = this.psInsertEvent.bind(new Object[0]);
        bsInsertEvent = (BoundStatement)bsInsertEvent.setUuid("uid", UUID.fromString(e.getUuid()));
        bsInsertEvent = (BoundStatement)bsInsertEvent.setString("type", e.getType());
        bsInsertEvent = (BoundStatement)bsInsertEvent.setInstant("time", Instant.ofEpochMilli(e.getTimestamp()));
        bsInsertEvent = (BoundStatement)bsInsertEvent.setString("name", e.getName());
        bsInsertEvent = (BoundStatement)bsInsertEvent.setString("action", e.getAction());
        bsInsertEvent = (BoundStatement)bsInsertEvent.setString("source", e.getSource());
        bsInsertEvent = (BoundStatement)bsInsertEvent.setString("hostname", e.getHostName());
        bsInsertEvent = (BoundStatement)bsInsertEvent.setInt("duration", new Long(e.getDuration()).intValue());
        bsInsertEvent = (BoundStatement)bsInsertEvent.setString("user", e.getUser());
        bsInsertEvent = (BoundStatement)bsInsertEvent.setString("value", e.getValue());
        bsInsertEvent = (BoundStatement)bsInsertEvent.setMap("custom", e.getCustomKeys(), String.class, String.class);
        batchBuilder.addStatement((BatchableStatement)bsInsertEvent);
        if ("checkOn".equalsIgnoreCase(e.getAction())) {
            BoundStatement bsInsertEventByType = this.psInsertEventByType.bind(new Object[0]);
            bsInsertEventByType = (BoundStatement)bsInsertEventByType.setUuid("uid", UUID.fromString(e.getUuid()));
            bsInsertEventByType = (BoundStatement)bsInsertEventByType.setInstant("time", Instant.ofEpochMilli(e.getTimestamp()));
            bsInsertEventByType = (BoundStatement)bsInsertEventByType.setString("name", e.getName());
            bsInsertEventByType = (BoundStatement)bsInsertEventByType.setString("source", e.getSource());
            bsInsertEventByType = (BoundStatement)bsInsertEventByType.setString("hostname", e.getHostName());
            bsInsertEventByType = (BoundStatement)bsInsertEventByType.setInt("duration", new Long(e.getDuration()).intValue());
            bsInsertEventByType = (BoundStatement)bsInsertEventByType.setString("user", e.getUser());
            bsInsertEventByType = (BoundStatement)bsInsertEventByType.setString("value", e.getValue());
            bsInsertEventByType = (BoundStatement)bsInsertEventByType.setMap("custom", e.getCustomKeys(), String.class, String.class);
            batchBuilder.addStatement((BatchableStatement)bsInsertEventByType);
        }
        cqlSession.execute((Statement)batchBuilder.build());
        return true;
    }

    public Event getEventByUUID(String uuid, Long timestamp) {
        Util.assertHasLength((String[])new String[]{uuid});
        BoundStatement stmtFindEventById = this.psReadEventById.bind(new Object[]{UUID.fromString(uuid)});
        ResultSet rs = this.getCqlSession().execute((Statement)stmtFindEventById);
        Row row = (Row)rs.one();
        if (null == row) {
            SimpleStatement ss = new SimpleStatementBuilder("SELECT * FROM ff4j_audit_hitcount WHERE uid= ? ALLOW FILTERING").addPositionalValue((Object)UUID.fromString(uuid)).build();
            ResultSet rs2 = this.getCqlSession().execute((Statement)ss);
            Row row2 = (Row)rs2.one();
            if (null == row2) {
                return null;
            }
            return this.mapEventHit(row2);
        }
        return this.mapEventRow(row);
    }

    private SimpleStatement buildDynamicStatementHitCount(EventQueryDefinition query) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM ff4j_audit_hitcount");
        sb.append(" WHERE (time> ?) ");
        sb.append(" AND   (time< ?) ");
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(Instant.ofEpochMilli(query.getFrom()));
        parameters.add(Instant.ofEpochMilli(query.getTo()));
        if (!query.getNamesFilter().isEmpty()) {
            sb.append(" AND (name IN ?)");
            parameters.add(query.getNamesFilter());
        }
        if (!query.getActionFilters().isEmpty()) {
            sb.append(" AND (action IN ?)");
            parameters.add(query.getActionFilters());
        }
        if (!query.getHostFilters().isEmpty()) {
            sb.append(" AND (hostname IN ?)");
            parameters.add(query.getHostFilters());
        }
        if (!query.getSourceFilters().isEmpty()) {
            sb.append(" AND (source IN ? )");
            parameters.add(query.getSourceFilters());
        }
        sb.append(" ALLOW FILTERING");
        SimpleStatementBuilder builder = SimpleStatement.builder((String)sb.toString());
        for (Object e : parameters) {
            builder = builder.addPositionalValue(e);
        }
        SimpleStatement ss = builder.build();
        ss.setConsistencyLevel(ConsistencyLevel.ONE);
        ss.setTimeout(Duration.ofMinutes(10L));
        ss.setTracing(false);
        return ss;
    }

    private SimpleStatement buildDynamicStatementAudit(EventQueryDefinition query) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * FROM ff4j_audit");
        sb.append(" WHERE (time> ?) ");
        sb.append(" AND   (time< ?) ");
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(Instant.ofEpochMilli(query.getFrom()));
        parameters.add(Instant.ofEpochMilli(query.getTo()));
        if (!query.getNamesFilter().isEmpty()) {
            sb.append(" AND (name IN ?)");
            parameters.add(query.getNamesFilter());
        }
        if (!query.getActionFilters().isEmpty()) {
            sb.append(" AND (action IN ?)");
            parameters.add(query.getActionFilters());
        }
        if (!query.getHostFilters().isEmpty()) {
            sb.append(" AND (hostname IN ?)");
            parameters.add(query.getHostFilters());
        }
        if (!query.getSourceFilters().isEmpty()) {
            sb.append(" AND (source IN ? )");
            parameters.add(query.getSourceFilters());
        }
        sb.append(" ALLOW FILTERING");
        SimpleStatementBuilder builder = SimpleStatement.builder((String)sb.toString());
        for (Object e : parameters) {
            builder = builder.addPositionalValue(e);
        }
        SimpleStatement ss = builder.build();
        ss.setConsistencyLevel(ConsistencyLevel.ONE);
        ss.setTimeout(Duration.ofMinutes(10L));
        ss.setTracing(false);
        return ss;
    }

    private Map<String, MutableHitCount> countResultSet(ResultSet rs, String dimension) {
        HashMap<String, MutableHitCount> hitCount = new HashMap<String, MutableHitCount>();
        for (Row row : rs) {
            String featureName = row.getString(dimension);
            if (hitCount.containsKey(featureName)) {
                ((MutableHitCount)hitCount.get(featureName)).inc();
                continue;
            }
            hitCount.put(featureName, new MutableHitCount(1));
        }
        return hitCount;
    }

    public Map<String, MutableHitCount> executeHitCount(EventQueryDefinition query, String dimension) {
        LOGGER.warn("You are executing an OLAP query. The generic nature of query definition does not allow custom tables. The response time could be long (full scan).");
        SimpleStatement ss = this.buildDynamicStatementHitCount(query);
        LOGGER.info("Executing OLAP: {}", (Object)ss.getQuery());
        return this.countResultSet(this.getCqlSession().execute((Statement)ss), dimension);
    }

    public Map<String, MutableHitCount> getFeatureUsageHitCount(EventQueryDefinition query) {
        return this.executeHitCount(query, "name");
    }

    public Map<String, MutableHitCount> getUserHitCount(EventQueryDefinition query) {
        return this.executeHitCount(query, "user");
    }

    public Map<String, MutableHitCount> getHostHitCount(EventQueryDefinition query) {
        return this.executeHitCount(query, "hostname");
    }

    public Map<String, MutableHitCount> getSourceHitCount(EventQueryDefinition query) {
        return this.executeHitCount(query, "source");
    }

    public EventSeries getAuditTrail(EventQueryDefinition query) {
        EventSeries es = new EventSeries();
        for (Row row : this.getCqlSession().execute((Statement)this.buildDynamicStatementAudit(query))) {
            es.add(this.mapEventRow(row));
        }
        return es;
    }

    public void purgeFeatureUsage(EventQueryDefinition query) {
        this.purgeAuditTrail(query);
    }

    public void purgeAuditTrail(EventQueryDefinition query) {
        this.truncateTable(this.getCqlSession(), "ff4j_audit_hitcount");
        this.truncateTable(this.getCqlSession(), "ff4j_audit");
    }

    public EventSeries searchFeatureUsageEvents(EventQueryDefinition query) {
        EventSeries es = new EventSeries();
        for (Row row : this.getCqlSession().execute((Statement)this.buildDynamicStatementHitCount(query))) {
            es.add(this.mapEventHit(row));
        }
        return es;
    }

    public TimeSeriesChart getFeatureUsageHistory(EventQueryDefinition query, TimeUnit units) {
        TimeSeriesChart tsc = new TimeSeriesChart(query.getFrom().longValue(), query.getTo().longValue(), units);
        Iterator iterEvent = this.searchFeatureUsageEvents(query).iterator();
        while (iterEvent.hasNext()) {
            tsc.addEvent((Event)iterEvent.next());
        }
        return tsc;
    }

    protected Event mapEventRow(Row row) {
        Event e = new Event();
        e.setAction(row.getString("action"));
        e.setDuration((long)row.getInt("duration"));
        e.setHostName(row.getString("hostname"));
        e.setName(row.getString("name"));
        e.setSource(row.getString("source"));
        e.setTimestamp(row.getInstant("time").getEpochSecond());
        e.setType(row.getString("type"));
        e.setUser(row.getString("user"));
        e.setValue(row.getString("value"));
        e.setUuid(row.getUuid("uid").toString());
        e.setCustomKeys(row.getMap("custom", String.class, String.class));
        return e;
    }

    protected Event mapEventHit(Row row) {
        Event e = new Event();
        e.setDuration((long)row.getInt("duration"));
        e.setHostName(row.getString("hostname"));
        e.setName(row.getString("name"));
        e.setSource(row.getString("source"));
        e.setTimestamp(row.getInstant("time").getEpochSecond());
        e.setUser(row.getString("user"));
        e.setValue(row.getString("value"));
        e.setUuid(row.getUuid("uid").toString());
        e.setCustomKeys(row.getMap("custom", String.class, String.class));
        return e;
    }

    protected void prepareStatements() {
        this.psInsertEvent = this.cqlSession.prepare(STMT_AUDIT_INSERT);
        this.psInsertEventByType = this.cqlSession.prepare(STMT_AUDIT_INSERT_HITCOUNT);
        this.psReadEventById = this.cqlSession.prepare(STMT_AUDIT_READ_BY_ID);
    }

    private synchronized CqlSession getCqlSession() {
        if (null == this.psInsertEvent) {
            this.prepareStatements();
        }
        return this.cqlSession;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }
}

