/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cassandra.store;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.datastax.oss.driver.shaded.guava.common.base.Functions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ff4j.cassandra.FF4jCassandraSchema;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.util.PropertyFactory;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.MappingUtil;
import org.ff4j.utils.Util;

public class FeatureStoreCassandra
extends AbstractFeatureStore
implements FF4jCassandraSchema {
    private CqlSession cqlSession;
    private UserDefinedType udtStrategy;
    private UserDefinedType udtProperty;
    private PreparedStatement psExistFeature;
    private PreparedStatement psToggleFeature;
    private PreparedStatement psInsertFeature;
    private PreparedStatement psDeleteFeature;
    private PreparedStatement psReadFeature;
    private PreparedStatement psReadGroup;
    private PreparedStatement psAddToGroup;
    private PreparedStatement psRmvFromGroup;
    private PreparedStatement psListGroups;

    public FeatureStoreCassandra() {
    }

    public FeatureStoreCassandra(CqlSession cqlSession) {
        this.cqlSession = cqlSession;
    }

    public void createSchema() {
        this.cqlSession.execute((Statement)STMT_CREATE_UDT_STRATEGY);
        this.cqlSession.execute((Statement)STMT_CREATE_UDT_PROPERTY);
        this.cqlSession.execute((Statement)STMT_CREATE_TABLE_FEATURE);
        this.cqlSession.execute((Statement)STMT_CREATE_INDEX_FEATUREGROUP);
    }

    public boolean exist(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        return this.getCqlSession().execute((Statement)this.psExistFeature.bind(new Object[]{uid})).getAvailableWithoutFetching() > 0;
    }

    public void enable(String uid) {
        this.assertFeatureExist(uid);
        this.getCqlSession().execute((Statement)this.psToggleFeature.bind(new Object[]{true, uid}));
    }

    public void disable(String uid) {
        this.assertFeatureExist(uid);
        this.getCqlSession().execute((Statement)this.psToggleFeature.bind(new Object[]{false, uid}));
    }

    public void create(Feature fp) {
        this.assertFeatureNotNull(fp);
        this.assertFeatureNotExist(fp.getUid());
        BoundStatement bsInsertFeature = this.psInsertFeature.bind(new Object[0]);
        bsInsertFeature = (BoundStatement)bsInsertFeature.setString("uid", fp.getUid());
        bsInsertFeature = (BoundStatement)bsInsertFeature.setBoolean("enabled", fp.isEnable());
        bsInsertFeature = (BoundStatement)bsInsertFeature.setString("description", fp.getDescription());
        if (Util.hasLength((String)fp.getGroup())) {
            bsInsertFeature = (BoundStatement)bsInsertFeature.setString("groupname", fp.getGroup());
        }
        if (null != fp.getPermissions()) {
            bsInsertFeature = (BoundStatement)bsInsertFeature.setSet("roles", fp.getPermissions(), String.class);
        }
        if (null != fp.getFlippingStrategy()) {
            UdtValue newUdtStrategy = this.udtStrategy.newValue();
            FlippingStrategy fStrategy = fp.getFlippingStrategy();
            newUdtStrategy.setString("class", fStrategy.getClass().getName());
            newUdtStrategy.setMap("params", fStrategy.getInitParams(), String.class, String.class);
            bsInsertFeature = (BoundStatement)bsInsertFeature.setUdtValue("strategy", newUdtStrategy);
        }
        if (null != fp.getCustomProperties()) {
            HashMap<String, UdtValue> properties = new HashMap<String, UdtValue>();
            for (Property prop : fp.getCustomProperties().values()) {
                UdtValue currentUdtProp = this.udtProperty.newValue();
                currentUdtProp.setString("uid", prop.getName());
                currentUdtProp.setString("class", prop.getClass().getName());
                currentUdtProp.setString("description", prop.getDescription());
                currentUdtProp.setString("value", prop.asString());
                HashSet<String> fixedValues = new HashSet<String>();
                if (!Util.isEmpty((Collection)prop.getFixedValues())) {
                    for (Object fv : prop.getFixedValues()) {
                        fixedValues.add(fv.toString());
                    }
                }
                currentUdtProp.setSet("fixedvalues", fixedValues, String.class);
                properties.put(prop.getName(), currentUdtProp);
            }
            bsInsertFeature = (BoundStatement)bsInsertFeature.setMap("properties", properties, String.class, UdtValue.class);
        }
        this.getCqlSession().execute((Statement)bsInsertFeature);
    }

    public void delete(String uid) {
        this.assertFeatureExist(uid);
        this.getCqlSession().execute((Statement)this.psDeleteFeature.bind(new Object[]{uid}));
    }

    public Feature read(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        ResultSet rs = this.cqlSession.execute((Statement)this.psReadFeature.bind(new Object[]{uid}));
        Row row = (Row)rs.one();
        if (null == row) {
            throw new FeatureNotFoundException(uid);
        }
        return this.mapFeatureRow(row);
    }

    public Map<String, Feature> readAll() {
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        ResultSet rs = this.cqlSession.execute((Statement)STMT_FEATURE_READ_ALL);
        for (Row row : rs.all()) {
            features.put(row.getString("uid"), this.mapFeatureRow(row));
        }
        return features;
    }

    public void update(Feature fp) {
        this.assertFeatureNotNull(fp);
        this.assertFeatureExist(fp.getUid());
        this.delete(fp.getUid());
        this.create(fp);
    }

    public void grantRoleOnFeature(String uid, String roleName) {
        this.assertFeatureExist(uid);
        Util.assertHasLength((String[])new String[]{roleName});
        this.getCqlSession().execute((Statement)((Update)QueryBuilder.update((String)"ff4j_features").appendSetElement("roles", (Term)QueryBuilder.literal((Object)roleName)).whereColumn("uid").isEqualTo((Term)QueryBuilder.literal((Object)uid))).build());
    }

    public void removeRoleFromFeature(String uid, String roleName) {
        this.assertFeatureExist(uid);
        Util.assertHasLength((String[])new String[]{roleName});
        this.getCqlSession().execute((Statement)((Update)QueryBuilder.update((String)"ff4j_features").removeSetElement("roles", (Term)QueryBuilder.literal((Object)roleName)).whereColumn("uid").isEqualTo((Term)QueryBuilder.literal((Object)uid))).build());
    }

    public void enableGroup(String groupName) {
        this.assertGroupExist(groupName);
        BatchStatementBuilder stmtBatch = BatchStatement.builder((BatchType)BatchType.LOGGED);
        this.readGroup(groupName).values().stream().map(Feature::getUid).forEach(uid -> stmtBatch.addStatement((BatchableStatement)this.psToggleFeature.bind(new Object[]{true, uid})));
        this.getCqlSession().execute((Statement)stmtBatch.build());
    }

    public void disableGroup(String groupName) {
        this.assertGroupExist(groupName);
        BatchStatementBuilder stmtBatch = BatchStatement.builder((BatchType)BatchType.LOGGED);
        this.readGroup(groupName).values().stream().map(Feature::getUid).forEach(uid -> stmtBatch.addStatement((BatchableStatement)this.psToggleFeature.bind(new Object[]{false, uid})));
        this.getCqlSession().execute((Statement)stmtBatch.build());
    }

    public boolean existGroup(String groupName) {
        Util.assertHasLength((String[])new String[]{groupName});
        return this.getCqlSession().execute((Statement)this.psReadGroup.bind(new Object[]{groupName})).getAvailableWithoutFetching() > 0;
    }

    public Map<String, Feature> readGroup(String groupName) {
        this.assertGroupExist(groupName);
        return this.getCqlSession().execute((Statement)this.psReadGroup.bind(new Object[]{groupName})).all().stream().map(this::mapFeatureRow).collect(Collectors.toMap(Feature::getUid, Functions.identity()));
    }

    public void addToGroup(String uid, String groupName) {
        this.assertFeatureExist(uid);
        Util.assertHasLength((String[])new String[]{groupName});
        this.getCqlSession().execute((Statement)this.psAddToGroup.bind(new Object[]{groupName, uid}));
    }

    public void removeFromGroup(String uid, String groupName) {
        this.assertFeatureExist(uid);
        this.assertGroupExist(groupName);
        Feature feat = this.read(uid);
        if (feat.getGroup() != null && !feat.getGroup().equals(groupName)) {
            throw new IllegalArgumentException("'" + uid + "' is not in group '" + groupName + "'");
        }
        this.getCqlSession().execute((Statement)this.psRmvFromGroup.bind(new Object[]{uid}));
    }

    public Set<String> readAllGroups() {
        List rows = this.cqlSession.execute((Statement)this.psListGroups.bind(new Object[0])).all();
        HashSet<String> groupNames = new HashSet<String>();
        if (null != rows) {
            rows.stream().map(r -> r.getString("groupname")).forEach(groupNames::add);
        }
        groupNames.remove(null);
        groupNames.remove("");
        return groupNames;
    }

    public void clear() {
        this.getCqlSession().execute((Statement)QueryBuilder.truncate((String)"ff4j_features").build());
    }

    protected void prepareStatements() {
        this.udtStrategy = (UserDefinedType)this.cqlSession.getMetadata().getKeyspace((CqlIdentifier)this.cqlSession.getKeyspace().get()).flatMap(ks -> ks.getUserDefinedType("ff4j_udt_strategy")).orElseThrow(() -> new IllegalArgumentException("Missing UDT 'ff4j_udt_strategy'"));
        this.udtProperty = (UserDefinedType)this.cqlSession.getMetadata().getKeyspace((CqlIdentifier)this.cqlSession.getKeyspace().get()).flatMap(ks -> ks.getUserDefinedType("ff4j_udt_property")).orElseThrow(() -> new IllegalArgumentException("Missing UDT 'ff4j_udt_property'"));
        this.psReadFeature = this.cqlSession.prepare(STMT_FEATURE_READ);
        this.psExistFeature = this.cqlSession.prepare(STMT_FEATURE_EXIST);
        this.psToggleFeature = this.cqlSession.prepare(STMT_FEATURE_TOGGLE);
        this.psInsertFeature = this.cqlSession.prepare(STMT_FEATURE_INSERT);
        this.psDeleteFeature = this.cqlSession.prepare(STMT_FEATURE_DELETE);
        this.psReadGroup = this.cqlSession.prepare(STMT_FEATUREGROUP_READ);
        this.psAddToGroup = this.cqlSession.prepare(STMT_FEATURE_ADDTOGROUP);
        this.psRmvFromGroup = this.cqlSession.prepare(STMT_FEATURE_REMOVEGROUP);
        this.psListGroups = this.cqlSession.prepare(STMT_FEATUREGROUP_LIST);
    }

    protected Feature mapFeatureRow(Row row) {
        Map mapOfProperties;
        Feature f = new Feature(row.getString("uid"));
        f.setDescription(row.getString("description"));
        f.setEnable(row.getBoolean("enabled"));
        f.setGroup(row.getString("groupname"));
        f.setPermissions(row.getSet("roles", String.class));
        UdtValue udtStrat = row.getUdtValue("strategy");
        if (null != udtStrat) {
            String className = udtStrat.getString("class");
            Map initparams = udtStrat.getMap("params", String.class, String.class);
            f.setFlippingStrategy(MappingUtil.instanceFlippingStrategy((String)f.getUid(), (String)className, (Map)initparams));
        }
        if ((mapOfProperties = row.getMap("properties", String.class, UdtValue.class)) != null) {
            HashMap<String, Property> customProperties = new HashMap<String, Property>();
            for (UdtValue udt : mapOfProperties.values()) {
                String propName = udt.getString("uid");
                String propClass = udt.getString("class");
                String propDesc = udt.getString("description");
                String propVal = udt.getString("value");
                Set fixV = udt.getSet("fixedvalues", String.class);
                Property p = PropertyFactory.createProperty((String)propName, (String)propClass, (String)propVal, (String)propDesc, (Set)fixV);
                customProperties.put(p.getName(), p);
            }
            f.setCustomProperties(customProperties);
        }
        return f;
    }

    private synchronized CqlSession getCqlSession() {
        if (null == this.psExistFeature) {
            this.prepareStatements();
        }
        return this.cqlSession;
    }
}

