/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cassandra.store;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ff4j.cassandra.FF4jCassandraSchema;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.property.util.PropertyFactory;
import org.ff4j.utils.Util;

public class PropertyStoreCassandra
extends AbstractPropertyStore
implements FF4jCassandraSchema {
    private final CqlSession cqlSession;
    private PreparedStatement psExistProperty;
    private PreparedStatement psInsertProperty;
    private PreparedStatement psReadProperty;
    private PreparedStatement psDeleteProperty;

    public PropertyStoreCassandra(CqlSession cqlSession) {
        this.cqlSession = cqlSession;
    }

    public void createSchema() {
        this.cqlSession.execute((Statement)STMT_CREATE_TABLE_PROPERTY);
    }

    public boolean existProperty(String name) {
        Util.assertHasLength((String[])new String[]{name});
        return this.getCqlSession().execute((Statement)this.psExistProperty.bind(new Object[]{name})).getAvailableWithoutFetching() > 0;
    }

    public <T> void createProperty(Property<T> prop) {
        this.assertPropertyNotNull(prop);
        this.assertPropertyNotExist(prop.getName());
        HashSet<String> fixedValues = new HashSet<String>();
        if (prop.getFixedValues() != null) {
            for (Object fixedValue : prop.getFixedValues()) {
                fixedValues.add(fixedValue.toString());
            }
        }
        BoundStatement bsInsertProperty = this.psInsertProperty.bind(new Object[0]);
        bsInsertProperty = (BoundStatement)bsInsertProperty.setString("uid", prop.getName());
        bsInsertProperty = (BoundStatement)bsInsertProperty.setString("class", prop.getClass().getName());
        bsInsertProperty = (BoundStatement)bsInsertProperty.setString("value", prop.asString());
        bsInsertProperty = (BoundStatement)bsInsertProperty.setString("description", prop.getDescription());
        bsInsertProperty = (BoundStatement)bsInsertProperty.setSet("fixedvalues", fixedValues, String.class);
        this.cqlSession.execute((Statement)bsInsertProperty);
    }

    public Property<?> readProperty(String name) {
        this.assertPropertyExist(name);
        ResultSet rs = this.cqlSession.execute((Statement)this.psReadProperty.bind(new Object[]{name}));
        Row row = (Row)rs.one();
        if (null == row) {
            throw new PropertyNotFoundException(name);
        }
        return this.mapPropertyRow(row);
    }

    public void deleteProperty(String name) {
        this.assertPropertyExist(name);
        this.cqlSession.execute((Statement)this.psDeleteProperty.bind(new Object[]{name}));
    }

    public Map<String, Property<?>> readAllProperties() {
        HashMap properties = new HashMap();
        ResultSet rs = this.cqlSession.execute((Statement)STMT_PROPERTY_READ_ALL);
        for (Row row : rs.all()) {
            Property<?> p = this.mapPropertyRow(row);
            properties.put(p.getName(), p);
        }
        return properties;
    }

    public Set<String> listPropertyNames() {
        return this.cqlSession.execute((Statement)STMT_PROPERTY_LISTNAMES).all().stream().map(r -> r.getString("uid")).collect(Collectors.toSet());
    }

    public void clear() {
        this.cqlSession.execute((Statement)QueryBuilder.truncate((String)"ff4j_properties").build());
    }

    protected void prepareStatements() {
        this.psExistProperty = this.cqlSession.prepare(STMT_PROPERTY_EXIST);
        this.psInsertProperty = this.cqlSession.prepare(STMT_PROPERTY_INSERT);
        this.psReadProperty = this.cqlSession.prepare(STMT_PROPERTY_READ);
        this.psDeleteProperty = this.cqlSession.prepare(STMT_PROPERTY_DELETE);
    }

    protected Property<?> mapPropertyRow(Row row) {
        String propName = row.getString("uid");
        String propClass = row.getString("class");
        String propDesc = row.getString("description");
        String propVal = row.getString("value");
        Set fixV = row.getSet("fixedvalues", String.class);
        return PropertyFactory.createProperty((String)propName, (String)propClass, (String)propVal, (String)propDesc, (Set)fixV);
    }

    private synchronized CqlSession getCqlSession() {
        if (null == this.psExistProperty) {
            this.prepareStatements();
        }
        return this.cqlSession;
    }
}

