/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.mongo.mapper;

import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.ff4j.audit.EventQueryDefinition;

public final class EventDocumentBuilder {
    private final Document builder = new Document();

    public Document getEventUuid(String value) {
        return new Document("id", (Object)value);
    }

    public EventDocumentBuilder addEventUuid(String value) {
        this.builder.append("id", (Object)value);
        return this;
    }

    public Document getName(String value) {
        return new Document("name", (Object)value);
    }

    public EventDocumentBuilder addName(String value) {
        this.builder.append("name", (Object)value);
        return this;
    }

    public Document getHost(String value) {
        return new Document("hostName", (Object)value);
    }

    public EventDocumentBuilder addHost(String value) {
        this.builder.append("hostName", (Object)value);
        return this;
    }

    public Document getUser(String value) {
        return new Document("user", (Object)value);
    }

    public EventDocumentBuilder addUser(String value) {
        this.builder.append("user", (Object)value);
        return this;
    }

    public Document getSource(String value) {
        return new Document("source", (Object)value);
    }

    public EventDocumentBuilder addSource(String value) {
        this.builder.append("source", (Object)value);
        return this;
    }

    public Document getType(String value) {
        return new Document("type", (Object)value);
    }

    public EventDocumentBuilder addType(String value) {
        this.builder.append("type", (Object)value);
        return this;
    }

    public Document getAction(String value) {
        return new Document("action", (Object)value);
    }

    public EventDocumentBuilder addAction(String value) {
        this.builder.append("action", (Object)value);
        return this;
    }

    public List<Bson> getSelectFeatureUsageFilters(EventQueryDefinition eqd) {
        return this.buildFilters(eqd, true, false);
    }

    public List<Bson> getSelectAuditTrailFilters(EventQueryDefinition eqd) {
        return this.buildFilters(eqd, false, true);
    }

    public List<Bson> getPurgeAuditTrailFilters(EventQueryDefinition eqd) {
        return this.buildFilters(eqd, false, true);
    }

    public List<Bson> getPurgeFeatureUsageFilters(EventQueryDefinition eqd) {
        return this.buildFilters(eqd, true, false);
    }

    public List<Bson> buildHitCountFilters(EventQueryDefinition qDef, String attr) {
        return Arrays.asList(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)"type", (Object)"feature"), Filters.eq((String)"action", (Object)"checkOn"), Filters.gte((String)"timestamp", (Object)qDef.getFrom()), Filters.lte((String)"timestamp", (Object)qDef.getTo())})), Aggregates.group((Object)("$" + attr), (BsonField[])new BsonField[]{Accumulators.sum((String)"NB", (Object)1)}));
    }

    public List<Bson> buildFilters(EventQueryDefinition qDef, boolean filterForCheck, boolean filterAuditTrail) {
        ArrayList<Bson> filters = new ArrayList<Bson>();
        filters.add(Filters.gte((String)"timestamp", (Object)qDef.getFrom()));
        filters.add(Filters.lte((String)"timestamp", (Object)qDef.getTo()));
        if (qDef.getActionFilters().isEmpty()) {
            if (filterForCheck) {
                qDef.getActionFilters().add("checkOn");
            }
            if (filterAuditTrail) {
                qDef.getActionFilters().add("connect");
                qDef.getActionFilters().add("disconnect");
                qDef.getActionFilters().add("toggle-on");
                qDef.getActionFilters().add("toggle-off");
                qDef.getActionFilters().add("create");
                qDef.getActionFilters().add("delete");
                qDef.getActionFilters().add("update");
                qDef.getActionFilters().add("clear");
            }
        }
        if (qDef.getActionFilters() != null && !qDef.getActionFilters().isEmpty()) {
            filters.add(Filters.in((String)"action", (Iterable)qDef.getActionFilters()));
        }
        if (qDef.getHostFilters() != null && !qDef.getHostFilters().isEmpty()) {
            filters.add(Filters.in((String)"hostName", (Iterable)qDef.getHostFilters()));
        }
        if (qDef.getNamesFilter() != null && !qDef.getNamesFilter().isEmpty()) {
            filters.add(Filters.in((String)"name", (Iterable)qDef.getNamesFilter()));
        }
        if (qDef.getSourceFilters() != null && !qDef.getSourceFilters().isEmpty()) {
            filters.add(Filters.in((String)"source", (Iterable)qDef.getSourceFilters()));
        }
        return filters;
    }

    public Document build() {
        return this.builder;
    }
}

