/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.mongo.mapper;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.util.ArrayList;
import org.bson.Document;
import org.ff4j.mapper.PropertyMapper;
import org.ff4j.mongo.mapper.PropertyDocumentBuilder;
import org.ff4j.property.Property;
import org.ff4j.property.util.PropertyJsonBean;

public class MongoPropertyMapper
implements PropertyMapper<Document> {
    public Document toStore(Property<?> bean) {
        PropertyJsonBean pjb = new PropertyJsonBean(bean);
        return new PropertyDocumentBuilder().addName(pjb.getName()).addType(pjb.getType()).addValue(pjb.getValue()).addDescription(pjb.getDescription()).addFixedValues(pjb.getFixedValues()).build();
    }

    public Property<?> fromStore(Document dbObject) {
        ArrayList dbList;
        PropertyJsonBean pf = new PropertyJsonBean();
        pf.setName((String)dbObject.get((Object)"name"));
        pf.setDescription((String)dbObject.get((Object)"description"));
        pf.setType((String)dbObject.get((Object)"type"));
        pf.setValue((String)dbObject.get((Object)"value"));
        if (dbObject.containsKey((Object)"fixedValues") && (dbList = (ArrayList)dbObject.get((Object)"fixedValues")) != null) {
            for (Object item : dbList) {
                pf.addFixedValue((String)item);
            }
        }
        return pf.asProperty();
    }

    public Property<?> fromStore(DBObject dbObject) {
        BasicDBList dbList;
        PropertyJsonBean pf = new PropertyJsonBean();
        pf.setName((String)dbObject.get("name"));
        pf.setDescription((String)dbObject.get("description"));
        pf.setType((String)dbObject.get("type"));
        pf.setValue((String)dbObject.get("value"));
        if (dbObject.containsField("fixedValues") && (dbList = (BasicDBList)dbObject.get("fixedValues")) != null) {
            for (Object item : dbList) {
                pf.addFixedValue((String)item);
            }
        }
        return pf.asProperty();
    }
}

