/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.mongo.store;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.EventSeries;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.TimeSeriesChart;
import org.ff4j.audit.repository.AbstractEventRepository;
import org.ff4j.exception.AuditAccessException;
import org.ff4j.mongo.mapper.EventDocumentBuilder;
import org.ff4j.mongo.mapper.MongoEventMapper;
import org.ff4j.utils.Util;

public class EventRepositoryMongo
extends AbstractEventRepository {
    private static final MongoEventMapper eventMapper = new MongoEventMapper();
    private static final EventDocumentBuilder eventDocumentBuilder = new EventDocumentBuilder();
    private MongoCollection<Document> eventsCollection;
    private static final String collectionName = "ff4j_event";
    public static final String EVENT_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY = "Event identifier cannot be null nor empty";
    private String dbName = "ff4j";
    private MongoClient mongoClient;

    public EventRepositoryMongo(MongoClient client) {
        this(client, "ff4j");
    }

    public EventRepositoryMongo(MongoClient client, String dbName) {
        this.dbName = dbName;
        this.mongoClient = client;
        this.eventsCollection = this.getEventCollection();
    }

    public EventRepositoryMongo(MongoCollection<Document> events) {
        this.eventsCollection = events;
    }

    public EventRepositoryMongo(MongoDatabase db) {
        this(db, collectionName);
    }

    public EventRepositoryMongo(MongoDatabase db, String collectionName) {
        this.eventsCollection = db.getCollection(collectionName);
    }

    public MongoCollection<Document> getEventCollection() {
        if (this.eventsCollection == null) {
            if (this.mongoClient != null) {
                this.createSchema();
            } else {
                throw new IllegalStateException("Cannot initialize Features collection : no mongo client defined");
            }
        }
        return this.eventsCollection;
    }

    public void createSchema() {
        if (!((HashSet)this.mongoClient.getDatabase(this.dbName).listCollectionNames().into(new HashSet())).contains(collectionName)) {
            this.mongoClient.getDatabase(this.dbName).createCollection(collectionName);
        }
        this.eventsCollection = this.mongoClient.getDatabase(this.dbName).getCollection(collectionName);
    }

    public boolean saveEvent(Event e) {
        if (e == null) {
            throw new IllegalArgumentException("Event cannot be null nor empty");
        }
        this.eventsCollection.insertOne((Object)eventMapper.toStore(e));
        return true;
    }

    public Event getEventByUUID(String uuid, Long timestamp) {
        if (uuid == null || uuid.isEmpty()) {
            throw new IllegalArgumentException(EVENT_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        Document object = (Document)this.getEventCollection().find((Bson)eventDocumentBuilder.getEventUuid(uuid)).first();
        if (object == null) {
            throw new AuditAccessException(uuid);
        }
        return eventMapper.fromStore(object);
    }

    public Map<String, MutableHitCount> getFeatureUsageHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "name");
    }

    public Map<String, MutableHitCount> getHostHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "hostName");
    }

    public Map<String, MutableHitCount> getUserHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "user");
    }

    public Map<String, MutableHitCount> getSourceHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "source");
    }

    private Map<String, MutableHitCount> computeHitCount(EventQueryDefinition query, String attr) {
        HashMap<String, MutableHitCount> mapofHitCount = new HashMap<String, MutableHitCount>();
        this.getEventCollection().aggregate(eventDocumentBuilder.buildHitCountFilters(query, attr)).forEach(document -> {
            if (null != document.get((Object)"_id")) {
                mapofHitCount.put(document.get((Object)"_id").toString(), new MutableHitCount(((Integer)document.get((Object)"NB")).intValue()));
            } else {
                mapofHitCount.put(attr, new MutableHitCount(0));
            }
        });
        return mapofHitCount;
    }

    public TimeSeriesChart getFeatureUsageHistory(EventQueryDefinition query, TimeUnit tu) {
        TimeSeriesChart tsc = new TimeSeriesChart(query.getFrom().longValue(), query.getTo().longValue(), tu);
        for (Event event : this.searchFeatureUsageEvents(query)) {
            tsc.addEvent(event);
        }
        return tsc;
    }

    public EventSeries searchFeatureUsageEvents(EventQueryDefinition qDef) {
        return this.searchEvents(eventDocumentBuilder.getSelectFeatureUsageFilters(qDef));
    }

    public EventSeries getAuditTrail(EventQueryDefinition qDef) {
        return this.searchEvents(eventDocumentBuilder.getSelectAuditTrailFilters(qDef));
    }

    public void purgeAuditTrail(EventQueryDefinition qDef) {
        Util.assertNotNull((Object[])new Object[]{qDef});
        this.getEventCollection().deleteMany(Filters.and(eventDocumentBuilder.getPurgeAuditTrailFilters(qDef)));
    }

    public void purgeFeatureUsage(EventQueryDefinition qDef) {
        Util.assertNotNull((Object[])new Object[]{qDef});
        this.getEventCollection().deleteMany(Filters.and(eventDocumentBuilder.getPurgeFeatureUsageFilters(qDef)));
    }

    private EventSeries searchEvents(List<Bson> filters) {
        EventSeries es = new EventSeries();
        this.getEventCollection().find(Filters.and(filters)).forEach(document -> es.add(eventMapper.fromStore((Document)document)));
        return es;
    }
}

