/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.mongo.mapper;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.mapper.FeatureMapper;
import org.ff4j.mongo.mapper.FeatureDocumentBuilder;
import org.ff4j.mongo.mapper.MongoPropertyMapper;
import org.ff4j.property.Property;
import org.ff4j.utils.JsonUtils;
import org.ff4j.utils.MappingUtil;

public class MongoFeatureMapper
implements FeatureMapper<Document> {
    private static final MongoPropertyMapper PMAPPER = new MongoPropertyMapper();

    public Feature fromStore(Document document) {
        String featUid = document.getString((Object)"_id");
        boolean status = document.getBoolean((Object)"enable");
        Feature f = new Feature(featUid, status);
        f.setDescription(document.getString((Object)"description"));
        f.setGroup(document.getString((Object)"groupname"));
        f.setPermissions(this.mapAuthorization(document));
        f.setFlippingStrategy(this.mapStrategy(featUid, document));
        f.setCustomProperties(this.mapCustomProperties(document));
        return f;
    }

    private Set<String> mapAuthorization(Document document) {
        HashSet<String> authorisation = new HashSet<String>();
        if (document.containsKey((Object)"roles")) {
            for (Object role : (Iterable)document.get((Object)"roles")) {
                authorisation.add(role.toString());
            }
        }
        return authorisation;
    }

    private FlippingStrategy mapStrategy(String featUid, Document document) {
        String strategy = (String)document.get((Object)"strategy");
        Map initParams = MappingUtil.toMap((String)((String)document.get((Object)"expression")));
        if (strategy != null && !"".equals(strategy)) {
            return MappingUtil.instanceFlippingStrategy((String)featUid, (String)strategy, (Map)initParams);
        }
        return (FlippingStrategy)document.get((Object)"strategy", FlippingStrategy.class);
    }

    private Map<String, Property<?>> mapCustomProperties(Document dbObject) {
        HashMap mapOfCustomProperties = new HashMap();
        if (dbObject.containsKey((Object)"customProperties")) {
            String properties = (String)dbObject.get((Object)"customProperties");
            BasicDBObject values = BasicDBObject.parse((String)properties);
            for (Map.Entry entry : values.entrySet()) {
                mapOfCustomProperties.put((String)entry.getKey(), PMAPPER.fromStore((DBObject)entry.getValue()));
            }
        }
        return mapOfCustomProperties;
    }

    public Document toStore(Feature feature) {
        String strategyColumn = null;
        String expressionColumn = null;
        if (feature.getFlippingStrategy() != null) {
            strategyColumn = feature.getFlippingStrategy().getClass().getName();
            expressionColumn = MappingUtil.fromMap((Map)feature.getFlippingStrategy().getInitParams());
        }
        String customProperties = null;
        if (feature.getCustomProperties() != null) {
            customProperties = JsonUtils.customPropertiesAsJson((Map)feature.getCustomProperties());
        }
        return new FeatureDocumentBuilder().addFeatUid(feature.getUid()).addEnable(feature.isEnable()).addDescription(feature.getDescription()).addGroupName(feature.getGroup()).addStrategy(strategyColumn).addExpression(expressionColumn).addCustomProperties(customProperties).addRoles(feature.getPermissions()).build();
    }
}

