/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.mongo.store;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.mongo.mapper.FeatureDocumentBuilder;
import org.ff4j.mongo.mapper.MongoFeatureMapper;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;

public class FeatureStoreMongo
extends AbstractFeatureStore {
    private static final MongoFeatureMapper FMAPPER = new MongoFeatureMapper();
    private static final FeatureDocumentBuilder BUILDER = new FeatureDocumentBuilder();
    public static final String FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY = "Feature identifier cannot be null nor empty";
    public static final String GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY = "Groupname cannot be null nor empty";
    private MongoCollection<Document> featuresCollection;
    private String collectionName = "ff4j_feature";
    private String dbName = "ff4j";
    private MongoClient mongoClient;

    public FeatureStoreMongo() {
    }

    public FeatureStoreMongo(MongoClient client) {
        this(client, "ff4j");
    }

    public FeatureStoreMongo(MongoClient client, String dbName) {
        this.dbName = dbName;
        this.mongoClient = client;
        this.featuresCollection = this.getFeaturesCollection();
    }

    public FeatureStoreMongo(MongoClient client, String dbName, String collectionName) {
        this.mongoClient = client;
        this.collectionName = collectionName;
        this.dbName = dbName;
        this.featuresCollection = this.getFeaturesCollection();
    }

    public FeatureStoreMongo(MongoDatabase db, MongoClient client) {
        this(db, "ff4j_feature");
        this.mongoClient = client;
    }

    public FeatureStoreMongo(MongoDatabase db, String collectionName) {
        this.dbName = db.getName();
        this.featuresCollection = db.getCollection(collectionName);
    }

    public FeatureStoreMongo(MongoCollection<Document> collection) {
        this.featuresCollection = collection;
    }

    public FeatureStoreMongo(MongoCollection<Document> collection, String xmlConfFile) {
        this(collection);
        this.importFeaturesFromXmlFile(xmlConfFile);
    }

    public void enable(String featId) {
        this.updateStatus(featId, true);
    }

    public void disable(String featId) {
        this.updateStatus(featId, false);
    }

    private void updateStatus(String uid, boolean enable) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        Document target = BUILDER.getFeatUid(uid);
        Document enabledd = BUILDER.getEnable(enable);
        this.getFeaturesCollection().updateOne((Bson)target, (Bson)new Document("$set", (Object)enabledd));
    }

    public boolean exist(String featId) {
        Util.assertHasLength((String[])new String[]{featId});
        return 1L == this.getFeaturesCollection().countDocuments((Bson)BUILDER.getFeatUid(featId));
    }

    public Feature read(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        Document object = (Document)this.getFeaturesCollection().find((Bson)BUILDER.getFeatUid(uid)).first();
        if (object == null) {
            throw new FeatureNotFoundException(uid);
        }
        return FMAPPER.fromStore(object);
    }

    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        this.getFeaturesCollection().insertOne((Object)FMAPPER.toStore(fp));
    }

    public void delete(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getFeaturesCollection().deleteOne((Bson)BUILDER.getFeatUid(uid));
    }

    public void grantRoleOnFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getFeaturesCollection().updateOne((Bson)BUILDER.getFeatUid(uid), (Bson)new Document("$addToSet", (Object)BUILDER.getRoles(roleName)));
    }

    public void removeRoleFromFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.getFeaturesCollection().updateOne((Bson)BUILDER.getFeatUid(uid), (Bson)new Document("$pull", (Object)BUILDER.getRoles(roleName)));
    }

    public Map<String, Feature> readAll() {
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        for (Document document : this.getFeaturesCollection().find()) {
            Feature feature = FMAPPER.fromStore(document);
            mapFP.put(feature.getUid(), feature);
        }
        return mapFP;
    }

    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        this.read(fp.getUid());
        this.getFeaturesCollection().updateOne((Bson)BUILDER.getFeatUid(fp.getUid()), (Bson)new Document("$set", (Object)FMAPPER.toStore(fp)));
    }

    public boolean existGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        return this.getFeaturesCollection().countDocuments((Bson)BUILDER.getGroupName(groupName)) > 0L;
    }

    public Set<String> readAllGroups() {
        HashSet<String> setOfGroups = new HashSet<String>();
        for (Document document : this.getFeaturesCollection().find()) {
            setOfGroups.add(document.getString((Object)"groupname"));
        }
        setOfGroups.remove(null);
        setOfGroups.remove("");
        return setOfGroups;
    }

    public Map<String, Feature> readGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        for (Document document : this.getFeaturesCollection().find((Bson)BUILDER.getGroupName(groupName))) {
            Feature feature = FMAPPER.fromStore(document);
            mapFP.put(feature.getUid(), feature);
        }
        return mapFP;
    }

    public void enableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        for (Document document : this.getFeaturesCollection().find((Bson)BUILDER.getGroupName(groupName))) {
            Document enabled = BUILDER.getEnable(true);
            this.getFeaturesCollection().updateOne((Bson)document, (Bson)new Document("$set", (Object)enabled));
        }
    }

    public void disableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        for (Document document : this.getFeaturesCollection().find((Bson)BUILDER.getGroupName(groupName))) {
            Document enabled = BUILDER.getEnable(false);
            this.getFeaturesCollection().updateOne((Bson)document, (Bson)new Document("$set", (Object)enabled));
        }
    }

    public void addToGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        Document target = BUILDER.getFeatUid(uid);
        Document nGroupName = BUILDER.getGroupName(groupName);
        this.getFeaturesCollection().updateOne((Bson)target, (Bson)new Document("$set", (Object)nGroupName));
    }

    public void removeFromGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException(FEATURE_IDENTIFIER_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException(GROUPNAME_CANNOT_BE_NULL_NOR_EMPTY);
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        Document target = BUILDER.getFeatUid(uid);
        Document nGroupName = BUILDER.getGroupName("");
        this.getFeaturesCollection().updateOne((Bson)target, (Bson)new Document("$set", (Object)nGroupName));
    }

    public void clear() {
        this.getFeaturesCollection().deleteMany((Bson)new Document());
    }

    public void createSchema() {
        if (!((HashSet)this.mongoClient.getDatabase(this.dbName).listCollectionNames().into(new HashSet())).contains(this.collectionName)) {
            this.mongoClient.getDatabase(this.dbName).createCollection(this.collectionName);
        }
        this.featuresCollection = this.mongoClient.getDatabase(this.dbName).getCollection(this.collectionName);
    }

    public MongoCollection<Document> getFeaturesCollection() {
        if (this.featuresCollection == null) {
            if (this.mongoClient != null) {
                this.createSchema();
            } else {
                throw new IllegalStateException("Cannot initialize Features collection : no mongo client defined");
            }
        }
        return this.featuresCollection;
    }
}

