/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.mongo.store;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.mongo.mapper.MongoPropertyMapper;
import org.ff4j.mongo.mapper.PropertyDocumentBuilder;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.utils.Util;

public class PropertyStoreMongo
extends AbstractPropertyStore {
    private MongoPropertyMapper PMAPPER = new MongoPropertyMapper();
    private static final PropertyDocumentBuilder BUILDER = new PropertyDocumentBuilder();
    private MongoCollection<Document> propertiesCollection;
    private String collectionName = "ff4j_property";
    private String dbName = "ff4j";
    private MongoClient mongoClient;

    public PropertyStoreMongo() {
    }

    public PropertyStoreMongo(MongoClient client, String dbName) {
        this.dbName = dbName;
        this.mongoClient = client;
        this.propertiesCollection = this.getPropertiesCollection();
    }

    public PropertyStoreMongo(MongoClient client) {
        this(client, "ff4j");
    }

    public PropertyStoreMongo(MongoClient client, String dbName, String collectionName) {
        this.mongoClient = client;
        this.collectionName = collectionName;
        this.dbName = dbName;
        this.propertiesCollection = this.getPropertiesCollection();
    }

    public PropertyStoreMongo(MongoDatabase db) {
        this(db, "ff4j_property");
    }

    public PropertyStoreMongo(MongoDatabase db, String collectionName) {
        this.propertiesCollection = db.getCollection(collectionName);
        this.dbName = db.getName();
    }

    public PropertyStoreMongo(MongoCollection<Document> collection) {
        this.propertiesCollection = collection;
    }

    public PropertyStoreMongo(MongoCollection<Document> collection, String xmlConfFile) {
        this(collection);
        this.importPropertiesFromXmlFile(xmlConfFile);
    }

    public boolean existProperty(String name) {
        Util.assertHasLength((String[])new String[]{name});
        return 1L == this.getPropertiesCollection().countDocuments((Bson)BUILDER.getName(name));
    }

    public <T> void createProperty(Property<T> prop) {
        if (prop == null) {
            throw new IllegalArgumentException("Property cannot be null nor empty");
        }
        if (this.existProperty(prop.getName())) {
            throw new PropertyAlreadyExistException(prop.getName());
        }
        this.getPropertiesCollection().insertOne((Object)this.PMAPPER.toStore(prop));
    }

    public Property<?> readProperty(String name) {
        this.assertPropertyExist(name);
        Document object = (Document)this.getPropertiesCollection().find((Bson)BUILDER.getName(name)).first();
        return null != object ? this.PMAPPER.fromStore(object) : null;
    }

    public void deleteProperty(String name) {
        this.assertPropertyExist(name);
        this.getPropertiesCollection().deleteOne((Bson)BUILDER.getName(name));
    }

    public void clear() {
        this.getPropertiesCollection().deleteMany((Bson)new Document());
    }

    public void updateProperty(String name, String newValue) {
        this.assertPropertyExist(name);
        this.readProperty(name).fromString(newValue);
        Document query = BUILDER.getName(name);
        Document update = BUILDER.getValue(newValue);
        this.getPropertiesCollection().updateOne((Bson)query, (Bson)new Document("$set", (Object)update));
    }

    public <T> void updateProperty(Property<T> prop) {
        Util.assertNotNull((Object[])new Object[]{prop});
        this.deleteProperty(prop.getName());
        this.createProperty(prop);
    }

    public Map<String, Property<?>> readAllProperties() {
        LinkedHashMap mapP = new LinkedHashMap();
        for (Document document : this.getPropertiesCollection().find()) {
            Property<?> prop = this.PMAPPER.fromStore(document);
            mapP.put(prop.getName(), prop);
        }
        return mapP;
    }

    public Set<String> listPropertyNames() {
        return this.readAllProperties().keySet();
    }

    public void createSchema() {
        if (!((HashSet)this.mongoClient.getDatabase(this.dbName).listCollectionNames().into(new HashSet())).contains(this.collectionName)) {
            this.mongoClient.getDatabase(this.dbName).getCollection(this.collectionName);
        }
        this.propertiesCollection = this.mongoClient.getDatabase(this.dbName).getCollection(this.collectionName);
    }

    public MongoCollection<Document> getPropertiesCollection() {
        if (this.propertiesCollection == null) {
            if (this.mongoClient != null) {
                this.createSchema();
            } else {
                throw new IllegalStateException("Cannot initialize Properties collection : no mongo client defined");
            }
        }
        return this.propertiesCollection;
    }
}

