/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.redis;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

public class RedisConnection {
    protected String redisHost = "localhost";
    protected int redisport = 6379;
    protected String redisPassword = null;
    protected boolean redisSsl = false;
    protected int redisPoolMaxTotal = 8;
    protected int redisPoolTimeout = 2000;
    protected Pool<Jedis> jedisPool;

    public RedisConnection() {
    }

    public RedisConnection(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }

    public RedisConnection(String predisHost, int predisPort) {
        this.redisHost = predisHost;
        this.redisport = predisPort;
    }

    public RedisConnection(String predisHost, int predisPort, String password) {
        this(predisHost, predisPort);
        this.redisPassword = password;
    }

    public RedisConnection(String predisHost, int predisPort, String password, boolean ssl) {
        this(predisHost, predisPort);
        this.redisPassword = password;
        this.redisSsl = ssl;
    }

    public String getRedisHost() {
        return this.redisHost;
    }

    public int getRedisport() {
        return this.redisport;
    }

    @Deprecated
    public String getRedisPassword() {
        return this.redisPassword;
    }

    public Jedis getJedis() {
        if (this.jedisPool == null) {
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, this.redisHost, this.redisport, this.redisPoolTimeout, this.redisPassword, this.redisSsl);
        }
        return (Jedis)this.jedisPool.getResource();
    }

    public void destroyPool() {
        if (this.jedisPool != null) {
            this.jedisPool.destroy();
        }
    }

    public void setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
    }

    public void setRedisHost(String redisHost) {
        this.redisHost = redisHost;
    }

    public void setRedisport(int redisport) {
        this.redisport = redisport;
    }

    public int getRedisPoolMaxTotal() {
        return this.redisPoolMaxTotal;
    }

    public void setRedisPoolMaxTotal(int redisPoolMaxTotal) {
        this.redisPoolMaxTotal = redisPoolMaxTotal;
    }

    public long getRedisPoolTimeout() {
        return this.redisPoolTimeout;
    }

    public void setRedisPoolTimeout(int redisPoolTimeout) {
        this.redisPoolTimeout = redisPoolTimeout;
    }

    public Pool<Jedis> getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }
}

