/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.redis;

import java.text.SimpleDateFormat;
import java.util.Date;

public class RedisKeysBuilder {
    private static final SimpleDateFormat SDF_KEY = new SimpleDateFormat("yyyyMMdd");
    private static final String DEFAULT_KEY_PREFIX = "FF4J_";
    private static final String DEFAULT_KEY_SUFFIX = "";
    public static final String KEY_EVENT = "FF4J_EVENT_AUDITRAIL_";
    public String keyPrefix = "FF4J_";
    public String keySuffix = "";

    public RedisKeysBuilder() {
        this(DEFAULT_KEY_PREFIX, DEFAULT_KEY_SUFFIX);
    }

    public RedisKeysBuilder(String prefix) {
        this(prefix, DEFAULT_KEY_SUFFIX);
    }

    public RedisKeysBuilder(String prefix, String suffix) {
        if (null != prefix) {
            this.keyPrefix = prefix;
        }
        if (null != suffix) {
            this.keySuffix = suffix;
        }
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public String getKeySuffix() {
        return this.keySuffix;
    }

    public String getKeyFeatureMap() {
        return this.getKeyPrefix() + "FEATURE_MAP" + this.getKeySuffix();
    }

    public String getKeyFeature(String id) {
        return this.getKeyPrefix() + "FEATURE_" + id + this.getKeySuffix();
    }

    public String getKeyPropertyMap() {
        return this.getKeyPrefix() + "PROPERTY_MAP" + this.getKeySuffix();
    }

    public String getKeyProperty(String name) {
        return this.getKeyPrefix() + "PROPERTY_" + name + this.getKeySuffix();
    }

    public String getKeyEvent() {
        return this.getKeyPrefix() + "EVENT_AUDITRAIL_" + this.getKeySuffix();
    }

    public String getHashKey(long timestamp) {
        return this.getKeyEvent() + SDF_KEY.format(new Date(timestamp));
    }
}

