/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.redis.RedisConnection;
import org.ff4j.redis.RedisKeysBuilder;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.FeatureJsonParser;
import redis.clients.jedis.Jedis;

public class FeatureStoreRedis
extends AbstractFeatureStore {
    private RedisConnection redisConnection;
    private RedisKeysBuilder keyBuilder = new RedisKeysBuilder();

    public FeatureStoreRedis() {
        this(new RedisConnection(), new RedisKeysBuilder());
    }

    public FeatureStoreRedis(RedisKeysBuilder builder) {
        this(new RedisConnection(), builder);
    }

    public FeatureStoreRedis(RedisConnection pRedisConnection) {
        this(pRedisConnection, new RedisKeysBuilder());
    }

    public FeatureStoreRedis(RedisConnection pRedisConnection, RedisKeysBuilder builder) {
        this.redisConnection = pRedisConnection;
        this.keyBuilder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exist(String uid) {
        Util.assertParamHasLength((String)uid, (String)"Feature identifier");
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            boolean bl = jedis.exists(this.keyBuilder.getKeyFeature(uid));
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature read(String uid) {
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Feature feature = FeatureJsonParser.parseFeature((String)jedis.get(this.keyBuilder.getKeyFeature(uid)));
            return feature;
        }
    }

    public void update(Feature fp) {
        Util.assertNotNull((String)"Feature", (Object[])new Object[]{fp});
        if (!this.exist(fp.getUid())) {
            throw new FeatureNotFoundException(fp.getUid());
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.set(this.keyBuilder.getKeyFeature(fp.getUid()), fp.toJson());
            jedis.persist(this.keyBuilder.getKeyFeature(fp.getUid()));
        }
    }

    public void enable(String uid) {
        Feature f = this.read(uid);
        f.enable();
        this.update(f);
    }

    public void disable(String uid) {
        Feature f = this.read(uid);
        f.disable();
        this.update(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Feature fp) {
        Util.assertNotNull((String)"Feature", (Object[])new Object[]{fp});
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        try (Jedis jedis = null;){
            String id = fp.getUid();
            jedis = this.getJedis();
            jedis.sadd(this.keyBuilder.getKeyFeatureMap(), new String[]{id});
            jedis.set(this.keyBuilder.getKeyFeature(id), fp.toJson());
            jedis.persist(this.keyBuilder.getKeyFeature(id) + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Feature> readAll() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set features = jedis.smembers(this.keyBuilder.getKeyFeatureMap());
            HashMap<String, Feature> featuresMap = new HashMap<String, Feature>();
            if (features != null) {
                for (String key : features) {
                    featuresMap.put(key, this.read(key));
                }
            }
            HashMap<String, Feature> hashMap = featuresMap;
            return hashMap;
        }
    }

    public void delete(String fpId) {
        if (!this.exist(fpId)) {
            throw new FeatureNotFoundException(fpId);
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.srem(this.keyBuilder.getKeyFeatureMap(), new String[]{fpId});
            jedis.del(this.keyBuilder.getKeyFeature(fpId));
        }
    }

    public void grantRoleOnFeature(String flipId, String roleName) {
        Util.assertParamHasLength((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().add(roleName);
        this.update(f);
    }

    public void removeRoleFromFeature(String flipId, String roleName) {
        Util.assertParamHasLength((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().remove(roleName);
        this.update(f);
    }

    public Map<String, Feature> readGroup(String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            if (!groupName.equals(uid.getValue().getGroup())) continue;
            group.put(uid.getKey(), uid.getValue());
        }
        if (group.isEmpty()) {
            throw new GroupNotFoundException(groupName);
        }
        return group;
    }

    public boolean existGroup(String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            if (!groupName.equals(uid.getValue().getGroup())) continue;
            group.put(uid.getKey(), uid.getValue());
        }
        return !group.isEmpty();
    }

    public void enableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            uid.getValue().enable();
            this.update(uid.getValue());
        }
    }

    public void disableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            uid.getValue().disable();
            this.update(uid.getValue());
        }
    }

    public void addToGroup(String featureId, String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName (#2)");
        Feature f = this.read(featureId);
        f.setGroup(groupName);
        this.update(f);
    }

    public void removeFromGroup(String featureId, String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName (#2)");
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        Feature f = this.read(featureId);
        f.setGroup(null);
        this.update(f);
    }

    public Set<String> readAllGroups() {
        Map<String, Feature> features = this.readAll();
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            groups.add(uid.getValue().getGroup());
        }
        groups.remove(null);
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set myKeys = jedis.smembers(this.keyBuilder.getKeyFeatureMap());
            for (String key : myKeys) {
                this.delete(key);
            }
        }
    }

    public RedisConnection getRedisConnection() {
        return this.redisConnection;
    }

    public void setRedisConnection(RedisConnection redisConnection) {
        this.redisConnection = redisConnection;
    }

    public Jedis getJedis() {
        if (this.redisConnection == null) {
            throw new IllegalArgumentException("Cannot found any redisConnection");
        }
        Jedis jedis = this.redisConnection.getJedis();
        if (jedis == null) {
            throw new IllegalArgumentException("Cannot found any jedis connection, please build connection");
        }
        return jedis;
    }
}

