/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.redis.RedisKeysBuilder;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.PropertyJsonParser;

public class PropertyStoreRedisLettuce
extends AbstractPropertyStore {
    private RedisCommands<String, String> redisCommands;
    private RedisAdvancedClusterCommands<String, String> redisCommandsCluster;
    private RedisKeysBuilder keyBuilder = new RedisKeysBuilder();

    public PropertyStoreRedisLettuce(RedisClient redisClient) {
        this(redisClient, new RedisKeysBuilder());
    }

    public PropertyStoreRedisLettuce(RedisClient redisClient, RedisKeysBuilder keyBuilder) {
        this.redisCommands = redisClient.connect().sync();
        this.keyBuilder = keyBuilder;
    }

    public PropertyStoreRedisLettuce(RedisClusterClient redisClusterClient) {
        this(redisClusterClient, new RedisKeysBuilder());
    }

    public PropertyStoreRedisLettuce(RedisClusterClient redisClusterClient, RedisKeysBuilder keyBuilder) {
        this.redisCommandsCluster = redisClusterClient.connect().sync();
        this.keyBuilder = keyBuilder;
    }

    public boolean existProperty(String name) {
        Util.assertParamHasLength((String)name, (String)"PropertyName identifier");
        String key = this.keyBuilder.getKeyProperty(name);
        return 1L == (null != this.redisCommands ? this.redisCommands.exists((Object[])new String[]{key}) : this.redisCommandsCluster.exists((Object[])new String[]{key}));
    }

    public <T> void createProperty(Property<T> prop) {
        Util.assertNotNull((Object[])new Object[]{prop});
        if (this.existProperty(prop.getName())) {
            throw new PropertyAlreadyExistException(prop.getName());
        }
        if (null != this.redisCommands) {
            this.redisCommands.sadd((Object)this.keyBuilder.getKeyPropertyMap(), (Object[])new String[]{prop.getName()});
            this.redisCommands.set((Object)this.keyBuilder.getKeyProperty(prop.getName()), (Object)prop.toJson());
            this.redisCommands.persist((Object)this.keyBuilder.getKeyProperty(prop.getName()));
        } else {
            this.redisCommandsCluster.sadd((Object)this.keyBuilder.getKeyPropertyMap(), (Object[])new String[0]);
            this.redisCommandsCluster.set((Object)this.keyBuilder.getKeyProperty(prop.getName()), (Object)prop.toJson());
            this.redisCommandsCluster.persist((Object)this.keyBuilder.getKeyProperty(prop.getName()));
        }
    }

    public Property<?> readProperty(String name) {
        this.assertPropertyExist(name);
        String key = this.keyBuilder.getKeyProperty(name);
        return PropertyJsonParser.parseProperty((String)(null != this.redisCommands ? (String)this.redisCommands.get((Object)key) : (String)this.redisCommandsCluster.get((Object)key)));
    }

    public void deleteProperty(String name) {
        this.assertPropertyExist(name);
        if (null != this.redisCommands) {
            this.redisCommands.srem((Object)this.keyBuilder.getKeyPropertyMap(), (Object[])new String[]{name});
            this.redisCommands.del((Object[])new String[]{this.keyBuilder.getKeyProperty(name)});
        } else {
            this.redisCommandsCluster.srem((Object)this.keyBuilder.getKeyPropertyMap(), (Object[])new String[]{name});
            this.redisCommandsCluster.del((Object[])new String[]{this.keyBuilder.getKeyProperty(name)});
        }
    }

    public Set<String> listPropertyNames() {
        return null != this.redisCommands ? this.redisCommands.smembers((Object)this.keyBuilder.getKeyPropertyMap()) : this.redisCommandsCluster.smembers((Object)this.keyBuilder.getKeyPropertyMap());
    }

    public Map<String, Property<?>> readAllProperties() {
        LinkedHashMap mapP = new LinkedHashMap();
        Set<String> properties = this.listPropertyNames();
        if (properties != null) {
            for (String key : properties) {
                mapP.put(key, this.readProperty(key));
            }
        }
        return mapP;
    }

    public void clear() {
        Set<String> myKeys = this.listPropertyNames();
        for (String key : myKeys) {
            this.deleteProperty(key);
        }
    }
}

