/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.redis.clientsidecache;

import io.lettuce.core.CopyArgs;
import io.lettuce.core.ExpireArgs;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.MigrateArgs;
import io.lettuce.core.RestoreArgs;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.SortArgs;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.api.sync.RedisKeyCommands;
import io.lettuce.core.output.KeyStreamingChannel;
import io.lettuce.core.output.ValueStreamingChannel;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.ff4j.redis.clientsidecache.RedisClientSideCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSideCacheRedisKeyCommands<K, V>
implements RedisKeyCommands<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final RedisKeyCommands<K, V> delegate;
    private final RedisClientSideCache<K, V> clientSideCache;

    public ClientSideCacheRedisKeyCommands(RedisKeyCommands<K, V> delegate, RedisClientSideCache<K, V> clientSideCache) {
        this.delegate = delegate;
        this.clientSideCache = clientSideCache;
    }

    public Boolean copy(K source, K destination) {
        LOGGER.warn("copy is not currently supported by client side caching");
        return this.delegate.copy(source, destination);
    }

    public Boolean copy(K source, K destination, CopyArgs copyArgs) {
        LOGGER.warn("copy is not currently supported by client side caching");
        return this.delegate.copy(source, destination, copyArgs);
    }

    public Long del(K ... keys) {
        Arrays.stream(keys).forEach(this.clientSideCache::remove);
        return this.delegate.del((Object[])keys);
    }

    public Long unlink(K ... keys) {
        LOGGER.warn("unlink is not currently supported by client side caching");
        return this.delegate.unlink((Object[])keys);
    }

    public byte[] dump(K key) {
        LOGGER.warn("dump is not currently supported by client side caching");
        return this.delegate.dump(key);
    }

    public Long exists(K ... keys) {
        LOGGER.warn("exists is not currently supported by client side caching");
        return this.delegate.exists((Object[])keys);
    }

    public Boolean expire(K key, long seconds) {
        this.clientSideCache.expire(key, seconds);
        return this.delegate.expire(key, seconds);
    }

    public Boolean expire(K key, long seconds, ExpireArgs expireArgs) {
        LOGGER.warn("expire is not currently supported by client side caching");
        return this.delegate.expire(key, seconds, expireArgs);
    }

    public Boolean expire(K key, Duration seconds) {
        LOGGER.warn("expire is not currently supported by client side caching");
        return this.delegate.expire(key, seconds);
    }

    public Boolean expire(K key, Duration seconds, ExpireArgs expireArgs) {
        LOGGER.warn("expire is not currently supported by client side caching");
        return this.delegate.expire(key, seconds, expireArgs);
    }

    public Boolean expireat(K key, long timestamp) {
        LOGGER.warn("expireat is not currently supported by client side caching");
        return this.delegate.expireat(key, timestamp);
    }

    public Boolean expireat(K key, long timestamp, ExpireArgs expireArgs) {
        LOGGER.warn("expireat is not currently supported by client side caching");
        return this.delegate.expireat(key, timestamp, expireArgs);
    }

    public Boolean expireat(K key, Date timestamp) {
        LOGGER.warn("expireat is not currently supported by client side caching");
        return this.delegate.expireat(key, timestamp);
    }

    public Boolean expireat(K key, Date timestamp, ExpireArgs expireArgs) {
        LOGGER.warn("expireat is not currently supported by client side caching");
        return this.delegate.expireat(key, timestamp, expireArgs);
    }

    public Boolean expireat(K key, Instant timestamp) {
        LOGGER.warn("expireat is not currently supported by client side caching");
        return this.delegate.expireat(key, timestamp);
    }

    public Boolean expireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        LOGGER.warn("expireat is not currently supported by client side caching");
        return this.delegate.expireat(key, timestamp, expireArgs);
    }

    public Long expiretime(K key) {
        LOGGER.warn("expiretime is not currently supported by client side caching");
        return this.delegate.expiretime(key);
    }

    public List<K> keys(K pattern) {
        LOGGER.warn("keys is not currently supported by client side caching");
        return this.delegate.keys(pattern);
    }

    public Long keys(KeyStreamingChannel<K> channel, K pattern) {
        LOGGER.warn("keys is not currently supported by client side caching");
        return this.delegate.keys(channel, pattern);
    }

    public String migrate(String host, int port, K key, int db, long timeout) {
        LOGGER.warn("migrate is not currently supported by client side caching");
        return this.delegate.migrate(host, port, key, db, timeout);
    }

    public String migrate(String host, int port, int db, long timeout, MigrateArgs<K> migrateArgs) {
        LOGGER.warn("migrate is not currently supported by client side caching");
        return this.delegate.migrate(host, port, db, timeout, migrateArgs);
    }

    public Boolean move(K key, int db) {
        LOGGER.warn("move is not currently supported by client side caching");
        return this.delegate.move(key, db);
    }

    public String objectEncoding(K key) {
        LOGGER.warn("objectEncoding is not currently supported by client side caching");
        return this.delegate.objectEncoding(key);
    }

    public Long objectFreq(K key) {
        LOGGER.warn("objectFreq is not currently supported by client side caching");
        return this.delegate.objectFreq(key);
    }

    public Long objectIdletime(K key) {
        LOGGER.warn("objectIdletime is not currently supported by client side caching");
        return this.delegate.objectIdletime(key);
    }

    public Long objectRefcount(K key) {
        LOGGER.warn("objectRefcount is not currently supported by client side caching");
        return this.delegate.objectRefcount(key);
    }

    public Boolean persist(K key) {
        LOGGER.warn("persist is not currently supported by client side caching");
        return this.delegate.persist(key);
    }

    public Boolean pexpire(K key, long milliseconds) {
        LOGGER.warn("pexpire is not currently supported by client side caching");
        return this.delegate.pexpire(key, milliseconds);
    }

    public Boolean pexpire(K key, long milliseconds, ExpireArgs expireArgs) {
        LOGGER.warn("pexpire is not currently supported by client side caching");
        return this.delegate.pexpire(key, milliseconds, expireArgs);
    }

    public Boolean pexpire(K key, Duration milliseconds) {
        LOGGER.warn("pexpire is not currently supported by client side caching");
        return this.delegate.pexpire(key, milliseconds);
    }

    public Boolean pexpire(K key, Duration milliseconds, ExpireArgs expireArgs) {
        LOGGER.warn("pexpire is not currently supported by client side caching");
        return this.delegate.pexpire(key, milliseconds, expireArgs);
    }

    public Boolean pexpireat(K key, long timestamp) {
        LOGGER.warn("pexpireat is not currently supported by client side caching");
        return this.delegate.pexpireat(key, timestamp);
    }

    public Boolean pexpireat(K key, long timestamp, ExpireArgs expireArgs) {
        LOGGER.warn("pexpireat is not currently supported by client side caching");
        return this.delegate.pexpireat(key, timestamp, expireArgs);
    }

    public Boolean pexpireat(K key, Date timestamp) {
        LOGGER.warn("pexpireat is not currently supported by client side caching");
        return this.delegate.pexpireat(key, timestamp);
    }

    public Boolean pexpireat(K key, Date timestamp, ExpireArgs expireArgs) {
        LOGGER.warn("pexpireat is not currently supported by client side caching");
        return this.delegate.pexpireat(key, timestamp, expireArgs);
    }

    public Boolean pexpireat(K key, Instant timestamp) {
        LOGGER.warn("pexpireat is not currently supported by client side caching");
        return this.delegate.pexpireat(key, timestamp);
    }

    public Boolean pexpireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        LOGGER.warn("pexpireat is not currently supported by client side caching");
        return this.delegate.pexpireat(key, timestamp, expireArgs);
    }

    public Long pexpiretime(K key) {
        LOGGER.warn("pexpiretime is not currently supported by client side caching");
        return this.delegate.pexpiretime(key);
    }

    public Long pttl(K key) {
        LOGGER.warn("pttl is not currently supported by client side caching");
        return this.delegate.pttl(key);
    }

    public K randomkey() {
        LOGGER.warn("randomkey is not currently supported by client side caching");
        return (K)this.delegate.randomkey();
    }

    public String rename(K key, K newKey) {
        LOGGER.warn("rename is not currently supported by client side caching");
        return this.delegate.rename(key, newKey);
    }

    public Boolean renamenx(K key, K newKey) {
        LOGGER.warn("renamenx is not currently supported by client side caching");
        return this.delegate.renamenx(key, newKey);
    }

    public String restore(K key, long ttl, byte[] value) {
        LOGGER.warn("restore is not currently supported by client side caching");
        return this.delegate.restore(key, ttl, value);
    }

    public String restore(K key, byte[] value, RestoreArgs args) {
        LOGGER.warn("restore is not currently supported by client side caching");
        return this.delegate.restore(key, value, args);
    }

    public List<V> sort(K key) {
        LOGGER.warn("sort is not currently supported by client side caching");
        return this.delegate.sort(key);
    }

    public Long sort(ValueStreamingChannel<V> channel, K key) {
        LOGGER.warn("sort is not currently supported by client side caching");
        return this.delegate.sort(channel, key);
    }

    public List<V> sort(K key, SortArgs sortArgs) {
        LOGGER.warn("sort is not currently supported by client side caching");
        return this.delegate.sort(key, sortArgs);
    }

    public Long sort(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        LOGGER.warn("sort is not currently supported by client side caching");
        return this.delegate.sort(channel, key, sortArgs);
    }

    public List<V> sortReadOnly(K key) {
        LOGGER.warn("sortReadOnly is not currently supported by client side caching");
        return this.delegate.sortReadOnly(key);
    }

    public Long sortReadOnly(ValueStreamingChannel<V> channel, K key) {
        LOGGER.warn("sortReadOnly is not currently supported by client side caching");
        return this.delegate.sortReadOnly(channel, key);
    }

    public List<V> sortReadOnly(K key, SortArgs sortArgs) {
        LOGGER.warn("sortReadOnly is not currently supported by client side caching");
        return this.delegate.sortReadOnly(key, sortArgs);
    }

    public Long sortReadOnly(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        LOGGER.warn("sortReadOnly is not currently supported by client side caching");
        return this.delegate.sortReadOnly(channel, key, sortArgs);
    }

    public Long sortStore(K key, SortArgs sortArgs, K destination) {
        LOGGER.warn("sortStore is not currently supported by client side caching");
        return this.delegate.sortStore(key, sortArgs, destination);
    }

    public Long touch(K ... keys) {
        LOGGER.warn("touch is not currently supported by client side caching");
        return this.delegate.touch((Object[])keys);
    }

    public Long ttl(K key) {
        LOGGER.warn("ttl is not currently supported by client side caching");
        return this.delegate.ttl(key);
    }

    public String type(K key) {
        LOGGER.warn("type is not currently supported by client side caching");
        return this.delegate.type(key);
    }

    public KeyScanCursor<K> scan() {
        LOGGER.warn("scan is not currently supported by client side caching");
        return this.delegate.scan();
    }

    public KeyScanCursor<K> scan(ScanArgs scanArgs) {
        LOGGER.warn("scan is not currently supported by client side caching");
        return this.delegate.scan(scanArgs);
    }

    public KeyScanCursor<K> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        LOGGER.warn("scan is not currently supported by client side caching");
        return this.delegate.scan(scanCursor, scanArgs);
    }

    public KeyScanCursor<K> scan(ScanCursor scanCursor) {
        LOGGER.warn("scan is not currently supported by client side caching");
        return this.delegate.scan(scanCursor);
    }

    public StreamScanCursor scan(KeyStreamingChannel<K> channel) {
        LOGGER.warn("scan is not currently supported by client side caching");
        return this.delegate.scan(channel);
    }

    public StreamScanCursor scan(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        LOGGER.warn("scan is not currently supported by client side caching");
        return this.delegate.scan(channel, scanArgs);
    }

    public StreamScanCursor scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        LOGGER.warn("scan is not currently supported by client side caching");
        return this.delegate.scan(channel, scanCursor, scanArgs);
    }

    public StreamScanCursor scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        LOGGER.warn("scan is not currently supported by client side caching");
        return this.delegate.scan(channel, scanCursor);
    }
}

