/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.redis.clientsidecache;

import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisConnectionStateListener;
import io.lettuce.core.StatefulRedisConnectionImpl;
import io.lettuce.core.TrackingArgs;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ff4j.cache.InMemoryCacheEntry;

public class RedisClientSideCache<K, V> {
    private final ConcurrentMap<K, InMemoryCacheEntry<V>> localCache = new ConcurrentHashMap<K, InMemoryCacheEntry<V>>();

    public RedisClientSideCache(StatefulRedisConnection<K, V> redisConnection) {
        this.setupRedisClientTracking(redisConnection);
    }

    public V get(K key) {
        InMemoryCacheEntry localCacheEntry = (InMemoryCacheEntry)this.localCache.get(key);
        if (localCacheEntry != null && !localCacheEntry.hasReachTimeToLive()) {
            return (V)localCacheEntry.getEntry();
        }
        return null;
    }

    public void put(K key, V value, long ttl) {
        this.localCache.put(key, new InMemoryCacheEntry(value, ttl));
    }

    public void expire(K key, long ttlInSec) {
        InMemoryCacheEntry v = (InMemoryCacheEntry)this.localCache.get(key);
        if (v != null) {
            this.localCache.put(key, new InMemoryCacheEntry(v.getEntry(), ttlInSec));
        }
    }

    public void remove(K k) {
        this.localCache.remove(k);
    }

    private void setupRedisClientTracking(StatefulRedisConnection<K, V> redisConnection) {
        StatefulRedisConnectionImpl connectionImpl = (StatefulRedisConnectionImpl)redisConnection;
        RedisCodec codec = connectionImpl.getCodec();
        redisConnection.sync().clientTracking(TrackingArgs.Builder.enabled());
        redisConnection.addListener(message -> {
            if (message.getType().equals("invalidate")) {
                List content = message.getContent(arg_0 -> ((RedisCodec)codec).decodeKey(arg_0));
                List keys = (List)content.get(1);
                keys.forEach(this.localCache::remove);
            }
        });
        redisConnection.addListener(new RedisConnectionStateListener(){

            public void onRedisConnected(RedisChannelHandler<?, ?> channelHandler, SocketAddress socketAddress) {
                if (channelHandler instanceof StatefulRedisConnection) {
                    StatefulRedisConnection connection = (StatefulRedisConnection)channelHandler;
                    connection.async().clientTracking(TrackingArgs.Builder.enabled());
                }
                RedisClientSideCache.this.localCache.clear();
            }
        });
    }
}

