/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.EventSeries;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.TimeSeriesChart;
import org.ff4j.audit.repository.AbstractEventRepository;
import org.ff4j.redis.RedisConnection;
import org.ff4j.redis.RedisKeysBuilder;
import org.ff4j.utils.Util;
import redis.clients.jedis.Jedis;

public class EventRepositoryRedis
extends AbstractEventRepository {
    public static final int UPPER_LIMIT = 50000;
    private RedisConnection redisConnection;
    private RedisKeysBuilder keyBuilder = new RedisKeysBuilder();
    private static ObjectMapper objectMapper = new ObjectMapper();

    public EventRepositoryRedis() {
        this(new RedisConnection(), new RedisKeysBuilder());
    }

    public EventRepositoryRedis(RedisKeysBuilder builder) {
        this(new RedisConnection(), builder);
    }

    public EventRepositoryRedis(RedisConnection pRedisConnection) {
        this(pRedisConnection, new RedisKeysBuilder());
    }

    public EventRepositoryRedis(RedisConnection pRedisConnection, RedisKeysBuilder builder) {
        this.redisConnection = pRedisConnection;
        this.keyBuilder = builder;
    }

    public void createSchema() {
    }

    public boolean saveEvent(Event evt) {
        if (evt == null) {
            throw new IllegalArgumentException("Event cannot be null nor empty");
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            long timeStamp = evt.getTimestamp();
            evt.setUuid(String.valueOf(timeStamp));
            jedis.zadd(this.keyBuilder.getHashKey(evt.getTimestamp()), (double)timeStamp, objectMapper.writeValueAsString((Object)evt));
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event getEventByUUID(String uuid, Long timestamp) {
        Util.assertHasLength((String[])new String[]{uuid});
        Event redisEvent = null;
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            String hashKey = this.keyBuilder.getHashKey(timestamp);
            List events = jedis.zrangeByScore(hashKey, (double)(timestamp - 100L), (double)(timestamp + 100L), 0, 10);
            for (String evt : events) {
                Event event = this.marshallEvent(evt);
                if (timestamp.longValue() != event.getTimestamp()) continue;
                Event event2 = event;
                return event2;
            }
        }
        return redisEvent;
    }

    private Event marshallEvent(String eventString) {
        try {
            return (Event)objectMapper.readValue(eventString, Event.class);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Cannot read event from DB, cannot parse", e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException("Cannot read event from DB, cannot map", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read event from DB", e);
        }
    }

    public Map<String, MutableHitCount> getFeatureUsageHitCount(EventQueryDefinition query) {
        return this.getUsageCount(query, Types.NAME);
    }

    public Map<String, MutableHitCount> getHostHitCount(EventQueryDefinition query) {
        return this.getUsageCount(query, Types.HOST);
    }

    public Map<String, MutableHitCount> getUserHitCount(EventQueryDefinition query) {
        return this.getUsageCount(query, Types.USER);
    }

    public Map<String, MutableHitCount> getSourceHitCount(EventQueryDefinition query) {
        return this.getUsageCount(query, Types.SOURCE);
    }

    private Map<String, MutableHitCount> getUsageCount(EventQueryDefinition query, Types type) {
        HashMap<String, MutableHitCount> hitCount = new HashMap<String, MutableHitCount>();
        Set<String> events = this.getEventsFromRedis(query);
        for (String event : events) {
            Event eventObject = this.marshallEvent(event);
            String value = this.getValueFromAttribute(type, eventObject);
            MutableHitCount mutableHitCount = (MutableHitCount)hitCount.get(value);
            if (mutableHitCount != null) {
                mutableHitCount.inc();
            } else {
                mutableHitCount = new MutableHitCount(1);
            }
            hitCount.put(value, mutableHitCount);
        }
        return hitCount;
    }

    public TimeSeriesChart getFeatureUsageHistory(EventQueryDefinition query, TimeUnit tu) {
        TimeSeriesChart tsc = new TimeSeriesChart(query.getFrom().longValue(), query.getTo().longValue(), tu);
        Set<String> events = this.getEventsFromRedis(query);
        for (String event : events) {
            tsc.addEvent(this.marshallEvent(event));
        }
        return tsc;
    }

    public EventSeries searchFeatureUsageEvents(EventQueryDefinition query) {
        return this.getAuditTrail(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSeries getAuditTrail(EventQueryDefinition query) {
        EventSeries eventSeries = new EventSeries();
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            String hashKey = this.keyBuilder.getHashKey(query.getFrom());
            List events = jedis.zrangeByScore(hashKey, (double)query.getFrom().longValue(), (double)query.getTo().longValue(), 0, 100);
            for (String event : events) {
                eventSeries.add(this.marshallEvent(event));
            }
        }
        return eventSeries;
    }

    public void purgeAuditTrail(EventQueryDefinition query) {
    }

    public void purgeFeatureUsage(EventQueryDefinition query) {
    }

    public Jedis getJedis() {
        if (this.redisConnection == null) {
            throw new IllegalArgumentException("Cannot found any redisConnection");
        }
        Jedis jedis = this.redisConnection.getJedis();
        if (jedis == null) {
            throw new IllegalArgumentException("Cannot found any jedis connection, please build connection");
        }
        return jedis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getEventsFromRedis(EventQueryDefinition query) {
        HashSet<String> events = null;
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            String hashKey = this.keyBuilder.getHashKey(query.getFrom());
            events = new HashSet<String>(jedis.zrangeByScore(hashKey, (double)query.getFrom().longValue(), (double)query.getTo().longValue(), 0, 50000));
        }
        return events;
    }

    private String getValueFromAttribute(Types type, Event event) {
        return switch (type.ordinal()) {
            case 2 -> event.getHostName();
            case 0 -> event.getSource();
            case 3 -> event.getUser();
            case 1 -> event.getName();
            default -> "NA";
        };
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static enum Types {
        SOURCE,
        NAME,
        HOST,
        USER;

    }
}

