/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.test.cache;

import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.core.Feature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCacheManagerJUnitTest {
    public static final String DESCRIPTION = "Description";
    protected FF4JCacheManager cacheManager = null;

    protected abstract FF4JCacheManager getCacheManager();

    @Before
    public void initialize() {
        this.cacheManager = this.getCacheManager();
    }

    @After
    public void clean() {
        this.getCacheManager().clearFeatures();
        this.getCacheManager().clearProperties();
    }

    @Test
    public void testPutOK() {
        Feature ff = new Feature("ff", false, DESCRIPTION);
        Assert.assertFalse((boolean)this.getCacheManager().listCachedFeatureNames().contains(ff.getUid()));
        this.getCacheManager().putFeature(ff);
        Assert.assertTrue((boolean)this.getCacheManager().listCachedFeatureNames().contains(ff.getUid()));
    }

    @Test
    public void testPutSeveral() {
        Assert.assertTrue((boolean)this.getCacheManager().listCachedFeatureNames().isEmpty());
        this.getCacheManager().putFeature(new Feature("ff", false, DESCRIPTION));
        this.getCacheManager().putFeature(new Feature("ff2", false, DESCRIPTION));
        Assert.assertEquals((long)2L, (long)this.getCacheManager().listCachedFeatureNames().size());
    }

    @Test
    public void testPutAvoidDoublon() {
        Assert.assertTrue((boolean)this.getCacheManager().listCachedFeatureNames().isEmpty());
        this.getCacheManager().putFeature(new Feature("ff", false, DESCRIPTION));
        this.getCacheManager().putFeature(new Feature("ff", false, DESCRIPTION));
        this.getCacheManager().putFeature(new Feature("ff2", false, DESCRIPTION));
        Assert.assertEquals((long)2L, (long)this.getCacheManager().listCachedFeatureNames().size());
    }

    @Test
    public void testEvictOK() {
        this.getCacheManager().putFeature(new Feature("ff", false, DESCRIPTION));
        Assert.assertTrue((boolean)this.getCacheManager().listCachedFeatureNames().contains("ff"));
        this.getCacheManager().evictFeature("ff");
        Assert.assertFalse((boolean)this.getCacheManager().listCachedFeatureNames().contains("ff"));
    }

    @Test
    public void testEvictFeatureNotExist() {
        Assert.assertFalse((boolean)this.getCacheManager().listCachedFeatureNames().contains("ff"));
        this.getCacheManager().evictFeature("ff");
    }

    @Test
    public void testClear() {
        this.getCacheManager().putFeature(new Feature("ff", false, DESCRIPTION));
        this.getCacheManager().putFeature(new Feature("ff2", false, DESCRIPTION));
        this.getCacheManager().putFeature(new Feature("ff3", false, DESCRIPTION));
        Assert.assertEquals((long)3L, (long)this.getCacheManager().listCachedFeatureNames().size());
        this.getCacheManager().clearFeatures();
        Assert.assertTrue((boolean)this.getCacheManager().listCachedFeatureNames().isEmpty());
    }
}

