/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ff4j.audit.Event;

public class EventJsonParser {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private EventJsonParser() {
    }

    public static Event parseEvent(String json) {
        try {
            return EventJsonParser.parseEventMap((Map)objectMapper.readValue(json, HashMap.class));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot parse json as Event " + json, e);
        }
    }

    private static Event parseEventMap(Map<String, Object> eMap) {
        Event e = new Event();
        e.setUuid((String)eMap.get("id"));
        e.setTimestamp(((Long)eMap.get("timestamp")).longValue());
        e.setHostName((String)eMap.get("hostName"));
        e.setSource((String)eMap.get("source"));
        e.setUser((String)eMap.get("user"));
        e.setName((String)eMap.get("name"));
        e.setType((String)eMap.get("type"));
        e.setAction((String)eMap.get("action"));
        e.setValue((String)eMap.get("value"));
        if (null != eMap.get("duration")) {
            if (eMap.get("duration") instanceof Integer) {
                e.setDuration(((Integer)eMap.get("duration")).longValue());
            } else {
                e.setDuration(((Long)eMap.get("duration")).longValue());
            }
        } else {
            e.setDuration(0L);
        }
        Set<String> keys = eMap.keySet();
        keys.removeAll(Arrays.asList("id", "timestamp", "hostName", "source", "user", "name", "type", "action", "value", "duration"));
        for (String key : keys) {
            e.getCustomKeys().put(key, (String)eMap.get(key));
        }
        return e;
    }

    public static String eventArrayToJson(Event[] events) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (events != null) {
            boolean first = true;
            for (Event event : events) {
                sb.append(first ? "" : ",");
                sb.append(event.toJson());
                first = false;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static Event[] parseEventArray(String json) {
        if (null == json || "".equals(json)) {
            return null;
        }
        try {
            List evtMap = (List)objectMapper.readValue(json, List.class);
            Event[] eArray = new Event[evtMap.size()];
            int idx = 0;
            for (LinkedHashMap ll : evtMap) {
                eArray[idx++] = EventJsonParser.parseEventMap(ll);
            }
            return eArray;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse JSON " + json, e);
        }
    }
}

