/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ff4j.property.Property;
import org.ff4j.property.util.PropertyFactory;
import org.ff4j.property.util.PropertyJsonBean;

public final class PropertyJsonParser {
    public static final String FIXED_VALUES = "fixedValues";
    private static ObjectMapper objectMapper = new ObjectMapper();

    private PropertyJsonParser() {
    }

    public static Property<?> parseProperty(String json) {
        Map propertyJson;
        if (null == json || "".equals(json)) {
            return null;
        }
        try {
            propertyJson = (Map)objectMapper.readValue(json, HashMap.class);
        }
        catch (Exception re) {
            throw new IllegalArgumentException("Cannot parse JSON Property", re);
        }
        String propertyName = String.valueOf(propertyJson.get("name"));
        String propertyVal = String.valueOf(propertyJson.get("value"));
        String propertyType = String.valueOf(propertyJson.get("type"));
        Property ap = PropertyFactory.createProperty((String)propertyName, (String)propertyType, (String)propertyVal);
        List listOfFixedValue = (List)propertyJson.get(FIXED_VALUES);
        if (listOfFixedValue != null) {
            for (Object v : listOfFixedValue) {
                ap.add2FixedValueFromString(String.valueOf(v));
            }
            if (ap.getFixedValues() != null && !ap.getFixedValues().contains(ap.getValue())) {
                throw new IllegalArgumentException("Cannot create property <" + ap.getName() + "> invalid value <" + String.valueOf(ap.getValue()) + "> expected one of " + String.valueOf(ap.getFixedValues()));
            }
        }
        return ap;
    }

    public static Property<?>[] parsePropertyArray(String json) {
        if (null == json || "".equals(json)) {
            return null;
        }
        try {
            List flipMap = (List)objectMapper.readValue(json, List.class);
            Property[] fArray = new Property[flipMap.size()];
            int idx = 0;
            for (LinkedHashMap ll : flipMap) {
                fArray[idx++] = PropertyJsonParser.parsePropertyMap(ll);
            }
            return fArray;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse JSON " + json, e);
        }
    }

    public static Property<?> parsePropertyMap(Map<String, Object> fMap) {
        ArrayList dbList;
        PropertyJsonBean pf = new PropertyJsonBean();
        pf.setName((String)fMap.get("name"));
        pf.setDescription((String)fMap.get("description"));
        pf.setType((String)fMap.get("type"));
        pf.setValue((String)fMap.get("value"));
        if (fMap.containsKey(FIXED_VALUES) && (dbList = (ArrayList)fMap.get(FIXED_VALUES)) != null) {
            for (Object item : dbList) {
                pf.addFixedValue((String)item);
            }
        }
        return pf.asProperty();
    }
}

