/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ff4j.FF4j;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.utils.MappingUtil;
import org.ff4j.utils.Util;
import org.ff4j.web.controller.AbstractController;
import org.ff4j.web.embedded.ConsoleOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.WebContext;

public class FeaturesController
extends AbstractController {
    public static final Logger LOGGER = LoggerFactory.getLogger(FeaturesController.class);
    private static final String VIEW_FEATURES = "features";

    public FeaturesController(FF4j ff4j, TemplateEngine te) {
        super(ff4j, VIEW_FEATURES, te);
    }

    public static String msg(String featureName, String operationId) {
        return String.format("Feature <b>%s</b> has been successfully %s", featureName, operationId);
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws IOException {
        String operation = req.getParameter("op");
        String featureId = req.getParameter("uid");
        String msgType = "success";
        String msg = null;
        if (Util.hasLength((String)operation) && Util.hasLength((String)featureId)) {
            if (this.getFf4j().getFeatureStore().exist(featureId)) {
                String permName;
                if ("disable".equalsIgnoreCase(operation)) {
                    this.getFf4j().disable(featureId);
                    msg = FeaturesController.msg(featureId, "DISABLED");
                    LOGGER.info(featureId + " has been disabled");
                }
                if ("enable".equalsIgnoreCase(operation)) {
                    this.getFf4j().enable(featureId);
                    msg = FeaturesController.msg(featureId, "ENABLED");
                    LOGGER.info(featureId + " has been enabled");
                }
                if ("addPermission".equalsIgnoreCase(operation)) {
                    permName = req.getParameter("permission");
                    this.getFf4j().getFeatureStore().grantRoleOnFeature(featureId, permName);
                    LOGGER.info("Add new " + permName + " to " + featureId);
                }
                if ("deletePermission".equalsIgnoreCase(operation)) {
                    permName = req.getParameter("permission");
                    this.getFf4j().getFeatureStore().removeRoleFromFeature(featureId, permName);
                    LOGGER.info("Remove " + permName + " to " + featureId);
                }
                if ("clearPermissions".equalsIgnoreCase(operation)) {
                    Feature feature = this.getFf4j().getFeatureStore().read(featureId);
                    feature.getPermissions().clear();
                    this.getFf4j().getFeatureStore().update(feature);
                    LOGGER.info("Clear permissions for " + featureId);
                }
                if ("deleteProperty".equalsIgnoreCase(operation)) {
                    String propertyName = req.getParameter("name");
                    Feature feature = this.getFf4j().getFeatureStore().read(featureId);
                    feature.getCustomProperties().remove(propertyName);
                    this.getFf4j().getFeatureStore().update(feature);
                    LOGGER.info("Remove Property " + propertyName + " to " + featureId);
                }
            } else {
                msgType = "warning";
                msg = "The feature '" + featureId + "' does not exist";
            }
        }
        ctx.setVariable("msgType", (Object)msgType);
        ctx.setVariable("msgInfo", msg);
        this.renderPage(ctx);
    }

    @Override
    public void post(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws IOException {
        String groupName;
        String msg = null;
        String msgType = "success";
        String operation = req.getParameter("op");
        String featureId = req.getParameter("uid");
        if ("update".equalsIgnoreCase(operation)) {
            this.updateFeature(req, featureId);
            msg = featureId + " has been UPDATED";
        } else if ("create".equalsIgnoreCase(operation)) {
            ConsoleOperations.createFeature(this.getFf4j(), req);
            msg = featureId + " has been CREATED";
        } else if ("delete".equalsIgnoreCase(operation)) {
            this.getFf4j().getFeatureStore().delete(featureId);
            msg = featureId + " has been DELETED";
        } else if ("renameFeature".equalsIgnoreCase(operation)) {
            String newName = req.getParameter("newname");
            Set featureNames = this.getFf4j().getFeatureStore().readAll().keySet();
            if (featureNames.contains(newName)) {
                msgType = "warning";
                msg = "Cannot rename " + featureId + " to " + newName + " : it already exists";
            } else {
                Feature newFeature = this.getFf4j().getFeatureStore().read(featureId);
                newFeature.setUid(newName);
                this.getFf4j().getFeatureStore().delete(featureId);
                this.getFf4j().getFeatureStore().create(newFeature);
                msg = "Feature " + featureId + " has been renamed to " + newName;
            }
        } else if ("copyFeature".equalsIgnoreCase(operation)) {
            String newName = req.getParameter("newname");
            Set featureNames = this.getFf4j().getFeatureStore().readAll().keySet();
            if (featureNames.contains(newName)) {
                msgType = "warning";
                msg = "Cannot copy " + featureId + " with name " + newName + " : it already exists";
            } else {
                Feature newFeature = new Feature(this.getFf4j().getFeatureStore().read(featureId));
                newFeature.setUid(newName);
                this.getFf4j().getFeatureStore().create(newFeature);
                msg = "Feature " + featureId + " has been copied to " + newName;
            }
        } else if ("toggleGroup".equalsIgnoreCase(operation) && (groupName = req.getParameter("groupName")) != null && !groupName.isEmpty()) {
            String operationGroup = req.getParameter("ope");
            if ("enable".equalsIgnoreCase(operationGroup)) {
                this.getFf4j().getFeatureStore().enableGroup(groupName);
                msg = groupName + " has been ENABLED";
                LOGGER.info("Group '" + groupName + "' has been ENABLED.");
            } else if ("disable".equalsIgnoreCase(operationGroup)) {
                this.getFf4j().getFeatureStore().disableGroup(groupName);
                msg = groupName + " has been DISABLED";
                LOGGER.info("Group '" + groupName + "' has been DISABLED.");
            }
        }
        ctx.setVariable("msgType", (Object)msgType);
        ctx.setVariable("msgInfo", (Object)msg);
        this.renderPage(ctx);
    }

    private void updateFeature(HttpServletRequest req, String featureId) {
        String groupName;
        Feature old = this.ff4j.getFeatureStore().read(featureId);
        Feature fp = new Feature(featureId, old.isEnable());
        fp.setPermissions(old.getPermissions());
        fp.setCustomProperties(old.getCustomProperties());
        fp.setFlippingStrategy(this.buildFlippingStrategy(req, fp.getUid()));
        String featureDesc = req.getParameter("desc");
        if (Util.hasLength((String)featureDesc)) {
            fp.setDescription(featureDesc);
        }
        if (Util.hasLength((String)(groupName = req.getParameter("groupName")))) {
            fp.setGroup(groupName);
        }
        this.ff4j.getFeatureStore().update(fp);
    }

    private FlippingStrategy buildFlippingStrategy(HttpServletRequest req, String uid) {
        String strategy = req.getParameter("strategy");
        String strategyParams = req.getParameter("initParams");
        FlippingStrategy fstrategy = null;
        HashMap<String, String> initParams = new HashMap<String, String>();
        if (Util.hasLength((String)strategy)) {
            if (Util.hasLength((String)strategyParams)) {
                String[] params;
                for (String currentP : params = strategyParams.split(";")) {
                    String[] cur = currentP.split("=");
                    String value = cur.length < 2 ? "" : cur[1];
                    initParams.put(cur[0], value);
                }
            }
            fstrategy = MappingUtil.instanceFlippingStrategy((String)uid, (String)strategy, initParams);
        }
        return fstrategy;
    }

    private void renderPage(WebContext ctx) {
        ctx.setVariable("TITLE", (Object)"Features");
        Map mapOfFeatures = this.ff4j.getFeatureStore().readAll();
        List<String> featuresNames = Arrays.asList(mapOfFeatures.keySet().toArray(new String[0]));
        Collections.sort(featuresNames);
        ArrayList<Feature> orderedFeatures = new ArrayList<Feature>();
        ArrayList<FlippingStrategy> orderedStrategyUsed = new ArrayList<FlippingStrategy>();
        HashMap<String, FlippingStrategy> mapOfStrategyUsed = new HashMap<String, FlippingStrategy>();
        for (String featuName : featuresNames) {
            Feature feature = (Feature)mapOfFeatures.get(featuName);
            orderedFeatures.add(feature);
            FlippingStrategy strategyTargered = feature.getFlippingStrategy();
            if (strategyTargered == null || mapOfStrategyUsed.get(strategyTargered.getClass().getSimpleName()) != null) continue;
            mapOfStrategyUsed.put(strategyTargered.getClass().getSimpleName(), strategyTargered);
            orderedStrategyUsed.add(strategyTargered);
        }
        ctx.setVariable("listOfFeatures", orderedFeatures);
        ctx.setVariable("listOfStrategyUsed", orderedStrategyUsed);
        ArrayList myGroupList = new ArrayList(this.ff4j.getFeatureStore().readAllGroups());
        Collections.sort(myGroupList);
        ctx.setVariable("groupList", myGroupList);
    }
}

