/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ff4j.FF4j;
import org.ff4j.property.Property;
import org.ff4j.property.util.PropertyFactory;
import org.ff4j.utils.Util;
import org.ff4j.web.controller.AbstractController;
import org.ff4j.web.embedded.ConsoleOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.WebContext;

public class PropertiesController
extends AbstractController {
    public static final Logger LOGGER = LoggerFactory.getLogger(PropertiesController.class);
    private static final String VIEW_PROPERTIES = "properties";

    public PropertiesController(FF4j ff4j, TemplateEngine te) {
        super(ff4j, VIEW_PROPERTIES, te);
    }

    @Override
    public void post(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws IOException {
        String msg = null;
        String msgType = "success";
        String operation = req.getParameter("op");
        String propertyName = req.getParameter("name");
        String featureId = req.getParameter("featureid");
        if ("createProperty".equalsIgnoreCase(operation)) {
            ConsoleOperations.createProperty(this.getFf4j(), req);
            msg = propertyName + " has been CREATED";
            String logMessage = "Property '" + propertyName + "' has been created ";
            if (Util.hasLength((String)featureId)) {
                logMessage = logMessage + " for feature '" + featureId + "'";
            }
            LOGGER.info(logMessage);
        } else if ("deleteProperty".equalsIgnoreCase(operation)) {
            if (!Util.hasLength((String)propertyName)) {
                msgType = "warning";
                msg = "Property name not found";
            } else {
                this.getFf4j().getPropertiesStore().deleteProperty(propertyName);
                msg = propertyName + " has been DELETED";
            }
        } else if ("updateProperty".equalsIgnoreCase(operation)) {
            ConsoleOperations.updateProperty(this.getFf4j(), req);
            msg = propertyName + " has been UPDATED";
            String logMessage = "Property '" + propertyName + "' has been UPDATED ";
            if (Util.hasLength((String)featureId)) {
                logMessage = logMessage + " for feature '" + featureId + "'";
            }
            LOGGER.info(logMessage);
        } else if ("renameProperty".equalsIgnoreCase(operation)) {
            String newName = req.getParameter("newname");
            Set propertiesNames = this.getFf4j().getPropertiesStore().listPropertyNames();
            if (propertiesNames.contains(newName)) {
                msgType = "warning";
                msg = "Cannot rename " + propertyName + " to " + newName + " : it already exists";
            } else {
                Property newProperty = this.getFf4j().getPropertiesStore().readProperty(propertyName);
                newProperty.setName(newName);
                this.getFf4j().getPropertiesStore().deleteProperty(propertyName);
                this.getFf4j().getPropertiesStore().createProperty(newProperty);
                msg = "Property " + propertyName + " has been renamed to " + newName;
            }
        } else if ("copyProperty".equalsIgnoreCase(operation)) {
            String newName = req.getParameter("newname");
            Set propertiesNames = this.getFf4j().getPropertiesStore().listPropertyNames();
            if (propertiesNames.contains(newName)) {
                msgType = "warning";
                msg = "Cannot copy " + propertyName + " to " + newName + " : it already exists";
            } else {
                Property p = this.getFf4j().getPropertiesStore().readProperty(propertyName);
                Property newProperty = PropertyFactory.createProperty((String)newName, (String)p.getType(), (String)p.asString(), (String)p.getDescription(), null);
                if (p.getFixedValues() != null) {
                    for (Object o : p.getFixedValues()) {
                        newProperty.add2FixedValueFromString(o.toString());
                    }
                }
                this.getFf4j().getPropertiesStore().createProperty(newProperty);
                msg = "Property " + propertyName + " has been copied to " + newName;
            }
        }
        ctx.setVariable("msgType", (Object)msgType);
        ctx.setVariable("msgInfo", (Object)msg);
        this.renderPage(ctx);
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws IOException {
        String operation = req.getParameter("op");
        String propertyName = req.getParameter("uid");
        String msgType = "success";
        Object msg = null;
        if (Util.hasLength((String)operation) && Util.hasLength((String)propertyName) && this.getFf4j().getPropertiesStore().existProperty(propertyName)) {
            Property ap;
            String fixedValue;
            if ("deleteFixedValue".equalsIgnoreCase(operation)) {
                fixedValue = req.getParameter("fixedValue");
                ap = this.getFf4j().getPropertiesStore().readProperty(propertyName);
                ap.getFixedValues().remove(ap.fromString(fixedValue));
                this.getFf4j().getPropertiesStore().updateProperty(ap);
                LOGGER.info("Property '" + propertyName + "' remove fixedValue '" + fixedValue + "'");
            }
            if ("addFixedValue".equalsIgnoreCase(operation)) {
                fixedValue = req.getParameter("fixedValue");
                ap = this.getFf4j().getPropertiesStore().readProperty(propertyName);
                ap.add2FixedValueFromString(fixedValue);
                this.getFf4j().getPropertiesStore().updateProperty(ap);
                LOGGER.info("Property '" + propertyName + "' add fixedValue '" + fixedValue + "'");
            }
        }
        ctx.setVariable("msgType", (Object)msgType);
        ctx.setVariable("msgInfo", msg);
        this.renderPage(ctx);
    }

    private void renderPage(WebContext ctx) {
        ctx.setVariable("TITLE", (Object)"Properties");
        Map mapOfProperties = this.ff4j.getPropertiesStore().readAllProperties();
        List<String> propertyNames = Arrays.asList(mapOfProperties.keySet().toArray(new String[0]));
        Collections.sort(propertyNames);
        ArrayList orderedProperties = new ArrayList();
        for (String propName : propertyNames) {
            orderedProperties.add(mapOfProperties.get(propName));
        }
        ctx.setVariable("listOfProperties", orderedProperties);
    }
}

