/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.controller;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.ff4j.FF4j;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.utils.Util;
import org.ff4j.web.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.web.IWebExchange;
import org.thymeleaf.web.servlet.JakartaServletWebApplication;

public abstract class AbstractController {
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractController.class);
    protected static SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final SimpleDateFormat SDFSLOT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public static final Set<String> ADMIN_GROUPS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    protected static final String KEY_TITLE = "TITLE";
    protected FF4j ff4j;
    protected TemplateEngine templateEngine = null;
    protected String successView = null;

    public AbstractController(FF4j ff4j, String view, TemplateEngine te) {
        this.ff4j = ff4j;
        this.successView = view;
        this.templateEngine = te;
    }

    private String getUptime() {
        StringBuilder sb = new StringBuilder();
        long uptime = System.currentTimeMillis() - this.ff4j.getStartTime();
        long daynumber = uptime / 86400000L;
        long hourNumber = (uptime -= daynumber * 1000L * 3600L * 24L) / 3600000L;
        long minutenumber = (uptime -= hourNumber * 1000L * 3600L) / 60000L;
        sb.append(daynumber + " days ");
        sb.append(hourNumber + " hours ");
        sb.append(minutenumber + " min ");
        return sb.toString();
    }

    private void i18n(HttpServletRequest req, HttpServletResponse res) {
        String lang = req.getParameter("lang");
        if (lang != null) {
            res.setLocale(new Locale(lang));
            WebUtils.setSessionAttribute(req, "ff4j_console_language", lang);
            Cookie cookie = new Cookie("ff4j_console_language", lang);
            cookie.setMaxAge(31536000);
            res.addCookie(cookie);
        } else {
            String langSession = (String)WebUtils.getSessionAttribute(req, "ff4j_console_language");
            if (langSession != null) {
                res.setLocale(new Locale(langSession));
            } else {
                Cookie cookie = WebUtils.getCookie(req, "ff4j_console_language");
                if (cookie != null) {
                    WebUtils.setSessionAttribute(req, "ff4j_console_language", cookie.getValue());
                    res.setLocale(new Locale(cookie.getValue()));
                }
            }
        }
    }

    public void get(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.i18n(req, res);
        WebContext ctx = this.makeWebContext(req, res);
        try {
            this.get(req, res, ctx);
        }
        catch (Throwable t) {
            ctx.setVariable("msgType", (Object)"error");
            ctx.setVariable("msgInfo", (Object)t.getMessage());
        }
        this.templateEngine.process(this.getSuccessView(), (IContext)ctx, (Writer)res.getWriter());
    }

    public void post(HttpServletRequest req, HttpServletResponse res) throws IOException {
        WebContext ctx = this.makeWebContext(req, res);
        try {
            this.post(req, res, ctx);
        }
        catch (Throwable t) {
            ctx.setVariable("msgType", (Object)"error");
            ctx.setVariable("msgInfo", (Object)t.getMessage());
        }
        this.templateEngine.process(this.getSuccessView(), (IContext)ctx, (Writer)res.getWriter());
    }

    /*
     * Unable to fully structure code
     */
    private WebContext makeWebContext(HttpServletRequest req, HttpServletResponse res) {
        block2: {
            webExchange = JakartaServletWebApplication.buildApplication((ServletContext)req.getServletContext()).buildExchange(req, res);
            ctx = new WebContext((IWebExchange)webExchange);
            ctx.setVariable("uptime", (Object)this.getUptime());
            ctx.setVariable("version", (Object)Optional.ofNullable(this.ff4j.getVersion()).orElse("1.8.x"));
            ctx.setVariable("secure", (Object)false);
            ctx.setVariable("enableEdit", (Object)true);
            if (this.ff4j.getAuthorizationsManager() == null) break block2;
            ctx.setVariable("secure", (Object)true);
            ctx.setVariable("userName", (Object)this.ff4j.getAuthorizationsManager().getCurrentUserName());
            permissions = this.ff4j.getAuthorizationsManager().getCurrentUserPermissions();
            ctx.setVariable("userPermissions", (Object)permissions);
            if (AbstractController.ADMIN_GROUPS.isEmpty()) ** GOTO lbl-1000
            if (permissions.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(AbstractController.ADMIN_GROUPS))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            ctx.setVariable("enableEdit", (Object)v0);
        }
        return ctx;
    }

    public abstract void get(HttpServletRequest var1, HttpServletResponse var2, WebContext var3) throws Exception;

    public abstract void post(HttpServletRequest var1, HttpServletResponse var2, WebContext var3) throws Exception;

    protected boolean isValidParam(HttpServletRequest req, String param) {
        String pValue = req.getParameter(param);
        return Util.hasLength((String)pValue) && !"null".equals(pValue);
    }

    protected EventQueryDefinition parseQuery(HttpServletRequest req) {
        EventQueryDefinition def = new EventQueryDefinition();
        try {
            if (this.isValidParam(req, "sd")) {
                def.setFrom(SDF.parse(req.getParameter("sd")).getTime());
            }
            if (this.isValidParam(req, "ed")) {
                def.setTo(SDF.parse(req.getParameter("ed")).getTime());
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return def;
    }

    protected EventQueryDefinition buildQuery(HttpServletRequest req) {
        EventQueryDefinition edf = new EventQueryDefinition();
        try {
            Date from = SDFSLOT.parse(req.getParameter("slotfrom"));
            Date to = SDFSLOT.parse(req.getParameter("slotto"));
            edf = new EventQueryDefinition(from.getTime(), to.getTime());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return edf;
    }

    public FF4j getFf4j() {
        return this.ff4j;
    }

    public void setFf4j(FF4j ff4j) {
        this.ff4j = ff4j;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public String getSuccessView() {
        return this.successView;
    }

    public void setSuccessView(String successView) {
        this.successView = successView;
    }
}

