/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ff4j.FF4j;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.chart.BarChart;
import org.ff4j.audit.chart.PieChart;
import org.ff4j.audit.chart.TimeSeriesChart;
import org.ff4j.core.Feature;
import org.ff4j.property.Property;
import org.ff4j.web.controller.AbstractController;
import org.ff4j.web.embedded.ConsoleOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.WebContext;

public class OperationsController
extends AbstractController {
    public static final Logger LOGGER = LoggerFactory.getLogger(OperationsController.class);

    public OperationsController(FF4j ff4j, TemplateEngine te) {
        super(ff4j, null, te);
    }

    @Override
    public void post(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws IOException {
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws IOException {
        String[] pathParts = req.getPathInfo().split("/");
        String operation = pathParts[2];
        if ("export".equalsIgnoreCase(operation)) {
            ConsoleOperations.exportConfiguration(this.ff4j, res, pathParts[3]);
            return;
        }
        if ("features".equalsIgnoreCase(operation)) {
            this.featuresAsJson(req, res);
            return;
        }
        if ("properties".equalsIgnoreCase(operation)) {
            this.propertiesAsJson(req, res);
            return;
        }
        if ("featureUsage".equalsIgnoreCase(operation)) {
            this.graphFeatureUsageHitCountasJson(req, res);
            return;
        }
        if ("timeSeries".equalsIgnoreCase(operation)) {
            this.graphTimeSeriesasJson(req, res);
            return;
        }
        if ("audit".equalsIgnoreCase(operation)) {
            this.auditEventasJson(req, res);
            return;
        }
        res.setStatus(400);
        res.getWriter().println("Invalid request please check URL");
    }

    private void auditEventasJson(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.setContentType("application/json");
        String[] pathParts = req.getPathInfo().split("/");
        if (pathParts.length > 3) {
            Event event;
            String eventUUId = pathParts[3];
            Long eventTime = null;
            if (this.isValidParam(req, "key")) {
                eventTime = Long.valueOf(req.getParameter("key"));
            }
            if ((event = this.getFf4j().getEventRepository().getEventByUUID(eventUUId, eventTime)) != null) {
                res.getWriter().println(event.toString());
            } else {
                res.setStatus(404);
                res.getWriter().println("Event " + eventUUId + " does not exist in event repository.");
            }
        }
    }

    private void graphTimeSeriesasJson(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.setContentType("application/json");
        EventQueryDefinition query = this.parseQuery(req);
        TimeSeriesChart tsc = this.getFf4j().getEventRepository().getFeatureUsageHistory(query, TimeUnit.HOURS);
        res.getWriter().println(tsc.toString());
    }

    private void graphFeatureUsageHitCountasJson(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.setContentType("application/json");
        String[] pathParts = req.getPathInfo().split("/");
        EventQueryDefinition query = this.parseQuery(req);
        if (pathParts.length > 3) {
            String graphName = pathParts[3];
            if ("pieHitRatio".equalsIgnoreCase(graphName)) {
                PieChart pc = this.getFf4j().getEventRepository().getFeatureUsagePieChart(query);
                res.getWriter().println(pc.toJson());
            } else if ("barHitRatio".equalsIgnoreCase(graphName)) {
                BarChart bc = this.getFf4j().getEventRepository().getFeatureUsageBarChart(query);
                res.getWriter().println(bc.toJson());
            } else if ("pieHostRatio".equalsIgnoreCase(graphName)) {
                PieChart pc = this.getFf4j().getEventRepository().getHostPieChart(query);
                res.getWriter().println(pc.toJson());
            } else if ("pieSourceRatio".equalsIgnoreCase(graphName)) {
                PieChart pc = this.getFf4j().getEventRepository().getSourcePieChart(query);
                res.getWriter().println(pc.toJson());
            } else if ("pieUserRatio".equalsIgnoreCase(graphName)) {
                PieChart pc = this.getFf4j().getEventRepository().getUserPieChart(query);
                res.getWriter().println(pc.toJson());
            }
        }
    }

    private void featuresAsJson(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String[] pathParts = req.getPathInfo().split("/");
        res.setContentType("application/json");
        if (pathParts.length > 3) {
            String featureId = pathParts[3];
            if (this.getFf4j().getFeatureStore().exist(featureId)) {
                Feature f = this.getFf4j().getFeatureStore().read(featureId);
                res.getWriter().println(f.toJson());
            } else {
                res.setStatus(404);
                res.getWriter().println("Feature " + featureId + " does not exist in feature store.");
            }
        } else {
            Map mapOfFeatures = this.getFf4j().getFeatureStore().readAll();
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (Feature feature : mapOfFeatures.values()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(feature.toJson());
                first = false;
            }
            sb.append("]");
            res.getWriter().println(sb.toString());
        }
    }

    private void propertiesAsJson(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String[] pathParts = req.getPathInfo().split("/");
        res.setContentType("application/json");
        if (pathParts.length > 3) {
            String propertyName = pathParts[3];
            if (this.getFf4j().getPropertiesStore().existProperty(propertyName)) {
                Property p = this.getFf4j().getPropertiesStore().readProperty(propertyName);
                res.getWriter().println(p.toJson());
            } else {
                res.setStatus(404);
                res.getWriter().println("Property " + propertyName + " does not exist in property store.");
            }
        } else {
            Map mapOfFeatures = this.getFf4j().getPropertiesStore().readAllProperties();
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (Property myProperty : mapOfFeatures.values()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(myProperty.toJson());
                first = false;
            }
            sb.append("]");
            res.getWriter().println(sb.toString());
        }
    }
}

