/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.Map;
import org.ff4j.FF4j;
import org.ff4j.core.FlippingExecutionContext;

public abstract class AbstractFeatureTag
extends TagSupport {
    private static final long serialVersionUID = 3967425494402133171L;
    protected static final String ERROR_MSG_START = "<p><span style=\"color:red;font-weight:bold\">ERROR &lt;ff4j:*&gt; :";
    protected static final String ERROR_MSG_END = "</span>";
    private String featureid = "";
    private boolean shareHttpSession = false;
    private String var;
    private int scope;
    private final String ff4jAttributeName = "FF4J";

    public AbstractFeatureTag() {
        this.init();
    }

    protected void displayError(String message) throws IOException {
        this.pageContext.getOut().print("<p><span style=\"color:red;font-weight:bold\">ERROR &lt;ff4j:*&gt; : " + message + ERROR_MSG_END);
    }

    public int doStartTag() throws JspException {
        boolean result = false;
        try {
            FF4j ff4j = (FF4j)this.pageContext.findAttribute(this.getFf4jAttributeName());
            if (ff4j == null) {
                this.displayError("Cannot find FF4J bean as attribute (" + this.getFf4jAttributeName() + ") in any scope.");
            } else if (!ff4j.exist(this.getFeatureid()) && !ff4j.isAutocreate()) {
                this.displayError("Cannot find feature (" + this.getFeatureid() + ") anywhere.");
            } else if (this.eval(ff4j, this.pageContext)) {
                result = true;
            }
        }
        catch (IOException ioe) {
            throw new JspException("Error occur when processing TAG FF4J", (Throwable)ioe);
        }
        this.exposeVariables(result);
        return result ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean eval(FF4j ff4j, PageContext pageContext) {
        FlippingExecutionContext currentContext = ff4j.getCurrentContext();
        FlippingExecutionContext executionContext = this.isShareHttpSession() ? this.createExecutionContextFromSharedHttpSession(pageContext, currentContext) : currentContext;
        try {
            boolean bl = this.evalWithExecutionContext(ff4j, pageContext, executionContext);
            return bl;
        }
        finally {
            if (this.isShareHttpSession()) {
                ff4j.setCurrentContext(currentContext);
            }
        }
    }

    private FlippingExecutionContext createExecutionContextFromSharedHttpSession(PageContext pageContext, FlippingExecutionContext currentContext) {
        FlippingExecutionContext localExecutionContext = new FlippingExecutionContext(currentContext);
        this.mergeRequestPageContext(pageContext, localExecutionContext);
        return localExecutionContext;
    }

    private void mergeRequestPageContext(PageContext pageContext, FlippingExecutionContext localExecutionContext) {
        localExecutionContext.putString("LOCALE", pageContext.getRequest().getLocalName());
        this.mergeRequestParameters(pageContext, localExecutionContext);
    }

    private void mergeRequestParameters(PageContext pageContext, FlippingExecutionContext localExecutionContext) {
        Map parameters = pageContext.getRequest().getParameterMap();
        for (Map.Entry param : parameters.entrySet()) {
            String[] innerParams = (String[])param.getValue();
            if (innerParams == null) continue;
            StringBuilder sb = new StringBuilder();
            for (String innerParam : innerParams) {
                sb.append(innerParam);
                sb.append(",");
            }
            String expression = sb.toString();
            localExecutionContext.putString((String)param.getKey(), expression.substring(0, expression.length() - 1));
        }
    }

    protected abstract boolean evalWithExecutionContext(FF4j var1, PageContext var2, FlippingExecutionContext var3);

    private void exposeVariables(boolean result) {
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)result, this.scope);
        }
    }

    public String getFeatureid() {
        return this.featureid;
    }

    public void setFeatureid(String featureid) {
        this.featureid = featureid;
    }

    public String getFf4jAttributeName() {
        return "FF4J";
    }

    public boolean isShareHttpSession() {
        return this.shareHttpSession;
    }

    public void setShareHttpSession(boolean shareHttpSession) {
        this.shareHttpSession = shareHttpSession;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public void release() {
        super.release();
        this.init();
    }

    private void init() {
        this.featureid = null;
        this.shareHttpSession = false;
        this.var = null;
        this.scope = 1;
    }
}

