/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api;

import io.swagger.config.Scanner;
import io.swagger.config.ScannerFactory;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import org.ff4j.FF4j;
import org.ff4j.web.ApiConfig;
import org.ff4j.web.api.filter.JerseyApplicationEventListener;
import org.ff4j.web.api.filter.JerseyRequestEventListener;
import org.ff4j.web.api.resources.FF4jResource;
import org.ff4j.web.api.security.FF4jAuthenticationFilter;
import org.ff4j.web.api.security.FF4jAuthorizationFilter;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FF4jApiApplicationJersey2x
extends ResourceConfig {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ApiConfig apiConfig;

    public FF4jApiApplicationJersey2x() {
        this.init();
    }

    protected abstract ApiConfig getWebApiConfiguration();

    public void init() {
        this.packages(new String[]{FF4jResource.class.getPackage().getName()});
        this.register((Object)new FF4jBinder());
        this.register(JerseyApplicationEventListener.class);
        this.register(JerseyRequestEventListener.class);
        this.apiConfig = this.getWebApiConfiguration();
        if (this.apiConfig != null) {
            if (this.apiConfig.isAutorize()) {
                this.enableAuthenticationFilter();
                this.enableAuthorizationFilter();
            } else if (this.apiConfig.isAuthenticate()) {
                this.enableAuthenticationFilter();
            } else {
                this.log.info("No authentication nor authorization");
            }
            if (this.apiConfig.isDocumentation()) {
                BeanConfig beanConfig = new BeanConfig();
                beanConfig.setTitle("FF4J (ff4j.org) WebAPI");
                beanConfig.setDescription("Administrate and operate all tasks on your features through this api");
                beanConfig.setResourcePackage("org.ff4j.web.api.resources");
                beanConfig.setContact("Cedrick Lunven");
                beanConfig.setLicense("Apache 2.0");
                beanConfig.setLicenseUrl("http://www.apache.org/licenses/LICENSE-2.0.html");
                beanConfig.setVersion(this.apiConfig.getVersion());
                beanConfig.setSchemes(new String[]{"http"});
                beanConfig.setHost(this.apiConfig.getHost() + ":" + this.apiConfig.getPort());
                beanConfig.setBasePath("/" + this.apiConfig.getWebContext() + "/api");
                beanConfig.setScan(true);
                ScannerFactory.setScanner((Scanner)beanConfig);
                this.register(ApiListingResource.class);
                this.register(SwaggerSerializers.class);
                this.log.info("Initialisation Swagger [OK]");
            }
        }
        this.log.info("Initialisation WebAPI [OK]");
    }

    private void enableAuthenticationFilter() {
        FF4jAuthenticationFilter.setApiConfig(this.apiConfig);
        this.register(FF4jAuthenticationFilter.class);
        this.log.info("WebService Authentication is now enabled");
    }

    private void enableAuthorizationFilter() {
        FF4jAuthorizationFilter.setApiConfig(this.apiConfig);
        this.register(FF4jAuthorizationFilter.class);
        this.log.info("WebService Authorization is now enabled");
    }

    public class FF4jBinder
    extends AbstractBinder {
        protected void configure() {
            this.bind(FF4jApiApplicationJersey2x.this.getWebApiConfiguration().getFF4j()).to(FF4j.class);
            FF4jApiApplicationJersey2x.this.log.info("FF4J is now bound to Jersey Context.");
        }
    }
}

