/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.filter;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import org.ff4j.web.api.filter.ApiKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyValidatorFilter
implements ContainerRequestFilter {
    public static final String HEADER_APIKEY = "X-FF4J-APIKEY";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, ApiKey> validApiKeysMap;

    public ApiKeyValidatorFilter() {
    }

    public ApiKeyValidatorFilter(Map<String, ApiKey> apiKeys) {
        validApiKeysMap = apiKeys;
    }

    public void filter(ContainerRequestContext reqCtx) throws IOException {
        if (!reqCtx.getHeaders().containsKey((Object)HEADER_APIKEY)) {
            throw new WebApplicationException("API key (X-FF4J-APIKEY) is required for this API", Response.Status.UNAUTHORIZED);
        }
        String apiKey = (String)reqCtx.getHeaders().getFirst((Object)HEADER_APIKEY);
        if (!validApiKeysMap.containsKey(apiKey)) {
            throw new WebApplicationException("Invalid API Key - not recognized", Response.Status.UNAUTHORIZED);
        }
        ApiKey currentKey = validApiKeysMap.get(apiKey);
        if (currentKey.getExpirationTime().before(new Date())) {
            throw new WebApplicationException("API key has expired ", Response.Status.UNAUTHORIZED);
        }
    }

    public static Map<String, ApiKey> getValidApiKeysMap() {
        return validApiKeysMap;
    }

    public static void setValidApiKeysMap(Map<String, ApiKey> validApiKeysMap) {
        ApiKeyValidatorFilter.validApiKeysMap = validApiKeysMap;
    }
}

