/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.ff4j.web.ApiConfig;
import org.ff4j.web.api.security.FF4jSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FF4jAuthorizationFilter
implements ContainerRequestFilter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static ApiConfig apiConfig = null;
    @Context
    public ResourceInfo info;

    public void filter(ContainerRequestContext containerRequest) throws IOException {
        SecurityContext sc;
        String path = containerRequest.getUriInfo().getPath();
        this.log.debug("Entering authorization filter for <" + path + ">");
        if (this.isDenyAll()) {
            FF4jAuthorizationFilter.forbidden();
        }
        if (this.isPermitAll()) {
            return;
        }
        if (this.isRolesAllowed() && (sc = containerRequest.getSecurityContext()) instanceof FF4jSecurityContext) {
            Set<String> expectedRoles = this.getRoles();
            FF4jSecurityContext fsc = (FF4jSecurityContext)sc;
            Set permissions = fsc.getUserRoles();
            if (permissions != null) {
                for (String userPermission : permissions) {
                    if (!expectedRoles.contains(userPermission)) continue;
                    return;
                }
            }
            this.log.warn("Request Forbidden : user role are " + permissions + " but target expected=" + expectedRoles);
            FF4jAuthorizationFilter.forbidden();
        }
    }

    private boolean isPermitAll() {
        return this.info.getResourceMethod().getAnnotation(PermitAll.class) != null;
    }

    private boolean isDenyAll() {
        return this.info.getResourceMethod().getAnnotation(DenyAll.class) != null;
    }

    private boolean isRolesAllowed() {
        return this.info.getResourceMethod().getAnnotation(RolesAllowed.class) != null;
    }

    private Set<String> getRoles() {
        RolesAllowed ra2;
        HashSet<String> roles = new HashSet<String>();
        RolesAllowed ra1 = this.info.getResourceClass().getAnnotation(RolesAllowed.class);
        if (ra1 != null) {
            roles.addAll(Arrays.asList(ra1.value()));
        }
        if ((ra2 = this.info.getResourceMethod().getAnnotation(RolesAllowed.class)) != null) {
            roles.addAll(Arrays.asList(ra2.value()));
        }
        return roles;
    }

    private static void forbidden() {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Cannot reach ressource, forbidden check @RoleAllowed, @DenyAll").type(MediaType.TEXT_HTML_TYPE).build());
    }

    public static ApiConfig getApiConfig() {
        return apiConfig;
    }

    public static void setApiConfig(ApiConfig apiConfig) {
        FF4jAuthorizationFilter.apiConfig = apiConfig;
    }

    public ResourceInfo getInfo() {
        return this.info;
    }

    public void setInfo(ResourceInfo info) {
        this.info = info;
    }
}

