/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.utils;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.Base64;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.ff4j.utils.Util;
import org.ff4j.web.api.FF4jJacksonMapper;
import org.glassfish.jersey.client.ClientConfig;

public class ClientHttpUtils {
    private ClientHttpUtils() {
    }

    public static Client buildJerseyClient() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(JacksonJsonProvider.class);
        clientConfig.register(FF4jJacksonMapper.class);
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    public static Invocation.Builder createRequest(WebTarget webTarget, String auth, MediaType mediaType) {
        Util.assertNotNull((Object[])new Object[]{webTarget});
        Invocation.Builder invocationBuilder = mediaType == null ? webTarget.request() : webTarget.request(new MediaType[]{mediaType});
        if (Util.hasLength((String)auth)) {
            invocationBuilder.header("Authorization", (Object)auth);
        }
        return invocationBuilder;
    }

    public static Response invokeGetMethod(WebTarget webTarget, String auth) {
        return ClientHttpUtils.createRequest(webTarget, auth, MediaType.APPLICATION_JSON_TYPE).get();
    }

    public static Response invokeDeleteMethod(WebTarget webTarget, String auth) {
        return ClientHttpUtils.createRequest(webTarget, auth, null).delete();
    }

    public static Response invokePostMethod(WebTarget webTarget, String auth) {
        return ClientHttpUtils.createRequest(webTarget, auth, MediaType.APPLICATION_JSON_TYPE).post(Entity.text((Object)""));
    }

    public static String buildAuthorization4ApiKey(String apiKey) {
        return "apiKey=" + apiKey;
    }

    public static String buildAuthorization4UserName(String username, String password) {
        String basicAuthCredentials = username + ":" + password;
        return " Basic " + Base64.getEncoder().encodeToString(basicAuthCredentials.getBytes());
    }
}

