/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.jersey2.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.FeatureJsonParser;
import org.ff4j.web.api.resources.domain.FeatureApiBean;
import org.ff4j.web.api.utils.ClientHttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureStoreHttp
extends AbstractFeatureStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String OCCURED = " occured.";
    private static final String CANNOT_GRANT_ROLE_ON_FEATURE_AN_HTTP_ERROR = "Cannot grant role on feature, an HTTP error ";
    protected Client jerseyClient = null;
    private String url = null;
    private String authorizationHeaderValue = null;
    private WebTarget storeWebRsc = null;
    private WebTarget groupsWebRsc = null;

    public FeatureStoreHttp() {
    }

    public FeatureStoreHttp(String rootApiUrl) {
        this.url = rootApiUrl;
    }

    public FeatureStoreHttp(String rootApiUrl, String apiKey) {
        this(rootApiUrl);
        this.authorizationHeaderValue = ClientHttpUtils.buildAuthorization4ApiKey(apiKey);
    }

    public FeatureStoreHttp(String rootApiUrl, String username, String password) {
        this(rootApiUrl);
        this.authorizationHeaderValue = ClientHttpUtils.buildAuthorization4UserName(username, password);
    }

    public Client getJerseyClient() {
        if (this.jerseyClient == null) {
            this.jerseyClient = ClientHttpUtils.buildJerseyClient();
        }
        return this.jerseyClient;
    }

    private WebTarget getStore() {
        Util.assertNotNull((String)this.url, (Object[])new Object[0]);
        if (this.storeWebRsc == null) {
            this.storeWebRsc = this.getJerseyClient().target(this.url).path("store").path("features");
        }
        return this.storeWebRsc;
    }

    private WebTarget getGroups() {
        Util.assertNotNull((String)this.url, (Object[])new Object[0]);
        if (this.groupsWebRsc == null) {
            this.groupsWebRsc = this.getJerseyClient().target(this.url).path("store").path("groups");
        }
        return this.groupsWebRsc;
    }

    public Feature read(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        Response cRes = ClientHttpUtils.invokeGetMethod(this.getStore().path(uid), this.authorizationHeaderValue);
        this.log.info(String.valueOf(this.getStore().path(uid)));
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Error when reaching API code:[" + cRes.getStatus() + "] MSG:" + cRes.getStatusInfo());
        }
        return FeatureJsonParser.parseFeature((String)((String)cRes.readEntity(String.class)));
    }

    public void enable(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        Response cRes = ClientHttpUtils.invokePostMethod(this.getStore().path(uid).path("enable"), this.authorizationHeaderValue);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
    }

    public void disable(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        Response cRes = ClientHttpUtils.invokePostMethod(this.getStore().path(uid).path("disable"), this.authorizationHeaderValue);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
    }

    public boolean exist(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        Response cRes = ClientHttpUtils.invokeGetMethod(this.getStore().path(uid), this.authorizationHeaderValue);
        if (Response.Status.OK.getStatusCode() == cRes.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            return false;
        }
        throw new FeatureAccessException("Cannot check existence of feature, an HTTP error " + cRes.getStatus() + " occured : " + cRes.getEntity());
    }

    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        Response cRes = ClientHttpUtils.createRequest(this.getStore().path(fp.getUid()), this.authorizationHeaderValue, null).put(Entity.entity((Object)new FeatureApiBean(fp), (String)"application/json"));
        if (Response.Status.CREATED.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot create feature, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public Map<String, Feature> readAll() {
        Response cRes = ClientHttpUtils.invokeGetMethod(this.getStore(), this.authorizationHeaderValue);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot read features, an HTTP error " + cRes.getStatus() + OCCURED);
        }
        String resEntity = (String)cRes.readEntity(String.class);
        Feature[] fArray = FeatureJsonParser.parseFeatureArray((String)resEntity);
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (Feature feature : fArray) {
            features.put(feature.getUid(), feature);
        }
        return features;
    }

    public void delete(String uid) {
        Util.assertHasLength((String[])new String[]{uid});
        Response cRes = ClientHttpUtils.invokeDeleteMethod(this.getStore().path(uid), this.authorizationHeaderValue);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot delete feature, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (!this.exist(fp.getUid())) {
            throw new FeatureNotFoundException(fp.getUid());
        }
        Response cRes = ClientHttpUtils.createRequest(this.getStore().path(fp.getUid()), this.authorizationHeaderValue, null).put(Entity.entity((Object)new FeatureApiBean(fp), (String)"application/json"));
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot update feature, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public void grantRoleOnFeature(String uid, String roleName) {
        Util.assertHasLength((String[])new String[]{uid, roleName});
        Response cRes = ClientHttpUtils.invokePostMethod(this.getStore().path(uid).path("grantrole").path(roleName), this.authorizationHeaderValue);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException(CANNOT_GRANT_ROLE_ON_FEATURE_AN_HTTP_ERROR + cRes.getStatus() + OCCURED);
        }
    }

    public void removeRoleFromFeature(String uid, String roleName) {
        Util.assertHasLength((String[])new String[]{uid, roleName});
        Response cRes = ClientHttpUtils.invokePostMethod(this.getStore().path(uid).path("removerole").path(roleName), this.authorizationHeaderValue);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot remove role on feature, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public void addToGroup(String uid, String groupName) {
        Util.assertHasLength((String[])new String[]{uid, groupName});
        Response cRes = ClientHttpUtils.invokePostMethod(this.getStore().path(uid).path("addGroup").path(groupName), this.authorizationHeaderValue);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot add feature to group, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public void removeFromGroup(String uid, String groupName) {
        Util.assertHasLength((String[])new String[]{uid, groupName});
        Response cRes = ClientHttpUtils.invokePostMethod(this.getStore().path(uid).path("removeGroup").path(groupName), this.authorizationHeaderValue);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new FeatureNotFoundException(uid);
        }
        if (Response.Status.BAD_REQUEST.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot remove feature from group, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public void enableGroup(String groupName) {
        Util.assertHasLength((String[])new String[]{groupName});
        Response cRes = ClientHttpUtils.invokePostMethod(this.getGroups().path(groupName).path("enable"), this.authorizationHeaderValue);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException(CANNOT_GRANT_ROLE_ON_FEATURE_AN_HTTP_ERROR + cRes.getStatus() + OCCURED);
        }
    }

    public void disableGroup(String groupName) {
        Util.assertHasLength((String[])new String[]{groupName});
        Response cRes = ClientHttpUtils.invokePostMethod(this.getGroups().path(groupName).path("disable"), this.authorizationHeaderValue);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException(CANNOT_GRANT_ROLE_ON_FEATURE_AN_HTTP_ERROR + cRes.getStatus() + OCCURED);
        }
    }

    public Map<String, Feature> readGroup(String groupName) {
        Util.assertHasLength((String[])new String[]{groupName});
        Response cRes = ClientHttpUtils.invokeGetMethod(this.getGroups().path(groupName), this.authorizationHeaderValue);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new GroupNotFoundException(groupName);
        }
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException(CANNOT_GRANT_ROLE_ON_FEATURE_AN_HTTP_ERROR + cRes.getStatus() + OCCURED);
        }
        String resEntity = (String)cRes.readEntity(String.class);
        Feature[] fArray = FeatureJsonParser.parseFeatureArray((String)resEntity);
        HashMap<String, Feature> features = new HashMap<String, Feature>();
        for (Feature feature : fArray) {
            features.put(feature.getUid(), feature);
        }
        return features;
    }

    public boolean existGroup(String groupName) {
        Util.assertHasLength((String[])new String[]{groupName});
        Response cRes = ClientHttpUtils.invokeGetMethod(this.getGroups().path(groupName), this.authorizationHeaderValue);
        if (Response.Status.OK.getStatusCode() == cRes.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            return false;
        }
        throw new FeatureAccessException("Cannot check existence of group , an HTTP error " + cRes.getStatus() + OCCURED);
    }

    public Set<String> readAllGroups() {
        Response cRes = ClientHttpUtils.invokeGetMethod(this.getGroups(), this.authorizationHeaderValue);
        List groupList = (List)cRes.readEntity(List.class);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot read groups, an HTTP error " + cRes.getStatus() + OCCURED);
        }
        HashSet<String> groupNames = new HashSet<String>();
        for (Map currentGroup : groupList) {
            groupNames.add((String)currentGroup.get("groupName"));
        }
        return groupNames;
    }

    public void clear() {
        Util.assertHasLength((String[])new String[]{this.url});
        Response cRes = ClientHttpUtils.invokePostMethod(this.getJerseyClient().target(this.url).path("store").path("clear"), this.authorizationHeaderValue);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot clear feature store - " + cRes.getStatus());
        }
    }

    public void createSchema() {
        Util.assertHasLength((String[])new String[]{this.url});
        Response cRes = ClientHttpUtils.invokePostMethod(this.getJerseyClient().target(this.url).path("store").path("createSchema"), this.authorizationHeaderValue);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot create feature store - " + cRes.getStatus());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

