/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.jersey2.store;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.PropertyAccessException;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.PropertyJsonParser;
import org.ff4j.web.api.resources.domain.PropertyApiBean;
import org.ff4j.web.api.utils.ClientHttpUtils;

public class PropertyStoreHttp
extends AbstractPropertyStore {
    public static final String OCCURED = " occured.";
    protected Client jerseyClient = null;
    private String url = null;
    private String authorization = null;
    private WebTarget storeWebRsc = null;

    public PropertyStoreHttp() {
    }

    public PropertyStoreHttp(String rootApiUrl) {
        this.url = rootApiUrl;
    }

    public PropertyStoreHttp(String rootApiUrl, String apiKey) {
        this(rootApiUrl);
        this.authorization = ClientHttpUtils.buildAuthorization4ApiKey(apiKey);
    }

    public PropertyStoreHttp(String rootApiUrl, String username, String password) {
        this(rootApiUrl);
        this.authorization = ClientHttpUtils.buildAuthorization4UserName(username, password);
    }

    public Client getJerseyClient() {
        if (this.jerseyClient == null) {
            this.jerseyClient = ClientHttpUtils.buildJerseyClient();
        }
        return this.jerseyClient;
    }

    private WebTarget getStore() {
        if (this.storeWebRsc == null) {
            Util.assertHasLength((String[])new String[]{this.url});
            this.storeWebRsc = this.getJerseyClient().target(this.url).path("propertyStore").path("properties");
        }
        return this.storeWebRsc;
    }

    public boolean existProperty(String name) {
        Util.assertHasLength((String[])new String[]{name});
        Response cRes = ClientHttpUtils.invokeGetMethod(this.getStore().path(name), this.authorization);
        if (Response.Status.OK.getStatusCode() == cRes.getStatus()) {
            return true;
        }
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            return false;
        }
        throw new PropertyAccessException("Cannot check existence of property, an HTTP error " + cRes.getStatus() + " occured : " + cRes.getEntity());
    }

    public <T> void createProperty(Property<T> value) {
        Util.assertNotNull((Object[])new Object[]{value});
        Util.assertHasLength((String[])new String[]{value.getName()});
        if (this.existProperty(value.getName())) {
            throw new PropertyAlreadyExistException("Property already exist");
        }
        Response cRes = ClientHttpUtils.createRequest(this.getStore().path(value.getName()), this.authorization, null).put(Entity.entity((Object)new PropertyApiBean(value), (String)"application/json"));
        if (Response.Status.CREATED.getStatusCode() != cRes.getStatus()) {
            throw new FeatureAccessException("Cannot create properties, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public Property<?> readProperty(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Property name cannot be null nor empty");
        }
        Response cRes = ClientHttpUtils.invokeGetMethod(this.getStore().path(name), this.authorization);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new PropertyNotFoundException(name);
        }
        String resEntity = (String)cRes.readEntity(String.class);
        return PropertyJsonParser.parseProperty((String)resEntity);
    }

    public void deleteProperty(String name) {
        Util.assertHasLength((String[])new String[]{name});
        Response cRes = ClientHttpUtils.invokeDeleteMethod(this.getStore().path(name), this.authorization);
        if (Response.Status.NOT_FOUND.getStatusCode() == cRes.getStatus()) {
            throw new PropertyNotFoundException(name);
        }
        if (Response.Status.NO_CONTENT.getStatusCode() != cRes.getStatus()) {
            throw new PropertyAccessException("Cannot delete property, an HTTP error " + cRes.getStatus() + OCCURED);
        }
    }

    public Map<String, Property<?>> readAllProperties() {
        Response cRes = ClientHttpUtils.invokeGetMethod(this.getStore(), this.authorization);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new PropertyAccessException("Cannot read properties, an HTTP error " + cRes.getStatus() + OCCURED);
        }
        String resEntity = (String)cRes.readEntity(String.class);
        Property[] pArray = PropertyJsonParser.parsePropertyArray((String)resEntity);
        HashMap properties = new HashMap();
        for (Property pName : pArray) {
            properties.put(pName.getName(), pName);
        }
        return properties;
    }

    public Set<String> listPropertyNames() {
        return this.readAllProperties().keySet();
    }

    public void clear() {
        Util.assertHasLength((String[])new String[]{this.url});
        WebTarget wr = this.getJerseyClient().target(this.url).path("propertyStore").path("clear");
        Response cRes = this.post(wr);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new PropertyAccessException("Cannot clear property store - " + cRes.getStatus());
        }
    }

    public void createSchema() {
        Util.assertHasLength((String[])new String[]{this.url});
        WebTarget wr = this.getJerseyClient().target(this.url).path("propertyStore").path("createSchema");
        Response cRes = this.post(wr);
        if (Response.Status.OK.getStatusCode() != cRes.getStatus()) {
            throw new PropertyAccessException("Cannot clear property store - " + cRes.getStatus());
        }
    }

    public static String buildAuthorization4ApiKey(String apiKey) {
        return "apiKey=" + apiKey;
    }

    public static String buildAuthorization4UserName(String username, String password) {
        String basicAuthCreds = username + ":" + password;
        return " Basic " + Base64.getEncoder().encodeToString(basicAuthCreds.getBytes());
    }

    private Response post(WebTarget webTarget) {
        Invocation.Builder invocationBuilder = webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (null != this.authorization) {
            invocationBuilder.header("Authorization", (Object)this.authorization);
        }
        return invocationBuilder.post(Entity.text((Object)""));
    }
}

