/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Calendar;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.web.api.resources.AbstractResource;
import org.ff4j.web.api.resources.domain.EventRepositoryApiBean;
import org.ff4j.web.api.resources.domain.FeatureMonitoringApiBean;
import org.ff4j.web.api.resources.domain.PieSectorApiBean;

@Path(value="/ff4j/monitoring")
@JsonIgnoreType
@Api(value="/ff4j/monitoring")
public class MonitoringResource
extends AbstractResource {
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Display <b>Monitoring</b> information for <b><u>all</u></b> features", notes="The <b>EventRepository</b> handle to store audit events is not required", response=EventRepositoryApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Status of event repository bean", response=EventRepositoryApiBean.class), @ApiResponse(code=404, message="No event repository defined", response=String.class)})
    public Response getMonitoringStatus(@ApiParam(required=false, name="start", value="Start of window <br>(default is today 00:00)") @QueryParam(value="start") Long start, @ApiParam(required=false, name="end", value="End  of window <br>(default is tomorrow 00:00)") @QueryParam(value="end") Long end) {
        if (null == this.getRepo()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No monitoring has been defined").build();
        }
        return Response.ok((Object)new EventRepositoryApiBean(this.getRepo(), start, end)).build();
    }

    @GET
    @Path(value="/{uid}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display <b>Monitoring</b> for a <b><u>single</u></b> feature", notes="Each feature will display a pieChart and a barChart for hits", response=FeatureMonitoringApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Status of current ff4j monitoring bean", response=FeatureMonitoringApiBean.class), @ApiResponse(code=404, message="Feature not found", response=String.class)})
    public Response getFeatureMonitoring(@ApiParam(required=true, name="uid", value="Unique identifier of feature") @PathParam(value="uid") String uid, @ApiParam(required=false, name="start", value="Start of window <br>(default is today 00:00)") @QueryParam(value="start") Long start, @ApiParam(required=false, name="end", value="End  of window <br>(default is tomorrow 00:00)") @QueryParam(value="end") Long end) {
        if (!this.ff4j.getFeatureStore().exist(uid)) {
            String errMsg = new FeatureNotFoundException(uid).getMessage();
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errMsg).build();
        }
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        if (start == null) {
            start = c.getTimeInMillis();
        }
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date(System.currentTimeMillis() + 86400000L));
        c2.set(11, 0);
        c2.set(12, 0);
        c2.set(13, 0);
        if (end == null) {
            end = c2.getTimeInMillis();
        }
        FeatureMonitoringApiBean fmab = new FeatureMonitoringApiBean(uid);
        int hitcount = 0;
        for (PieSectorApiBean sec : fmab.getEventsPie().getSectors()) {
            hitcount = (int)((double)hitcount + sec.getValue());
        }
        fmab.setHitCount(hitcount);
        return Response.ok().entity((Object)fmab).build();
    }
}

