/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.property.Property;
import org.ff4j.web.api.resources.AbstractResource;
import org.ff4j.web.api.resources.domain.CacheApiBean;
import org.ff4j.web.api.resources.domain.FeatureStoreApiBean;
import org.ff4j.web.api.resources.domain.PropertyApiBean;
import org.ff4j.web.api.resources.domain.PropertyStoreApiBean;

@Path(value="/ff4j/propertyStore")
@Produces(value={"application/json"})
@RolesAllowed(value={"READ"})
@Api(value="/ff4j/propertyStore")
public class PropertyStoreResource
extends AbstractResource {
    @GET
    @ApiOperation(value="Display information regarding to <b>Properties</b>", notes="other sub resources to be displayed", response=FeatureStoreApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="status of current ff4j bean")})
    @Produces(value={"application/json"})
    public PropertyStoreApiBean get() {
        return new PropertyStoreApiBean(this.ff4j.getPropertiesStore());
    }

    @GET
    @Path(value="/properties")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display information regarding <b>Properties</b>", response=PropertyApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="get all Properties")})
    public List<PropertyApiBean> readProperties() {
        ArrayList<PropertyApiBean> apiBean = new ArrayList<PropertyApiBean>();
        this.getPropertyStore().readAllProperties();
        for (Property prop : this.getPropertyStore().readAllProperties().values()) {
            apiBean.add(new PropertyApiBean(prop));
        }
        return apiBean;
    }

    @POST
    @Path(value="/clear")
    @ApiOperation(value="Delete all <b>Properties</b> in store")
    @ApiResponses(value={@ApiResponse(code=200, message="status of current ff4j bean", response=PropertyStoreApiBean.class)})
    @Produces(value={"application/json"})
    public PropertyStoreApiBean clearProperties() {
        this.getPropertyStore().clear();
        return new PropertyStoreApiBean(this.ff4j.getPropertiesStore());
    }

    @POST
    @Path(value="/createSchema")
    @ApiOperation(value="Create underlying DB schema for store")
    @ApiResponses(value={@ApiResponse(code=200, message="status of current ff4j bean", response=PropertyStoreApiBean.class)})
    @Produces(value={"application/json"})
    public PropertyStoreApiBean createSchema() {
        this.getPropertyStore().createSchema();
        return new PropertyStoreApiBean(this.ff4j.getPropertiesStore());
    }

    @GET
    @Path(value="/cache")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display information related to <b>Cache</b>")
    @ApiResponses(value={@ApiResponse(code=200, message="status of current ff4j monitoring bean", response=CacheApiBean.class), @ApiResponse(code=404, message="no cache content provided")})
    public Response getStatus() {
        FF4jCacheProxy cacheProxy = this.ff4j.getCacheProxy();
        if (cacheProxy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Current Store is not cached").build();
        }
        return Response.ok((Object)new CacheApiBean(this.getFeatureStore())).build();
    }

    @POST
    @Path(value="/cache")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Clear Cache", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="cache is cleard"), @ApiResponse(code=404, message="no cache content provided")})
    public Response clear() {
        FF4jCacheProxy cacheProxy = this.ff4j.getCacheProxy();
        if (cacheProxy == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Current Store is not cached").build();
        }
        cacheProxy.getCacheManager().clearProperties();
        return Response.ok((Object)"Cache has been cleared").build();
    }
}

