/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.ff4j.FF4j;
import org.ff4j.web.api.resources.domain.AuthorizationsManagerApiBean;
import org.ff4j.web.api.resources.domain.EventRepositoryApiBean;
import org.ff4j.web.api.resources.domain.FeatureStoreApiBean;

@ApiModel(value="ff4jStatus", description="ff4j resource representation")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class FF4jStatusApiBean {
    @ApiModelProperty(value="uptime of the application", required=true)
    @JsonProperty(value="uptime")
    private String uptime;
    @ApiModelProperty(value="feature are created if not exist in store", required=true)
    @JsonProperty(value="autocreate")
    private boolean autocreate = false;
    @ApiModelProperty(value="current version of ff4j library", required=true)
    @JsonProperty(value="version")
    private String version = "N/A";
    @ApiModelProperty(value="feature store resource representation", required=true)
    @JsonProperty(value="featuresStore")
    private FeatureStoreApiBean featuresStore = null;
    @ApiModelProperty(value="event repository resource representation", required=false)
    @JsonProperty(value="eventRepository")
    private EventRepositoryApiBean eventRepository = null;
    @ApiModelProperty(value="authorization manager resource representation", required=false)
    @JsonProperty(value="authorizationsManager")
    private AuthorizationsManagerApiBean authorizationsManager = null;

    public FF4jStatusApiBean() {
    }

    public FF4jStatusApiBean(FF4j ff4j) {
        long up = System.currentTimeMillis() - ff4j.getStartTime();
        long daynumber = up / 86400000L;
        long hourNumber = (up -= daynumber * 1000L * 3600L * 24L) / 3600000L;
        long minutenumber = (up -= hourNumber * 1000L * 3600L) / 60000L;
        long secondnumber = (up -= minutenumber * 1000L * 60L) / 1000L;
        this.uptime = daynumber + " day(s) ";
        this.uptime = this.uptime + hourNumber + " hours(s) ";
        this.uptime = this.uptime + minutenumber + " minute(s) ";
        this.uptime = this.uptime + secondnumber + " seconds\"";
        this.autocreate = ff4j.isAutocreate();
        this.version = ff4j.getVersion();
        if (null != ff4j.getFeatureStore()) {
            this.featuresStore = new FeatureStoreApiBean(ff4j.getFeatureStore());
        }
        if (null != ff4j.getEventRepository()) {
            this.eventRepository = new EventRepositoryApiBean(ff4j.getEventRepository(), null, null);
        }
        if (null != ff4j.getAuthorizationsManager()) {
            this.authorizationsManager = new AuthorizationsManagerApiBean(ff4j.getAuthorizationsManager());
        }
    }

    public String getUptime() {
        return this.uptime;
    }

    public void setUptime(String uptime) {
        this.uptime = uptime;
    }

    public boolean isAutocreate() {
        return this.autocreate;
    }

    public void setAutocreate(boolean autocreate) {
        this.autocreate = autocreate;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public FeatureStoreApiBean getFeaturesStore() {
        return this.featuresStore;
    }

    public void setFeaturesStore(FeatureStoreApiBean featuresStore) {
        this.featuresStore = featuresStore;
    }

    public EventRepositoryApiBean getEventRepository() {
        return this.eventRepository;
    }

    public void setEventRepository(EventRepositoryApiBean eventRepository) {
        this.eventRepository = eventRepository;
    }

    public AuthorizationsManagerApiBean getAuthorizationsManager() {
        return this.authorizationsManager;
    }

    public void setAuthorizationsManager(AuthorizationsManagerApiBean authorizationsManager) {
        this.authorizationsManager = authorizationsManager;
    }
}

