/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.ff4j.audit.chart.PieChart;
import org.ff4j.audit.chart.Serie;
import org.ff4j.web.api.resources.domain.PieSectorApiBean;

@ApiModel(value="pieChart", description="resource representation of a pie chart")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PieChartApiBean {
    @ApiModelProperty(value="title of the graph", required=false)
    @JsonProperty(value="title")
    private String title = null;
    @ApiModelProperty(value="sectors of the pie graph", required=false)
    @JsonProperty(value="sectors")
    private List<PieSectorApiBean> sectors = new ArrayList<PieSectorApiBean>();

    public PieChartApiBean(PieChart pie) {
        this.title = pie.getTitle();
        for (Serie pieSector : pie.getSectors()) {
            this.sectors.add(new PieSectorApiBean((Serie<Integer>)pieSector));
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<PieSectorApiBean> getSectors() {
        return this.sectors;
    }

    public void setSectors(List<PieSectorApiBean> sectors) {
        this.sectors = sectors;
    }
}

