/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.resources.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashSet;
import java.util.Set;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.property.store.PropertyStore;
import org.ff4j.web.api.resources.domain.CacheApiBean;

@ApiModel(value="fpropertyStoreApiBean", description="property store resource representation")
public class PropertyStoreApiBean {
    @JsonProperty(value="type")
    @ApiModelProperty(value="classname of implementation", required=true)
    private String type;
    @JsonProperty(value="numberOfProperties")
    @ApiModelProperty(value="number of properties", required=true)
    private int numberOfProperties = 0;
    @JsonProperty(value="properties")
    @ApiModelProperty(value="list of properties", required=true)
    private Set<String> properties = new HashSet<String>();
    @JsonProperty(value="cache")
    @ApiModelProperty(value="if a cachestore is defined", required=true)
    private CacheApiBean cache = null;

    public PropertyStoreApiBean() {
    }

    public PropertyStoreApiBean(PropertyStore pStore) {
        this.type = pStore.getClass().getName();
        if (pStore instanceof FF4jCacheProxy) {
            this.cache = new CacheApiBean(pStore);
        }
        this.properties = pStore.listPropertyNames();
        this.numberOfProperties = this.properties.size();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CacheApiBean getCache() {
        return this.cache;
    }

    public void setCache(CacheApiBean cache) {
        this.cache = cache;
    }

    public int getNumberOfProperties() {
        return this.numberOfProperties;
    }

    public void setNumberOfProperties(int numberOfProperties) {
        this.numberOfProperties = numberOfProperties;
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<String> properties) {
        this.properties = properties;
    }
}

