/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.AssetTypeEnum;
import cdm.base.staticdata.asset.common.DebtType;
import cdm.base.staticdata.asset.common.EquityTypeEnum;
import cdm.base.staticdata.asset.common.FundProductTypeEnum;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.base.staticdata.asset.common.meta.AssetTypeMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetType", builder=AssetTypeBuilderImpl.class, version="6.7.0")
@RuneDataType(value="AssetType", model="cdm", builder=AssetTypeBuilderImpl.class, version="6.7.0")
public interface AssetType
extends RosettaModelObject {
    public static final AssetTypeMeta metaData = new AssetTypeMeta();

    public AssetTypeEnum getAssetType();

    public InstrumentTypeEnum getSecurityType();

    public DebtType getDebtType();

    public EquityTypeEnum getEquityType();

    public FundProductTypeEnum getFundType();

    public List<String> getOtherAssetType();

    public AssetType build();

    public AssetTypeBuilder toBuilder();

    public static AssetTypeBuilder builder() {
        return new AssetTypeBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetType> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetType> getType() {
        return AssetType.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("assetType"), AssetTypeEnum.class, (Object)this.getAssetType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("securityType"), InstrumentTypeEnum.class, (Object)this.getSecurityType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("debtType"), processor, DebtType.class, this.getDebtType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("equityType"), EquityTypeEnum.class, (Object)this.getEquityType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fundType"), FundProductTypeEnum.class, (Object)this.getFundType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherAssetType"), String.class, this.getOtherAssetType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AssetTypeBuilderImpl
    implements AssetTypeBuilder {
        protected AssetTypeEnum assetType;
        protected InstrumentTypeEnum securityType;
        protected DebtType.DebtTypeBuilder debtType;
        protected EquityTypeEnum equityType;
        protected FundProductTypeEnum fundType;
        protected List<String> otherAssetType = new ArrayList<String>();

        @Override
        @RosettaAttribute(value="assetType")
        @RuneAttribute(value="assetType")
        public AssetTypeEnum getAssetType() {
            return this.assetType;
        }

        @Override
        @RosettaAttribute(value="securityType")
        @RuneAttribute(value="securityType")
        public InstrumentTypeEnum getSecurityType() {
            return this.securityType;
        }

        @Override
        @RosettaAttribute(value="debtType")
        @RuneAttribute(value="debtType")
        public DebtType.DebtTypeBuilder getDebtType() {
            return this.debtType;
        }

        @Override
        public DebtType.DebtTypeBuilder getOrCreateDebtType() {
            DebtType.DebtTypeBuilder result = this.debtType != null ? this.debtType : (this.debtType = DebtType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityType")
        @RuneAttribute(value="equityType")
        public EquityTypeEnum getEquityType() {
            return this.equityType;
        }

        @Override
        @RosettaAttribute(value="fundType")
        @RuneAttribute(value="fundType")
        public FundProductTypeEnum getFundType() {
            return this.fundType;
        }

        @Override
        @RosettaAttribute(value="otherAssetType")
        @RuneAttribute(value="otherAssetType")
        public List<String> getOtherAssetType() {
            return this.otherAssetType;
        }

        @Override
        @RosettaAttribute(value="assetType")
        @RuneAttribute(value="assetType")
        public AssetTypeBuilder setAssetType(AssetTypeEnum _assetType) {
            this.assetType = _assetType == null ? null : _assetType;
            return this;
        }

        @Override
        @RosettaAttribute(value="securityType")
        @RuneAttribute(value="securityType")
        public AssetTypeBuilder setSecurityType(InstrumentTypeEnum _securityType) {
            this.securityType = _securityType == null ? null : _securityType;
            return this;
        }

        @Override
        @RosettaAttribute(value="debtType")
        @RuneAttribute(value="debtType")
        public AssetTypeBuilder setDebtType(DebtType _debtType) {
            this.debtType = _debtType == null ? null : _debtType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityType")
        @RuneAttribute(value="equityType")
        public AssetTypeBuilder setEquityType(EquityTypeEnum _equityType) {
            this.equityType = _equityType == null ? null : _equityType;
            return this;
        }

        @Override
        @RosettaAttribute(value="fundType")
        @RuneAttribute(value="fundType")
        public AssetTypeBuilder setFundType(FundProductTypeEnum _fundType) {
            this.fundType = _fundType == null ? null : _fundType;
            return this;
        }

        @Override
        @RosettaAttribute(value="otherAssetType")
        @RuneAttribute(value="otherAssetType")
        public AssetTypeBuilder addOtherAssetType(String _otherAssetType) {
            if (_otherAssetType != null) {
                this.otherAssetType.add(_otherAssetType);
            }
            return this;
        }

        @Override
        public AssetTypeBuilder addOtherAssetType(String _otherAssetType, int _idx) {
            this.getIndex(this.otherAssetType, _idx, () -> _otherAssetType);
            return this;
        }

        @Override
        public AssetTypeBuilder addOtherAssetType(List<String> otherAssetTypes) {
            if (otherAssetTypes != null) {
                for (String toAdd : otherAssetTypes) {
                    this.otherAssetType.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherAssetType")
        public AssetTypeBuilder setOtherAssetType(List<String> otherAssetTypes) {
            this.otherAssetType = otherAssetTypes == null ? new ArrayList<String>() : (List)otherAssetTypes.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetType build() {
            return new AssetTypeImpl(this);
        }

        @Override
        public AssetTypeBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetTypeBuilder prune() {
            if (this.debtType != null && !this.debtType.prune().hasData()) {
                this.debtType = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAssetType() != null) {
                return true;
            }
            if (this.getSecurityType() != null) {
                return true;
            }
            if (this.getDebtType() != null && this.getDebtType().hasData()) {
                return true;
            }
            if (this.getEquityType() != null) {
                return true;
            }
            if (this.getFundType() != null) {
                return true;
            }
            return this.getOtherAssetType() != null && !this.getOtherAssetType().isEmpty();
        }

        public AssetTypeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetTypeBuilder o = (AssetTypeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDebtType(), (RosettaModelObjectBuilder)o.getDebtType(), this::setDebtType);
            merger.mergeBasic((Object)this.getAssetType(), (Object)o.getAssetType(), this::setAssetType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSecurityType(), (Object)o.getSecurityType(), this::setSecurityType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEquityType(), (Object)o.getEquityType(), this::setEquityType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFundType(), (Object)o.getFundType(), this::setFundType, new AttributeMeta[0]);
            merger.mergeBasic(this.getOtherAssetType(), o.getOtherAssetType(), this::addOtherAssetType);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetType _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.assetType, (Object)_that.getAssetType())) {
                return false;
            }
            if (!Objects.equals((Object)this.securityType, (Object)_that.getSecurityType())) {
                return false;
            }
            if (!Objects.equals(this.debtType, _that.getDebtType())) {
                return false;
            }
            if (!Objects.equals((Object)this.equityType, (Object)_that.getEquityType())) {
                return false;
            }
            if (!Objects.equals((Object)this.fundType, (Object)_that.getFundType())) {
                return false;
            }
            return ListEquals.listEquals(this.otherAssetType, _that.getOtherAssetType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.assetType != null ? ((Object)((Object)this.assetType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.securityType != null ? ((Object)((Object)this.securityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.debtType != null ? this.debtType.hashCode() : 0);
            _result = 31 * _result + (this.equityType != null ? ((Object)((Object)this.equityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fundType != null ? ((Object)((Object)this.fundType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.otherAssetType != null ? this.otherAssetType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetTypeBuilder {assetType=" + (Object)((Object)this.assetType) + ", securityType=" + (Object)((Object)this.securityType) + ", debtType=" + this.debtType + ", equityType=" + (Object)((Object)this.equityType) + ", fundType=" + (Object)((Object)this.fundType) + ", otherAssetType=" + this.otherAssetType + '}';
        }
    }

    public static interface AssetTypeBuilder
    extends AssetType,
    RosettaModelObjectBuilder {
        public DebtType.DebtTypeBuilder getOrCreateDebtType();

        @Override
        public DebtType.DebtTypeBuilder getDebtType();

        public AssetTypeBuilder setAssetType(AssetTypeEnum var1);

        public AssetTypeBuilder setSecurityType(InstrumentTypeEnum var1);

        public AssetTypeBuilder setDebtType(DebtType var1);

        public AssetTypeBuilder setEquityType(EquityTypeEnum var1);

        public AssetTypeBuilder setFundType(FundProductTypeEnum var1);

        public AssetTypeBuilder addOtherAssetType(String var1);

        public AssetTypeBuilder addOtherAssetType(String var1, int var2);

        public AssetTypeBuilder addOtherAssetType(List<String> var1);

        public AssetTypeBuilder setOtherAssetType(List<String> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("assetType"), AssetTypeEnum.class, (Object)this.getAssetType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("securityType"), InstrumentTypeEnum.class, (Object)this.getSecurityType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("debtType"), processor, DebtType.DebtTypeBuilder.class, this.getDebtType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("equityType"), EquityTypeEnum.class, (Object)this.getEquityType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fundType"), FundProductTypeEnum.class, (Object)this.getFundType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherAssetType"), String.class, this.getOtherAssetType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AssetTypeBuilder prune();
    }

    public static class AssetTypeImpl
    implements AssetType {
        private final AssetTypeEnum assetType;
        private final InstrumentTypeEnum securityType;
        private final DebtType debtType;
        private final EquityTypeEnum equityType;
        private final FundProductTypeEnum fundType;
        private final List<String> otherAssetType;

        protected AssetTypeImpl(AssetTypeBuilder builder) {
            this.assetType = builder.getAssetType();
            this.securityType = builder.getSecurityType();
            this.debtType = Optional.ofNullable(builder.getDebtType()).map(f -> f.build()).orElse(null);
            this.equityType = builder.getEquityType();
            this.fundType = builder.getFundType();
            this.otherAssetType = Optional.ofNullable(builder.getOtherAssetType()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="assetType")
        @RuneAttribute(value="assetType")
        public AssetTypeEnum getAssetType() {
            return this.assetType;
        }

        @Override
        @RosettaAttribute(value="securityType")
        @RuneAttribute(value="securityType")
        public InstrumentTypeEnum getSecurityType() {
            return this.securityType;
        }

        @Override
        @RosettaAttribute(value="debtType")
        @RuneAttribute(value="debtType")
        public DebtType getDebtType() {
            return this.debtType;
        }

        @Override
        @RosettaAttribute(value="equityType")
        @RuneAttribute(value="equityType")
        public EquityTypeEnum getEquityType() {
            return this.equityType;
        }

        @Override
        @RosettaAttribute(value="fundType")
        @RuneAttribute(value="fundType")
        public FundProductTypeEnum getFundType() {
            return this.fundType;
        }

        @Override
        @RosettaAttribute(value="otherAssetType")
        @RuneAttribute(value="otherAssetType")
        public List<String> getOtherAssetType() {
            return this.otherAssetType;
        }

        @Override
        public AssetType build() {
            return this;
        }

        @Override
        public AssetTypeBuilder toBuilder() {
            AssetTypeBuilder builder = AssetType.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetTypeBuilder builder) {
            Optional.ofNullable(this.getAssetType()).ifPresent(builder::setAssetType);
            Optional.ofNullable(this.getSecurityType()).ifPresent(builder::setSecurityType);
            Optional.ofNullable(this.getDebtType()).ifPresent(builder::setDebtType);
            Optional.ofNullable(this.getEquityType()).ifPresent(builder::setEquityType);
            Optional.ofNullable(this.getFundType()).ifPresent(builder::setFundType);
            Optional.ofNullable(this.getOtherAssetType()).ifPresent(builder::setOtherAssetType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetType _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.assetType, (Object)_that.getAssetType())) {
                return false;
            }
            if (!Objects.equals((Object)this.securityType, (Object)_that.getSecurityType())) {
                return false;
            }
            if (!Objects.equals(this.debtType, _that.getDebtType())) {
                return false;
            }
            if (!Objects.equals((Object)this.equityType, (Object)_that.getEquityType())) {
                return false;
            }
            if (!Objects.equals((Object)this.fundType, (Object)_that.getFundType())) {
                return false;
            }
            return ListEquals.listEquals(this.otherAssetType, _that.getOtherAssetType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.assetType != null ? ((Object)((Object)this.assetType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.securityType != null ? ((Object)((Object)this.securityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.debtType != null ? this.debtType.hashCode() : 0);
            _result = 31 * _result + (this.equityType != null ? ((Object)((Object)this.equityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fundType != null ? ((Object)((Object)this.fundType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.otherAssetType != null ? this.otherAssetType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetType {assetType=" + (Object)((Object)this.assetType) + ", securityType=" + (Object)((Object)this.securityType) + ", debtType=" + this.debtType + ", equityType=" + (Object)((Object)this.equityType) + ", fundType=" + (Object)((Object)this.fundType) + ", otherAssetType=" + this.otherAssetType + '}';
        }
    }
}

