/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.AssetIdTypeEnum;
import cdm.base.staticdata.asset.common.Cash;
import cdm.base.staticdata.asset.common.CurrencyCodeEnum;
import cdm.base.staticdata.asset.common.functions.AssetIdentifierByType;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="CashCurrencyExists")
@ImplementedBy(value=Default.class)
public interface CashCurrencyExists
extends Validator<Cash> {
    public static final String NAME = "CashCurrencyExists";
    public static final String DEFINITION = "AssetIdentifierByType(identifier, AssetIdTypeEnum -> CurrencyCode) count = 1 and AssetIdentifierByType(identifier, AssetIdTypeEnum -> CurrencyCode) -> identifier first to-enum CurrencyCodeEnum exists";

    public static class NoOp
    implements CashCurrencyExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Cash cash) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CashCurrencyExists {
        @Inject
        protected AssetIdentifierByType assetIdentifierByType;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Cash cash) {
            ComparisonResult result = this.executeDataRule(cash);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CashCurrencyExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Cash", (RosettaPath)path, (String)CashCurrencyExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CashCurrencyExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Cash", (RosettaPath)path, (String)CashCurrencyExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Cash cash) {
            try {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperC.of(this.assetIdentifierByType.evaluate(MapperS.of((Object)cash).mapC("getIdentifier", _cash -> _cash.getIdentifier()).getMulti(), AssetIdTypeEnum.CURRENCY_CODE)).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.exists((Mapper)MapperC.of(this.assetIdentifierByType.evaluate(MapperS.of((Object)cash).mapC("getIdentifier", _cash -> _cash.getIdentifier()).getMulti(), AssetIdTypeEnum.CURRENCY_CODE)).map("getIdentifier", assetIdentifier -> assetIdentifier.getIdentifier()).first().map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()).checkedMap("to-enum", CurrencyCodeEnum::fromDisplayName, IllegalArgumentException.class)));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

