/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.identifier.processor;

import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LinkIdMappingProcessor
extends MappingProcessor {
    public static final List<String> EVENT_LINK_ID_SCHEMES = Arrays.asList("http://www.fpml.org/coding-scheme/external/esma-ptrr-compression", "http://www.fpml.org/coding-scheme/external/esma-ptrr-portfolio-rebalancing", "http://www.fpml.org/coding-scheme/external/esma-ptrr-margin-management");
    public static final String TRADE_LINK_ID_SCHEME = "http://www.fpml.org/coding-scheme/external/esma-report-tracking-number";

    public LinkIdMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        this.updateSchemeAndSource(synonymPath, (FieldWithMetaString.FieldWithMetaStringBuilder)builder);
    }

    protected void updateSchemeAndSource(Path linkIdSynonymPath, FieldWithMetaString.FieldWithMetaStringBuilder builder) {
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)linkIdSynonymPath.addElement("linkIdScheme"), linkIdScheme -> {
            String modelPath = this.getModelPath().buildPath();
            if (EVENT_LINK_ID_SCHEMES.contains(linkIdScheme) && modelPath.contains(".eventIdentifier") || TRADE_LINK_ID_SCHEME.equals(linkIdScheme) && modelPath.contains(".tradeIdentifier")) {
                builder.getOrCreateMeta().setScheme(linkIdScheme);
                return true;
            }
            builder.setValue(null);
            this.getNonNullMappings(linkIdSynonymPath).forEach(m -> MappingProcessorUtils.updateMappingFail((Mapping)m, (String)"no destination"));
            return false;
        }, (List)this.getMappings(), (RosettaPath)this.getModelPath());
    }

    private List<Mapping> getNonNullMappings(Path synonymPath) {
        return this.getMappings().stream().filter(m -> synonymPath.nameIndexMatches(m.getXmlPath())).collect(Collectors.toList());
    }
}

