/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.CollateralBalance;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.MarginCallExposure;
import cdm.event.common.MarginCallInstructionType;
import cdm.event.common.RegIMRoleEnum;
import cdm.event.common.RegMarginTypeEnum;
import cdm.event.common.meta.MarginCallBaseMeta;
import cdm.event.common.metafields.ReferenceWithMetaCollateralPortfolio;
import cdm.legaldocumentation.common.AgreementName;
import cdm.observable.asset.Money;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MarginCallBase", builder=MarginCallBaseBuilderImpl.class, version="6.7.0")
@RuneDataType(value="MarginCallBase", model="cdm", builder=MarginCallBaseBuilderImpl.class, version="6.7.0")
public interface MarginCallBase
extends RosettaModelObject {
    public static final MarginCallBaseMeta metaData = new MarginCallBaseMeta();

    public MarginCallInstructionType getInstructionType();

    public List<? extends Party> getParty();

    public List<? extends PartyRole> getPartyRole();

    public Party getClearingBroker();

    public Identifier getCallIdentifier();

    public AgreementName getCallAgreementType();

    public Money getAgreementMinimumTransferAmount();

    public Money getAgreementThreshold();

    public Money getAgreementRounding();

    public RegMarginTypeEnum getRegMarginType();

    public RegIMRoleEnum getRegIMRole();

    public MarginCallExposure getBaseCurrencyExposure();

    public ReferenceWithMetaCollateralPortfolio getCollateralPortfolio();

    public CollateralBalance getIndependentAmountBalance();

    public MarginCallBase build();

    public MarginCallBaseBuilder toBuilder();

    public static MarginCallBaseBuilder builder() {
        return new MarginCallBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends MarginCallBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MarginCallBase> getType() {
        return MarginCallBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("instructionType"), processor, MarginCallInstructionType.class, this.getInstructionType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearingBroker"), processor, Party.class, this.getClearingBroker(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callIdentifier"), processor, Identifier.class, this.getCallIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callAgreementType"), processor, AgreementName.class, this.getCallAgreementType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementMinimumTransferAmount"), processor, Money.class, this.getAgreementMinimumTransferAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementThreshold"), processor, Money.class, this.getAgreementThreshold(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementRounding"), processor, Money.class, this.getAgreementRounding(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("regMarginType"), RegMarginTypeEnum.class, (Object)this.getRegMarginType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("regIMRole"), RegIMRoleEnum.class, (Object)this.getRegIMRole(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("baseCurrencyExposure"), processor, MarginCallExposure.class, this.getBaseCurrencyExposure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("independentAmountBalance"), processor, CollateralBalance.class, this.getIndependentAmountBalance(), new AttributeMeta[0]);
    }

    public static class MarginCallBaseBuilderImpl
    implements MarginCallBaseBuilder {
        protected MarginCallInstructionType.MarginCallInstructionTypeBuilder instructionType;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();
        protected List<PartyRole.PartyRoleBuilder> partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected Party.PartyBuilder clearingBroker;
        protected Identifier.IdentifierBuilder callIdentifier;
        protected AgreementName.AgreementNameBuilder callAgreementType;
        protected Money.MoneyBuilder agreementMinimumTransferAmount;
        protected Money.MoneyBuilder agreementThreshold;
        protected Money.MoneyBuilder agreementRounding;
        protected RegMarginTypeEnum regMarginType;
        protected RegIMRoleEnum regIMRole;
        protected MarginCallExposure.MarginCallExposureBuilder baseCurrencyExposure;
        protected ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder collateralPortfolio;
        protected CollateralBalance.CollateralBalanceBuilder independentAmountBalance;

        @Override
        @RosettaAttribute(value="instructionType")
        @RuneAttribute(value="instructionType")
        public MarginCallInstructionType.MarginCallInstructionTypeBuilder getInstructionType() {
            return this.instructionType;
        }

        @Override
        public MarginCallInstructionType.MarginCallInstructionTypeBuilder getOrCreateInstructionType() {
            MarginCallInstructionType.MarginCallInstructionTypeBuilder result = this.instructionType != null ? this.instructionType : (this.instructionType = MarginCallInstructionType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int _index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, _index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int _index) {
            if (this.partyRole == null) {
                this.partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.partyRole, _index, () -> {
                PartyRole.PartyRoleBuilder newPartyRole = PartyRole.builder();
                return newPartyRole;
            });
        }

        @Override
        @RosettaAttribute(value="clearingBroker")
        @RuneAttribute(value="clearingBroker")
        public Party.PartyBuilder getClearingBroker() {
            return this.clearingBroker;
        }

        @Override
        public Party.PartyBuilder getOrCreateClearingBroker() {
            Party.PartyBuilder result = this.clearingBroker != null ? this.clearingBroker : (this.clearingBroker = Party.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="callIdentifier")
        @RuneAttribute(value="callIdentifier")
        public Identifier.IdentifierBuilder getCallIdentifier() {
            return this.callIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreateCallIdentifier() {
            Identifier.IdentifierBuilder result = this.callIdentifier != null ? this.callIdentifier : (this.callIdentifier = Identifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="callAgreementType")
        @RuneAttribute(value="callAgreementType")
        public AgreementName.AgreementNameBuilder getCallAgreementType() {
            return this.callAgreementType;
        }

        @Override
        public AgreementName.AgreementNameBuilder getOrCreateCallAgreementType() {
            AgreementName.AgreementNameBuilder result = this.callAgreementType != null ? this.callAgreementType : (this.callAgreementType = AgreementName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="agreementMinimumTransferAmount")
        @RuneAttribute(value="agreementMinimumTransferAmount")
        public Money.MoneyBuilder getAgreementMinimumTransferAmount() {
            return this.agreementMinimumTransferAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAgreementMinimumTransferAmount() {
            Money.MoneyBuilder result = this.agreementMinimumTransferAmount != null ? this.agreementMinimumTransferAmount : (this.agreementMinimumTransferAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="agreementThreshold")
        @RuneAttribute(value="agreementThreshold")
        public Money.MoneyBuilder getAgreementThreshold() {
            return this.agreementThreshold;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAgreementThreshold() {
            Money.MoneyBuilder result = this.agreementThreshold != null ? this.agreementThreshold : (this.agreementThreshold = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="agreementRounding")
        @RuneAttribute(value="agreementRounding")
        public Money.MoneyBuilder getAgreementRounding() {
            return this.agreementRounding;
        }

        @Override
        public Money.MoneyBuilder getOrCreateAgreementRounding() {
            Money.MoneyBuilder result = this.agreementRounding != null ? this.agreementRounding : (this.agreementRounding = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="regMarginType")
        @RuneAttribute(value="regMarginType")
        public RegMarginTypeEnum getRegMarginType() {
            return this.regMarginType;
        }

        @Override
        @RosettaAttribute(value="regIMRole")
        @RuneAttribute(value="regIMRole")
        public RegIMRoleEnum getRegIMRole() {
            return this.regIMRole;
        }

        @Override
        @RosettaAttribute(value="baseCurrencyExposure")
        @RuneAttribute(value="baseCurrencyExposure")
        public MarginCallExposure.MarginCallExposureBuilder getBaseCurrencyExposure() {
            return this.baseCurrencyExposure;
        }

        @Override
        public MarginCallExposure.MarginCallExposureBuilder getOrCreateBaseCurrencyExposure() {
            MarginCallExposure.MarginCallExposureBuilder result = this.baseCurrencyExposure != null ? this.baseCurrencyExposure : (this.baseCurrencyExposure = MarginCallExposure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getCollateralPortfolio() {
            return this.collateralPortfolio;
        }

        @Override
        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getOrCreateCollateralPortfolio() {
            ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder result = this.collateralPortfolio != null ? this.collateralPortfolio : (this.collateralPortfolio = ReferenceWithMetaCollateralPortfolio.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="independentAmountBalance")
        @RuneAttribute(value="independentAmountBalance")
        public CollateralBalance.CollateralBalanceBuilder getIndependentAmountBalance() {
            return this.independentAmountBalance;
        }

        @Override
        public CollateralBalance.CollateralBalanceBuilder getOrCreateIndependentAmountBalance() {
            CollateralBalance.CollateralBalanceBuilder result = this.independentAmountBalance != null ? this.independentAmountBalance : (this.independentAmountBalance = CollateralBalance.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="instructionType")
        @RuneAttribute(value="instructionType")
        public MarginCallBaseBuilder setInstructionType(MarginCallInstructionType _instructionType) {
            this.instructionType = _instructionType == null ? null : _instructionType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public MarginCallBaseBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallBaseBuilder addParty(Party _party, int _idx) {
            this.getIndex(this.party, _idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public MarginCallBaseBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public MarginCallBaseBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public MarginCallBaseBuilder addPartyRole(PartyRole _partyRole) {
            if (_partyRole != null) {
                this.partyRole.add(_partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallBaseBuilder addPartyRole(PartyRole _partyRole, int _idx) {
            this.getIndex(this.partyRole, _idx, () -> _partyRole.toBuilder());
            return this;
        }

        @Override
        public MarginCallBaseBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyRole")
        public MarginCallBaseBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingBroker")
        @RuneAttribute(value="clearingBroker")
        public MarginCallBaseBuilder setClearingBroker(Party _clearingBroker) {
            this.clearingBroker = _clearingBroker == null ? null : _clearingBroker.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callIdentifier")
        @RuneAttribute(value="callIdentifier")
        public MarginCallBaseBuilder setCallIdentifier(Identifier _callIdentifier) {
            this.callIdentifier = _callIdentifier == null ? null : _callIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callAgreementType")
        @RuneAttribute(value="callAgreementType")
        public MarginCallBaseBuilder setCallAgreementType(AgreementName _callAgreementType) {
            this.callAgreementType = _callAgreementType == null ? null : _callAgreementType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementMinimumTransferAmount")
        @RuneAttribute(value="agreementMinimumTransferAmount")
        public MarginCallBaseBuilder setAgreementMinimumTransferAmount(Money _agreementMinimumTransferAmount) {
            this.agreementMinimumTransferAmount = _agreementMinimumTransferAmount == null ? null : _agreementMinimumTransferAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementThreshold")
        @RuneAttribute(value="agreementThreshold")
        public MarginCallBaseBuilder setAgreementThreshold(Money _agreementThreshold) {
            this.agreementThreshold = _agreementThreshold == null ? null : _agreementThreshold.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementRounding")
        @RuneAttribute(value="agreementRounding")
        public MarginCallBaseBuilder setAgreementRounding(Money _agreementRounding) {
            this.agreementRounding = _agreementRounding == null ? null : _agreementRounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regMarginType")
        @RuneAttribute(value="regMarginType")
        public MarginCallBaseBuilder setRegMarginType(RegMarginTypeEnum _regMarginType) {
            this.regMarginType = _regMarginType == null ? null : _regMarginType;
            return this;
        }

        @Override
        @RosettaAttribute(value="regIMRole")
        @RuneAttribute(value="regIMRole")
        public MarginCallBaseBuilder setRegIMRole(RegIMRoleEnum _regIMRole) {
            this.regIMRole = _regIMRole == null ? null : _regIMRole;
            return this;
        }

        @Override
        @RosettaAttribute(value="baseCurrencyExposure")
        @RuneAttribute(value="baseCurrencyExposure")
        public MarginCallBaseBuilder setBaseCurrencyExposure(MarginCallExposure _baseCurrencyExposure) {
            this.baseCurrencyExposure = _baseCurrencyExposure == null ? null : _baseCurrencyExposure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public MarginCallBaseBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio _collateralPortfolio) {
            this.collateralPortfolio = _collateralPortfolio == null ? null : _collateralPortfolio.toBuilder();
            return this;
        }

        @Override
        public MarginCallBaseBuilder setCollateralPortfolioValue(CollateralPortfolio _collateralPortfolio) {
            this.getOrCreateCollateralPortfolio().setValue(_collateralPortfolio);
            return this;
        }

        @Override
        @RosettaAttribute(value="independentAmountBalance")
        @RuneAttribute(value="independentAmountBalance")
        public MarginCallBaseBuilder setIndependentAmountBalance(CollateralBalance _independentAmountBalance) {
            this.independentAmountBalance = _independentAmountBalance == null ? null : _independentAmountBalance.toBuilder();
            return this;
        }

        @Override
        public MarginCallBase build() {
            return new MarginCallBaseImpl(this);
        }

        @Override
        public MarginCallBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public MarginCallBaseBuilder prune() {
            if (this.instructionType != null && !this.instructionType.prune().hasData()) {
                this.instructionType = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyRole = this.partyRole.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.clearingBroker != null && !this.clearingBroker.prune().hasData()) {
                this.clearingBroker = null;
            }
            if (this.callIdentifier != null && !this.callIdentifier.prune().hasData()) {
                this.callIdentifier = null;
            }
            if (this.callAgreementType != null && !this.callAgreementType.prune().hasData()) {
                this.callAgreementType = null;
            }
            if (this.agreementMinimumTransferAmount != null && !this.agreementMinimumTransferAmount.prune().hasData()) {
                this.agreementMinimumTransferAmount = null;
            }
            if (this.agreementThreshold != null && !this.agreementThreshold.prune().hasData()) {
                this.agreementThreshold = null;
            }
            if (this.agreementRounding != null && !this.agreementRounding.prune().hasData()) {
                this.agreementRounding = null;
            }
            if (this.baseCurrencyExposure != null && !this.baseCurrencyExposure.prune().hasData()) {
                this.baseCurrencyExposure = null;
            }
            if (this.collateralPortfolio != null && !this.collateralPortfolio.prune().hasData()) {
                this.collateralPortfolio = null;
            }
            if (this.independentAmountBalance != null && !this.independentAmountBalance.prune().hasData()) {
                this.independentAmountBalance = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getInstructionType() != null && this.getInstructionType().hasData()) {
                return true;
            }
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyRole() != null && this.getPartyRole().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getClearingBroker() != null && this.getClearingBroker().hasData()) {
                return true;
            }
            if (this.getCallIdentifier() != null && this.getCallIdentifier().hasData()) {
                return true;
            }
            if (this.getCallAgreementType() != null && this.getCallAgreementType().hasData()) {
                return true;
            }
            if (this.getAgreementMinimumTransferAmount() != null && this.getAgreementMinimumTransferAmount().hasData()) {
                return true;
            }
            if (this.getAgreementThreshold() != null && this.getAgreementThreshold().hasData()) {
                return true;
            }
            if (this.getAgreementRounding() != null && this.getAgreementRounding().hasData()) {
                return true;
            }
            if (this.getRegMarginType() != null) {
                return true;
            }
            if (this.getRegIMRole() != null) {
                return true;
            }
            if (this.getBaseCurrencyExposure() != null && this.getBaseCurrencyExposure().hasData()) {
                return true;
            }
            if (this.getCollateralPortfolio() != null && this.getCollateralPortfolio().hasData()) {
                return true;
            }
            return this.getIndependentAmountBalance() != null && this.getIndependentAmountBalance().hasData();
        }

        public MarginCallBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MarginCallBaseBuilder o = (MarginCallBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInstructionType(), (RosettaModelObjectBuilder)o.getInstructionType(), this::setInstructionType);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta(this.getPartyRole(), o.getPartyRole(), this::getOrCreatePartyRole);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearingBroker(), (RosettaModelObjectBuilder)o.getClearingBroker(), this::setClearingBroker);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCallIdentifier(), (RosettaModelObjectBuilder)o.getCallIdentifier(), this::setCallIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCallAgreementType(), (RosettaModelObjectBuilder)o.getCallAgreementType(), this::setCallAgreementType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementMinimumTransferAmount(), (RosettaModelObjectBuilder)o.getAgreementMinimumTransferAmount(), this::setAgreementMinimumTransferAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementThreshold(), (RosettaModelObjectBuilder)o.getAgreementThreshold(), this::setAgreementThreshold);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementRounding(), (RosettaModelObjectBuilder)o.getAgreementRounding(), this::setAgreementRounding);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBaseCurrencyExposure(), (RosettaModelObjectBuilder)o.getBaseCurrencyExposure(), this::setBaseCurrencyExposure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralPortfolio(), (RosettaModelObjectBuilder)o.getCollateralPortfolio(), this::setCollateralPortfolio);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndependentAmountBalance(), (RosettaModelObjectBuilder)o.getIndependentAmountBalance(), this::setIndependentAmountBalance);
            merger.mergeBasic((Object)this.getRegMarginType(), (Object)o.getRegMarginType(), this::setRegMarginType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRegIMRole(), (Object)o.getRegIMRole(), this::setRegIMRole, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MarginCallBase _that = this.getType().cast(o);
            if (!Objects.equals(this.instructionType, _that.getInstructionType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals(this.clearingBroker, _that.getClearingBroker())) {
                return false;
            }
            if (!Objects.equals(this.callIdentifier, _that.getCallIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.callAgreementType, _that.getCallAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.agreementMinimumTransferAmount, _that.getAgreementMinimumTransferAmount())) {
                return false;
            }
            if (!Objects.equals(this.agreementThreshold, _that.getAgreementThreshold())) {
                return false;
            }
            if (!Objects.equals(this.agreementRounding, _that.getAgreementRounding())) {
                return false;
            }
            if (!Objects.equals((Object)this.regMarginType, (Object)_that.getRegMarginType())) {
                return false;
            }
            if (!Objects.equals((Object)this.regIMRole, (Object)_that.getRegIMRole())) {
                return false;
            }
            if (!Objects.equals(this.baseCurrencyExposure, _that.getBaseCurrencyExposure())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolio, _that.getCollateralPortfolio())) {
                return false;
            }
            return Objects.equals(this.independentAmountBalance, _that.getIndependentAmountBalance());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.instructionType != null ? this.instructionType.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.clearingBroker != null ? this.clearingBroker.hashCode() : 0);
            _result = 31 * _result + (this.callIdentifier != null ? this.callIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.callAgreementType != null ? this.callAgreementType.hashCode() : 0);
            _result = 31 * _result + (this.agreementMinimumTransferAmount != null ? this.agreementMinimumTransferAmount.hashCode() : 0);
            _result = 31 * _result + (this.agreementThreshold != null ? this.agreementThreshold.hashCode() : 0);
            _result = 31 * _result + (this.agreementRounding != null ? this.agreementRounding.hashCode() : 0);
            _result = 31 * _result + (this.regMarginType != null ? ((Object)((Object)this.regMarginType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.regIMRole != null ? ((Object)((Object)this.regIMRole)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.baseCurrencyExposure != null ? this.baseCurrencyExposure.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolio != null ? this.collateralPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.independentAmountBalance != null ? this.independentAmountBalance.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MarginCallBaseBuilder {instructionType=" + this.instructionType + ", party=" + this.party + ", partyRole=" + this.partyRole + ", clearingBroker=" + this.clearingBroker + ", callIdentifier=" + this.callIdentifier + ", callAgreementType=" + this.callAgreementType + ", agreementMinimumTransferAmount=" + this.agreementMinimumTransferAmount + ", agreementThreshold=" + this.agreementThreshold + ", agreementRounding=" + this.agreementRounding + ", regMarginType=" + (Object)((Object)this.regMarginType) + ", regIMRole=" + (Object)((Object)this.regIMRole) + ", baseCurrencyExposure=" + this.baseCurrencyExposure + ", collateralPortfolio=" + this.collateralPortfolio + ", independentAmountBalance=" + this.independentAmountBalance + '}';
        }
    }

    public static interface MarginCallBaseBuilder
    extends MarginCallBase,
    RosettaModelObjectBuilder {
        public MarginCallInstructionType.MarginCallInstructionTypeBuilder getOrCreateInstructionType();

        @Override
        public MarginCallInstructionType.MarginCallInstructionTypeBuilder getInstructionType();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole();

        public Party.PartyBuilder getOrCreateClearingBroker();

        @Override
        public Party.PartyBuilder getClearingBroker();

        public Identifier.IdentifierBuilder getOrCreateCallIdentifier();

        @Override
        public Identifier.IdentifierBuilder getCallIdentifier();

        public AgreementName.AgreementNameBuilder getOrCreateCallAgreementType();

        @Override
        public AgreementName.AgreementNameBuilder getCallAgreementType();

        public Money.MoneyBuilder getOrCreateAgreementMinimumTransferAmount();

        @Override
        public Money.MoneyBuilder getAgreementMinimumTransferAmount();

        public Money.MoneyBuilder getOrCreateAgreementThreshold();

        @Override
        public Money.MoneyBuilder getAgreementThreshold();

        public Money.MoneyBuilder getOrCreateAgreementRounding();

        @Override
        public Money.MoneyBuilder getAgreementRounding();

        public MarginCallExposure.MarginCallExposureBuilder getOrCreateBaseCurrencyExposure();

        @Override
        public MarginCallExposure.MarginCallExposureBuilder getBaseCurrencyExposure();

        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getOrCreateCollateralPortfolio();

        @Override
        public ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder getCollateralPortfolio();

        public CollateralBalance.CollateralBalanceBuilder getOrCreateIndependentAmountBalance();

        @Override
        public CollateralBalance.CollateralBalanceBuilder getIndependentAmountBalance();

        public MarginCallBaseBuilder setInstructionType(MarginCallInstructionType var1);

        public MarginCallBaseBuilder addParty(Party var1);

        public MarginCallBaseBuilder addParty(Party var1, int var2);

        public MarginCallBaseBuilder addParty(List<? extends Party> var1);

        public MarginCallBaseBuilder setParty(List<? extends Party> var1);

        public MarginCallBaseBuilder addPartyRole(PartyRole var1);

        public MarginCallBaseBuilder addPartyRole(PartyRole var1, int var2);

        public MarginCallBaseBuilder addPartyRole(List<? extends PartyRole> var1);

        public MarginCallBaseBuilder setPartyRole(List<? extends PartyRole> var1);

        public MarginCallBaseBuilder setClearingBroker(Party var1);

        public MarginCallBaseBuilder setCallIdentifier(Identifier var1);

        public MarginCallBaseBuilder setCallAgreementType(AgreementName var1);

        public MarginCallBaseBuilder setAgreementMinimumTransferAmount(Money var1);

        public MarginCallBaseBuilder setAgreementThreshold(Money var1);

        public MarginCallBaseBuilder setAgreementRounding(Money var1);

        public MarginCallBaseBuilder setRegMarginType(RegMarginTypeEnum var1);

        public MarginCallBaseBuilder setRegIMRole(RegIMRoleEnum var1);

        public MarginCallBaseBuilder setBaseCurrencyExposure(MarginCallExposure var1);

        public MarginCallBaseBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1);

        public MarginCallBaseBuilder setCollateralPortfolioValue(CollateralPortfolio var1);

        public MarginCallBaseBuilder setIndependentAmountBalance(CollateralBalance var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("instructionType"), processor, MarginCallInstructionType.MarginCallInstructionTypeBuilder.class, this.getInstructionType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearingBroker"), processor, Party.PartyBuilder.class, this.getClearingBroker(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getCallIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callAgreementType"), processor, AgreementName.AgreementNameBuilder.class, this.getCallAgreementType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementMinimumTransferAmount"), processor, Money.MoneyBuilder.class, this.getAgreementMinimumTransferAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementThreshold"), processor, Money.MoneyBuilder.class, this.getAgreementThreshold(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementRounding"), processor, Money.MoneyBuilder.class, this.getAgreementRounding(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("regMarginType"), RegMarginTypeEnum.class, (Object)this.getRegMarginType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("regIMRole"), RegIMRoleEnum.class, (Object)this.getRegIMRole(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("baseCurrencyExposure"), processor, MarginCallExposure.MarginCallExposureBuilder.class, this.getBaseCurrencyExposure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralPortfolio"), processor, ReferenceWithMetaCollateralPortfolio.ReferenceWithMetaCollateralPortfolioBuilder.class, this.getCollateralPortfolio(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("independentAmountBalance"), processor, CollateralBalance.CollateralBalanceBuilder.class, this.getIndependentAmountBalance(), new AttributeMeta[0]);
        }

        public MarginCallBaseBuilder prune();
    }

    public static class MarginCallBaseImpl
    implements MarginCallBase {
        private final MarginCallInstructionType instructionType;
        private final List<? extends Party> party;
        private final List<? extends PartyRole> partyRole;
        private final Party clearingBroker;
        private final Identifier callIdentifier;
        private final AgreementName callAgreementType;
        private final Money agreementMinimumTransferAmount;
        private final Money agreementThreshold;
        private final Money agreementRounding;
        private final RegMarginTypeEnum regMarginType;
        private final RegIMRoleEnum regIMRole;
        private final MarginCallExposure baseCurrencyExposure;
        private final ReferenceWithMetaCollateralPortfolio collateralPortfolio;
        private final CollateralBalance independentAmountBalance;

        protected MarginCallBaseImpl(MarginCallBaseBuilder builder) {
            this.instructionType = Optional.ofNullable(builder.getInstructionType()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyRole = Optional.ofNullable(builder.getPartyRole()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.clearingBroker = Optional.ofNullable(builder.getClearingBroker()).map(f -> f.build()).orElse(null);
            this.callIdentifier = Optional.ofNullable(builder.getCallIdentifier()).map(f -> f.build()).orElse(null);
            this.callAgreementType = Optional.ofNullable(builder.getCallAgreementType()).map(f -> f.build()).orElse(null);
            this.agreementMinimumTransferAmount = Optional.ofNullable(builder.getAgreementMinimumTransferAmount()).map(f -> f.build()).orElse(null);
            this.agreementThreshold = Optional.ofNullable(builder.getAgreementThreshold()).map(f -> f.build()).orElse(null);
            this.agreementRounding = Optional.ofNullable(builder.getAgreementRounding()).map(f -> f.build()).orElse(null);
            this.regMarginType = builder.getRegMarginType();
            this.regIMRole = builder.getRegIMRole();
            this.baseCurrencyExposure = Optional.ofNullable(builder.getBaseCurrencyExposure()).map(f -> f.build()).orElse(null);
            this.collateralPortfolio = Optional.ofNullable(builder.getCollateralPortfolio()).map(f -> f.build()).orElse(null);
            this.independentAmountBalance = Optional.ofNullable(builder.getIndependentAmountBalance()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="instructionType")
        @RuneAttribute(value="instructionType")
        public MarginCallInstructionType getInstructionType() {
            return this.instructionType;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        @RuneAttribute(value="partyRole")
        public List<? extends PartyRole> getPartyRole() {
            return this.partyRole;
        }

        @Override
        @RosettaAttribute(value="clearingBroker")
        @RuneAttribute(value="clearingBroker")
        public Party getClearingBroker() {
            return this.clearingBroker;
        }

        @Override
        @RosettaAttribute(value="callIdentifier")
        @RuneAttribute(value="callIdentifier")
        public Identifier getCallIdentifier() {
            return this.callIdentifier;
        }

        @Override
        @RosettaAttribute(value="callAgreementType")
        @RuneAttribute(value="callAgreementType")
        public AgreementName getCallAgreementType() {
            return this.callAgreementType;
        }

        @Override
        @RosettaAttribute(value="agreementMinimumTransferAmount")
        @RuneAttribute(value="agreementMinimumTransferAmount")
        public Money getAgreementMinimumTransferAmount() {
            return this.agreementMinimumTransferAmount;
        }

        @Override
        @RosettaAttribute(value="agreementThreshold")
        @RuneAttribute(value="agreementThreshold")
        public Money getAgreementThreshold() {
            return this.agreementThreshold;
        }

        @Override
        @RosettaAttribute(value="agreementRounding")
        @RuneAttribute(value="agreementRounding")
        public Money getAgreementRounding() {
            return this.agreementRounding;
        }

        @Override
        @RosettaAttribute(value="regMarginType")
        @RuneAttribute(value="regMarginType")
        public RegMarginTypeEnum getRegMarginType() {
            return this.regMarginType;
        }

        @Override
        @RosettaAttribute(value="regIMRole")
        @RuneAttribute(value="regIMRole")
        public RegIMRoleEnum getRegIMRole() {
            return this.regIMRole;
        }

        @Override
        @RosettaAttribute(value="baseCurrencyExposure")
        @RuneAttribute(value="baseCurrencyExposure")
        public MarginCallExposure getBaseCurrencyExposure() {
            return this.baseCurrencyExposure;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        @RuneAttribute(value="collateralPortfolio")
        public ReferenceWithMetaCollateralPortfolio getCollateralPortfolio() {
            return this.collateralPortfolio;
        }

        @Override
        @RosettaAttribute(value="independentAmountBalance")
        @RuneAttribute(value="independentAmountBalance")
        public CollateralBalance getIndependentAmountBalance() {
            return this.independentAmountBalance;
        }

        @Override
        public MarginCallBase build() {
            return this;
        }

        @Override
        public MarginCallBaseBuilder toBuilder() {
            MarginCallBaseBuilder builder = MarginCallBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MarginCallBaseBuilder builder) {
            Optional.ofNullable(this.getInstructionType()).ifPresent(builder::setInstructionType);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getPartyRole()).ifPresent(builder::setPartyRole);
            Optional.ofNullable(this.getClearingBroker()).ifPresent(builder::setClearingBroker);
            Optional.ofNullable(this.getCallIdentifier()).ifPresent(builder::setCallIdentifier);
            Optional.ofNullable(this.getCallAgreementType()).ifPresent(builder::setCallAgreementType);
            Optional.ofNullable(this.getAgreementMinimumTransferAmount()).ifPresent(builder::setAgreementMinimumTransferAmount);
            Optional.ofNullable(this.getAgreementThreshold()).ifPresent(builder::setAgreementThreshold);
            Optional.ofNullable(this.getAgreementRounding()).ifPresent(builder::setAgreementRounding);
            Optional.ofNullable(this.getRegMarginType()).ifPresent(builder::setRegMarginType);
            Optional.ofNullable(this.getRegIMRole()).ifPresent(builder::setRegIMRole);
            Optional.ofNullable(this.getBaseCurrencyExposure()).ifPresent(builder::setBaseCurrencyExposure);
            Optional.ofNullable(this.getCollateralPortfolio()).ifPresent(builder::setCollateralPortfolio);
            Optional.ofNullable(this.getIndependentAmountBalance()).ifPresent(builder::setIndependentAmountBalance);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MarginCallBase _that = this.getType().cast(o);
            if (!Objects.equals(this.instructionType, _that.getInstructionType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals(this.clearingBroker, _that.getClearingBroker())) {
                return false;
            }
            if (!Objects.equals(this.callIdentifier, _that.getCallIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.callAgreementType, _that.getCallAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.agreementMinimumTransferAmount, _that.getAgreementMinimumTransferAmount())) {
                return false;
            }
            if (!Objects.equals(this.agreementThreshold, _that.getAgreementThreshold())) {
                return false;
            }
            if (!Objects.equals(this.agreementRounding, _that.getAgreementRounding())) {
                return false;
            }
            if (!Objects.equals((Object)this.regMarginType, (Object)_that.getRegMarginType())) {
                return false;
            }
            if (!Objects.equals((Object)this.regIMRole, (Object)_that.getRegIMRole())) {
                return false;
            }
            if (!Objects.equals(this.baseCurrencyExposure, _that.getBaseCurrencyExposure())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolio, _that.getCollateralPortfolio())) {
                return false;
            }
            return Objects.equals(this.independentAmountBalance, _that.getIndependentAmountBalance());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.instructionType != null ? this.instructionType.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.clearingBroker != null ? this.clearingBroker.hashCode() : 0);
            _result = 31 * _result + (this.callIdentifier != null ? this.callIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.callAgreementType != null ? this.callAgreementType.hashCode() : 0);
            _result = 31 * _result + (this.agreementMinimumTransferAmount != null ? this.agreementMinimumTransferAmount.hashCode() : 0);
            _result = 31 * _result + (this.agreementThreshold != null ? this.agreementThreshold.hashCode() : 0);
            _result = 31 * _result + (this.agreementRounding != null ? this.agreementRounding.hashCode() : 0);
            _result = 31 * _result + (this.regMarginType != null ? ((Object)((Object)this.regMarginType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.regIMRole != null ? ((Object)((Object)this.regIMRole)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.baseCurrencyExposure != null ? this.baseCurrencyExposure.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolio != null ? this.collateralPortfolio.hashCode() : 0);
            _result = 31 * _result + (this.independentAmountBalance != null ? this.independentAmountBalance.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MarginCallBase {instructionType=" + this.instructionType + ", party=" + this.party + ", partyRole=" + this.partyRole + ", clearingBroker=" + this.clearingBroker + ", callIdentifier=" + this.callIdentifier + ", callAgreementType=" + this.callAgreementType + ", agreementMinimumTransferAmount=" + this.agreementMinimumTransferAmount + ", agreementThreshold=" + this.agreementThreshold + ", agreementRounding=" + this.agreementRounding + ", regMarginType=" + (Object)((Object)this.regMarginType) + ", regIMRole=" + (Object)((Object)this.regIMRole) + ", baseCurrencyExposure=" + this.baseCurrencyExposure + ", collateralPortfolio=" + this.collateralPortfolio + ", independentAmountBalance=" + this.independentAmountBalance + '}';
        }
    }
}

