/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.meta.ResetInstructionMeta;
import cdm.product.template.Payout;
import cdm.product.template.metafields.ReferenceWithMetaPayout;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ResetInstruction", builder=ResetInstructionBuilderImpl.class, version="6.7.0")
@RuneDataType(value="ResetInstruction", model="cdm", builder=ResetInstructionBuilderImpl.class, version="6.7.0")
public interface ResetInstruction
extends RosettaModelObject {
    public static final ResetInstructionMeta metaData = new ResetInstructionMeta();

    public List<? extends ReferenceWithMetaPayout> getPayout();

    public Date getRateRecordDate();

    public Date getResetDate();

    public ResetInstruction build();

    public ResetInstructionBuilder toBuilder();

    public static ResetInstructionBuilder builder() {
        return new ResetInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends ResetInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ResetInstruction> getType() {
        return ResetInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payout"), processor, ReferenceWithMetaPayout.class, this.getPayout(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rateRecordDate"), Date.class, (Object)this.getRateRecordDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ResetInstructionBuilderImpl
    implements ResetInstructionBuilder {
        protected List<ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder> payout = new ArrayList<ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder>();
        protected Date rateRecordDate;
        protected Date resetDate;

        @Override
        @RosettaAttribute(value="payout")
        @RuneAttribute(value="payout")
        public List<? extends ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder> getPayout() {
            return this.payout;
        }

        @Override
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getOrCreatePayout(int _index) {
            if (this.payout == null) {
                this.payout = new ArrayList<ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder>();
            }
            return (ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder)this.getIndex(this.payout, _index, () -> {
                ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder newPayout = ReferenceWithMetaPayout.builder();
                return newPayout;
            });
        }

        @Override
        @RosettaAttribute(value="rateRecordDate")
        @RuneAttribute(value="rateRecordDate")
        public Date getRateRecordDate() {
            return this.rateRecordDate;
        }

        @Override
        @RosettaAttribute(value="resetDate")
        @RuneAttribute(value="resetDate")
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        @RosettaAttribute(value="payout")
        @RuneAttribute(value="payout")
        public ResetInstructionBuilder addPayout(ReferenceWithMetaPayout _payout) {
            if (_payout != null) {
                this.payout.add(_payout.toBuilder());
            }
            return this;
        }

        @Override
        public ResetInstructionBuilder addPayout(ReferenceWithMetaPayout _payout, int _idx) {
            this.getIndex(this.payout, _idx, () -> _payout.toBuilder());
            return this;
        }

        @Override
        public ResetInstructionBuilder addPayoutValue(Payout _payout) {
            this.getOrCreatePayout(-1).setValue(_payout.toBuilder());
            return this;
        }

        @Override
        public ResetInstructionBuilder addPayoutValue(Payout _payout, int _idx) {
            this.getOrCreatePayout(_idx).setValue(_payout.toBuilder());
            return this;
        }

        @Override
        public ResetInstructionBuilder addPayout(List<? extends ReferenceWithMetaPayout> payouts) {
            if (payouts != null) {
                for (ReferenceWithMetaPayout referenceWithMetaPayout : payouts) {
                    this.payout.add(referenceWithMetaPayout.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="payout")
        public ResetInstructionBuilder setPayout(List<? extends ReferenceWithMetaPayout> payouts) {
            this.payout = payouts == null ? new ArrayList<ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder>() : (List)payouts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ResetInstructionBuilder addPayoutValue(List<? extends Payout> payouts) {
            if (payouts != null) {
                for (Payout payout : payouts) {
                    this.addPayoutValue(payout);
                }
            }
            return this;
        }

        @Override
        public ResetInstructionBuilder setPayoutValue(List<? extends Payout> payouts) {
            this.payout.clear();
            if (payouts != null) {
                payouts.forEach(this::addPayoutValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="rateRecordDate")
        @RuneAttribute(value="rateRecordDate")
        public ResetInstructionBuilder setRateRecordDate(Date _rateRecordDate) {
            this.rateRecordDate = _rateRecordDate == null ? null : _rateRecordDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="resetDate")
        @RuneAttribute(value="resetDate")
        public ResetInstructionBuilder setResetDate(Date _resetDate) {
            this.resetDate = _resetDate == null ? null : _resetDate;
            return this;
        }

        @Override
        public ResetInstruction build() {
            return new ResetInstructionImpl(this);
        }

        @Override
        public ResetInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public ResetInstructionBuilder prune() {
            this.payout = this.payout.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPayout() != null && this.getPayout().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getRateRecordDate() != null) {
                return true;
            }
            return this.getResetDate() != null;
        }

        public ResetInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ResetInstructionBuilder o = (ResetInstructionBuilder)other;
            merger.mergeRosetta(this.getPayout(), o.getPayout(), this::getOrCreatePayout);
            merger.mergeBasic((Object)this.getRateRecordDate(), (Object)o.getRateRecordDate(), this::setRateRecordDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getResetDate(), (Object)o.getResetDate(), this::setResetDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ResetInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.payout, _that.getPayout())) {
                return false;
            }
            if (!Objects.equals(this.rateRecordDate, _that.getRateRecordDate())) {
                return false;
            }
            return Objects.equals(this.resetDate, _that.getResetDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.rateRecordDate != null ? this.rateRecordDate.hashCode() : 0);
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ResetInstructionBuilder {payout=" + this.payout + ", rateRecordDate=" + this.rateRecordDate + ", resetDate=" + this.resetDate + '}';
        }
    }

    public static interface ResetInstructionBuilder
    extends ResetInstruction,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder getOrCreatePayout(int var1);

        public List<? extends ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder> getPayout();

        public ResetInstructionBuilder addPayout(ReferenceWithMetaPayout var1);

        public ResetInstructionBuilder addPayout(ReferenceWithMetaPayout var1, int var2);

        public ResetInstructionBuilder addPayoutValue(Payout var1);

        public ResetInstructionBuilder addPayoutValue(Payout var1, int var2);

        public ResetInstructionBuilder addPayout(List<? extends ReferenceWithMetaPayout> var1);

        public ResetInstructionBuilder setPayout(List<? extends ReferenceWithMetaPayout> var1);

        public ResetInstructionBuilder addPayoutValue(List<? extends Payout> var1);

        public ResetInstructionBuilder setPayoutValue(List<? extends Payout> var1);

        public ResetInstructionBuilder setRateRecordDate(Date var1);

        public ResetInstructionBuilder setResetDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payout"), processor, ReferenceWithMetaPayout.ReferenceWithMetaPayoutBuilder.class, this.getPayout(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rateRecordDate"), Date.class, (Object)this.getRateRecordDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ResetInstructionBuilder prune();
    }

    public static class ResetInstructionImpl
    implements ResetInstruction {
        private final List<? extends ReferenceWithMetaPayout> payout;
        private final Date rateRecordDate;
        private final Date resetDate;

        protected ResetInstructionImpl(ResetInstructionBuilder builder) {
            this.payout = Optional.ofNullable(builder.getPayout()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.rateRecordDate = builder.getRateRecordDate();
            this.resetDate = builder.getResetDate();
        }

        @Override
        @RosettaAttribute(value="payout")
        @RuneAttribute(value="payout")
        public List<? extends ReferenceWithMetaPayout> getPayout() {
            return this.payout;
        }

        @Override
        @RosettaAttribute(value="rateRecordDate")
        @RuneAttribute(value="rateRecordDate")
        public Date getRateRecordDate() {
            return this.rateRecordDate;
        }

        @Override
        @RosettaAttribute(value="resetDate")
        @RuneAttribute(value="resetDate")
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        public ResetInstruction build() {
            return this;
        }

        @Override
        public ResetInstructionBuilder toBuilder() {
            ResetInstructionBuilder builder = ResetInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ResetInstructionBuilder builder) {
            Optional.ofNullable(this.getPayout()).ifPresent(builder::setPayout);
            Optional.ofNullable(this.getRateRecordDate()).ifPresent(builder::setRateRecordDate);
            Optional.ofNullable(this.getResetDate()).ifPresent(builder::setResetDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ResetInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.payout, _that.getPayout())) {
                return false;
            }
            if (!Objects.equals(this.rateRecordDate, _that.getRateRecordDate())) {
                return false;
            }
            return Objects.equals(this.resetDate, _that.getResetDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.rateRecordDate != null ? this.rateRecordDate.hashCode() : 0);
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ResetInstruction {payout=" + this.payout + ", rateRecordDate=" + this.rateRecordDate + ", resetDate=" + this.resetDate + '}';
        }
    }
}

