/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.CompareOp;
import cdm.event.common.TradeState;
import cdm.product.template.TradeLot;
import cdm.product.template.functions.CompareTradeLotToAmount;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=CompareTradeStatesToAmountDefault.class)
public abstract class CompareTradeStatesToAmount
implements RosettaFunction {
    @Inject
    protected CompareTradeLotToAmount compareTradeLotToAmount;

    public Boolean evaluate(List<? extends TradeState> tradeStates, CompareOp op, BigDecimal amount) {
        Boolean result = this.doEvaluate(tradeStates, op, amount);
        return result;
    }

    protected abstract Boolean doEvaluate(List<? extends TradeState> var1, CompareOp var2, BigDecimal var3);

    public static class CompareTradeStatesToAmountDefault
    extends CompareTradeStatesToAmount {
        @Override
        protected Boolean doEvaluate(List<? extends TradeState> tradeStates, CompareOp op, BigDecimal amount) {
            if (tradeStates == null) {
                tradeStates = Collections.emptyList();
            }
            Boolean result = null;
            return this.assignOutput(result, tradeStates, op, amount);
        }

        protected Boolean assignOutput(Boolean result, List<? extends TradeState> tradeStates, CompareOp op, BigDecimal amount) {
            result = ExpressionOperators.areEqual((Mapper)MapperC.of(tradeStates).mapItem(item -> MapperS.of((Object)this.compareTradeLotToAmount.evaluate((TradeLot)item.map("getTrade", tradeState -> tradeState.getTrade()).mapC("getTradeLot", trade -> trade.getTradeLot()).get(), op, amount))), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).get();
            return result;
        }
    }
}

