/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.ContractFormationInstruction;
import cdm.event.common.TradeState;
import cdm.event.position.PositionStatusEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_ContractFormationDefault.class)
public abstract class Create_ContractFormation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public TradeState evaluate(ContractFormationInstruction instruction, TradeState execution) {
        TradeState contractFormation;
        TradeState.TradeStateBuilder contractFormationBuilder = this.doEvaluate(instruction, execution);
        if (contractFormationBuilder == null) {
            contractFormation = null;
        } else {
            contractFormation = contractFormationBuilder.build();
            this.objectValidator.validate(TradeState.class, (RosettaModelObject)contractFormation);
        }
        return contractFormation;
    }

    protected abstract TradeState.TradeStateBuilder doEvaluate(ContractFormationInstruction var1, TradeState var2);

    public static class Create_ContractFormationDefault
    extends Create_ContractFormation {
        @Override
        protected TradeState.TradeStateBuilder doEvaluate(ContractFormationInstruction instruction, TradeState execution) {
            TradeState.TradeStateBuilder contractFormation = TradeState.builder();
            return this.assignOutput(contractFormation, instruction, execution);
        }

        protected TradeState.TradeStateBuilder assignOutput(TradeState.TradeStateBuilder contractFormation, ContractFormationInstruction instruction, TradeState execution) {
            contractFormation = (TradeState.TradeStateBuilder)this.toBuilder(execution);
            contractFormation.getOrCreateTrade().getOrCreateContractDetails().addDocumentation(MapperS.of((Object)instruction).mapC("getLegalAgreement", contractFormationInstruction -> contractFormationInstruction.getLegalAgreement()).getMulti());
            contractFormation.getOrCreateState().setPositionState(PositionStatusEnum.FORMED);
            return Optional.ofNullable(contractFormation).map(o -> o.prune()).orElse(null);
        }
    }
}

