/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.event.position.InventoryRecord;
import cdm.event.position.meta.InventoryMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Inventory", builder=InventoryBuilderImpl.class, version="6.7.0")
@RuneDataType(value="Inventory", model="cdm", builder=InventoryBuilderImpl.class, version="6.7.0")
public interface Inventory
extends RosettaModelObject {
    public static final InventoryMeta metaData = new InventoryMeta();

    public List<? extends InventoryRecord> getInventoryRecord();

    public Inventory build();

    public InventoryBuilder toBuilder();

    public static InventoryBuilder builder() {
        return new InventoryBuilderImpl();
    }

    default public RosettaMetaData<? extends Inventory> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Inventory> getType() {
        return Inventory.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("inventoryRecord"), processor, InventoryRecord.class, this.getInventoryRecord(), new AttributeMeta[0]);
    }

    public static class InventoryBuilderImpl
    implements InventoryBuilder {
        protected List<InventoryRecord.InventoryRecordBuilder> inventoryRecord = new ArrayList<InventoryRecord.InventoryRecordBuilder>();

        @Override
        @RosettaAttribute(value="inventoryRecord")
        @RuneAttribute(value="inventoryRecord")
        public List<? extends InventoryRecord.InventoryRecordBuilder> getInventoryRecord() {
            return this.inventoryRecord;
        }

        @Override
        public InventoryRecord.InventoryRecordBuilder getOrCreateInventoryRecord(int _index) {
            if (this.inventoryRecord == null) {
                this.inventoryRecord = new ArrayList<InventoryRecord.InventoryRecordBuilder>();
            }
            return (InventoryRecord.InventoryRecordBuilder)this.getIndex(this.inventoryRecord, _index, () -> {
                InventoryRecord.InventoryRecordBuilder newInventoryRecord = InventoryRecord.builder();
                return newInventoryRecord;
            });
        }

        @Override
        @RosettaAttribute(value="inventoryRecord")
        @RuneAttribute(value="inventoryRecord")
        public InventoryBuilder addInventoryRecord(InventoryRecord _inventoryRecord) {
            if (_inventoryRecord != null) {
                this.inventoryRecord.add(_inventoryRecord.toBuilder());
            }
            return this;
        }

        @Override
        public InventoryBuilder addInventoryRecord(InventoryRecord _inventoryRecord, int _idx) {
            this.getIndex(this.inventoryRecord, _idx, () -> _inventoryRecord.toBuilder());
            return this;
        }

        @Override
        public InventoryBuilder addInventoryRecord(List<? extends InventoryRecord> inventoryRecords) {
            if (inventoryRecords != null) {
                for (InventoryRecord inventoryRecord : inventoryRecords) {
                    this.inventoryRecord.add(inventoryRecord.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="inventoryRecord")
        public InventoryBuilder setInventoryRecord(List<? extends InventoryRecord> inventoryRecords) {
            this.inventoryRecord = inventoryRecords == null ? new ArrayList<InventoryRecord.InventoryRecordBuilder>() : (List)inventoryRecords.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Inventory build() {
            return new InventoryImpl(this);
        }

        @Override
        public InventoryBuilder toBuilder() {
            return this;
        }

        @Override
        public InventoryBuilder prune() {
            this.inventoryRecord = this.inventoryRecord.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            return this.getInventoryRecord() != null && this.getInventoryRecord().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public InventoryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            InventoryBuilder o = (InventoryBuilder)other;
            merger.mergeRosetta(this.getInventoryRecord(), o.getInventoryRecord(), this::getOrCreateInventoryRecord);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Inventory _that = this.getType().cast(o);
            return ListEquals.listEquals(this.inventoryRecord, _that.getInventoryRecord());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.inventoryRecord != null ? this.inventoryRecord.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InventoryBuilder {inventoryRecord=" + this.inventoryRecord + '}';
        }
    }

    public static interface InventoryBuilder
    extends Inventory,
    RosettaModelObjectBuilder {
        public InventoryRecord.InventoryRecordBuilder getOrCreateInventoryRecord(int var1);

        public List<? extends InventoryRecord.InventoryRecordBuilder> getInventoryRecord();

        public InventoryBuilder addInventoryRecord(InventoryRecord var1);

        public InventoryBuilder addInventoryRecord(InventoryRecord var1, int var2);

        public InventoryBuilder addInventoryRecord(List<? extends InventoryRecord> var1);

        public InventoryBuilder setInventoryRecord(List<? extends InventoryRecord> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("inventoryRecord"), processor, InventoryRecord.InventoryRecordBuilder.class, this.getInventoryRecord(), new AttributeMeta[0]);
        }

        public InventoryBuilder prune();
    }

    public static class InventoryImpl
    implements Inventory {
        private final List<? extends InventoryRecord> inventoryRecord;

        protected InventoryImpl(InventoryBuilder builder) {
            this.inventoryRecord = Optional.ofNullable(builder.getInventoryRecord()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="inventoryRecord")
        @RuneAttribute(value="inventoryRecord")
        public List<? extends InventoryRecord> getInventoryRecord() {
            return this.inventoryRecord;
        }

        @Override
        public Inventory build() {
            return this;
        }

        @Override
        public InventoryBuilder toBuilder() {
            InventoryBuilder builder = Inventory.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InventoryBuilder builder) {
            Optional.ofNullable(this.getInventoryRecord()).ifPresent(builder::setInventoryRecord);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Inventory _that = this.getType().cast(o);
            return ListEquals.listEquals(this.inventoryRecord, _that.getInventoryRecord());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.inventoryRecord != null ? this.inventoryRecord.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Inventory {inventoryRecord=" + this.inventoryRecord + '}';
        }
    }
}

