/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.party.LegalEntity;
import cdm.base.staticdata.party.Party;
import cdm.legaldocumentation.common.CreditSupportProviderTermsEnum;
import cdm.legaldocumentation.csa.meta.CreditSupportProviderElectionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditSupportProviderElection", builder=CreditSupportProviderElectionBuilderImpl.class, version="6.7.0")
@RuneDataType(value="CreditSupportProviderElection", model="cdm", builder=CreditSupportProviderElectionBuilderImpl.class, version="6.7.0")
public interface CreditSupportProviderElection
extends RosettaModelObject {
    public static final CreditSupportProviderElectionMeta metaData = new CreditSupportProviderElectionMeta();

    public Party getParty();

    public CreditSupportProviderTermsEnum getCreditSupportProviderTerms();

    public List<? extends LegalEntity> getCreditSupportProvider();

    public String getBespokeCreditSuppportProvider();

    public CreditSupportProviderElection build();

    public CreditSupportProviderElectionBuilder toBuilder();

    public static CreditSupportProviderElectionBuilder builder() {
        return new CreditSupportProviderElectionBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditSupportProviderElection> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditSupportProviderElection> getType() {
        return CreditSupportProviderElection.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditSupportProviderTerms"), CreditSupportProviderTermsEnum.class, (Object)this.getCreditSupportProviderTerms(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditSupportProvider"), processor, LegalEntity.class, this.getCreditSupportProvider(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bespokeCreditSuppportProvider"), String.class, (Object)this.getBespokeCreditSuppportProvider(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CreditSupportProviderElectionBuilderImpl
    implements CreditSupportProviderElectionBuilder {
        protected Party.PartyBuilder party;
        protected CreditSupportProviderTermsEnum creditSupportProviderTerms;
        protected List<LegalEntity.LegalEntityBuilder> creditSupportProvider = new ArrayList<LegalEntity.LegalEntityBuilder>();
        protected String bespokeCreditSuppportProvider;

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public Party.PartyBuilder getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty() {
            Party.PartyBuilder result = this.party != null ? this.party : (this.party = Party.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditSupportProviderTerms")
        @RuneAttribute(value="creditSupportProviderTerms")
        public CreditSupportProviderTermsEnum getCreditSupportProviderTerms() {
            return this.creditSupportProviderTerms;
        }

        @Override
        @RosettaAttribute(value="creditSupportProvider")
        @RuneAttribute(value="creditSupportProvider")
        public List<? extends LegalEntity.LegalEntityBuilder> getCreditSupportProvider() {
            return this.creditSupportProvider;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateCreditSupportProvider(int _index) {
            if (this.creditSupportProvider == null) {
                this.creditSupportProvider = new ArrayList<LegalEntity.LegalEntityBuilder>();
            }
            return (LegalEntity.LegalEntityBuilder)this.getIndex(this.creditSupportProvider, _index, () -> {
                LegalEntity.LegalEntityBuilder newCreditSupportProvider = LegalEntity.builder();
                return newCreditSupportProvider;
            });
        }

        @Override
        @RosettaAttribute(value="bespokeCreditSuppportProvider")
        @RuneAttribute(value="bespokeCreditSuppportProvider")
        public String getBespokeCreditSuppportProvider() {
            return this.bespokeCreditSuppportProvider;
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public CreditSupportProviderElectionBuilder setParty(Party _party) {
            this.party = _party == null ? null : _party.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportProviderTerms")
        @RuneAttribute(value="creditSupportProviderTerms")
        public CreditSupportProviderElectionBuilder setCreditSupportProviderTerms(CreditSupportProviderTermsEnum _creditSupportProviderTerms) {
            this.creditSupportProviderTerms = _creditSupportProviderTerms == null ? null : _creditSupportProviderTerms;
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportProvider")
        @RuneAttribute(value="creditSupportProvider")
        public CreditSupportProviderElectionBuilder addCreditSupportProvider(LegalEntity _creditSupportProvider) {
            if (_creditSupportProvider != null) {
                this.creditSupportProvider.add(_creditSupportProvider.toBuilder());
            }
            return this;
        }

        @Override
        public CreditSupportProviderElectionBuilder addCreditSupportProvider(LegalEntity _creditSupportProvider, int _idx) {
            this.getIndex(this.creditSupportProvider, _idx, () -> _creditSupportProvider.toBuilder());
            return this;
        }

        @Override
        public CreditSupportProviderElectionBuilder addCreditSupportProvider(List<? extends LegalEntity> creditSupportProviders) {
            if (creditSupportProviders != null) {
                for (LegalEntity legalEntity : creditSupportProviders) {
                    this.creditSupportProvider.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditSupportProvider")
        public CreditSupportProviderElectionBuilder setCreditSupportProvider(List<? extends LegalEntity> creditSupportProviders) {
            this.creditSupportProvider = creditSupportProviders == null ? new ArrayList<LegalEntity.LegalEntityBuilder>() : (List)creditSupportProviders.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="bespokeCreditSuppportProvider")
        @RuneAttribute(value="bespokeCreditSuppportProvider")
        public CreditSupportProviderElectionBuilder setBespokeCreditSuppportProvider(String _bespokeCreditSuppportProvider) {
            this.bespokeCreditSuppportProvider = _bespokeCreditSuppportProvider == null ? null : _bespokeCreditSuppportProvider;
            return this;
        }

        @Override
        public CreditSupportProviderElection build() {
            return new CreditSupportProviderElectionImpl(this);
        }

        @Override
        public CreditSupportProviderElectionBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditSupportProviderElectionBuilder prune() {
            if (this.party != null && !this.party.prune().hasData()) {
                this.party = null;
            }
            this.creditSupportProvider = this.creditSupportProvider.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null && this.getParty().hasData()) {
                return true;
            }
            if (this.getCreditSupportProviderTerms() != null) {
                return true;
            }
            if (this.getCreditSupportProvider() != null && this.getCreditSupportProvider().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getBespokeCreditSuppportProvider() != null;
        }

        public CreditSupportProviderElectionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditSupportProviderElectionBuilder o = (CreditSupportProviderElectionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getParty(), (RosettaModelObjectBuilder)o.getParty(), this::setParty);
            merger.mergeRosetta(this.getCreditSupportProvider(), o.getCreditSupportProvider(), this::getOrCreateCreditSupportProvider);
            merger.mergeBasic((Object)this.getCreditSupportProviderTerms(), (Object)o.getCreditSupportProviderTerms(), this::setCreditSupportProviderTerms, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBespokeCreditSuppportProvider(), (Object)o.getBespokeCreditSuppportProvider(), this::setBespokeCreditSuppportProvider, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditSupportProviderElection _that = this.getType().cast(o);
            if (!Objects.equals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.creditSupportProviderTerms, (Object)_that.getCreditSupportProviderTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditSupportProvider, _that.getCreditSupportProvider())) {
                return false;
            }
            return Objects.equals(this.bespokeCreditSuppportProvider, _that.getBespokeCreditSuppportProvider());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportProviderTerms != null ? ((Object)((Object)this.creditSupportProviderTerms)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditSupportProvider != null ? this.creditSupportProvider.hashCode() : 0);
            _result = 31 * _result + (this.bespokeCreditSuppportProvider != null ? this.bespokeCreditSuppportProvider.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditSupportProviderElectionBuilder {party=" + this.party + ", creditSupportProviderTerms=" + (Object)((Object)this.creditSupportProviderTerms) + ", creditSupportProvider=" + this.creditSupportProvider + ", bespokeCreditSuppportProvider=" + this.bespokeCreditSuppportProvider + '}';
        }
    }

    public static interface CreditSupportProviderElectionBuilder
    extends CreditSupportProviderElection,
    RosettaModelObjectBuilder {
        public Party.PartyBuilder getOrCreateParty();

        @Override
        public Party.PartyBuilder getParty();

        public LegalEntity.LegalEntityBuilder getOrCreateCreditSupportProvider(int var1);

        public List<? extends LegalEntity.LegalEntityBuilder> getCreditSupportProvider();

        public CreditSupportProviderElectionBuilder setParty(Party var1);

        public CreditSupportProviderElectionBuilder setCreditSupportProviderTerms(CreditSupportProviderTermsEnum var1);

        public CreditSupportProviderElectionBuilder addCreditSupportProvider(LegalEntity var1);

        public CreditSupportProviderElectionBuilder addCreditSupportProvider(LegalEntity var1, int var2);

        public CreditSupportProviderElectionBuilder addCreditSupportProvider(List<? extends LegalEntity> var1);

        public CreditSupportProviderElectionBuilder setCreditSupportProvider(List<? extends LegalEntity> var1);

        public CreditSupportProviderElectionBuilder setBespokeCreditSuppportProvider(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditSupportProviderTerms"), CreditSupportProviderTermsEnum.class, (Object)this.getCreditSupportProviderTerms(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditSupportProvider"), processor, LegalEntity.LegalEntityBuilder.class, this.getCreditSupportProvider(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bespokeCreditSuppportProvider"), String.class, (Object)this.getBespokeCreditSuppportProvider(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CreditSupportProviderElectionBuilder prune();
    }

    public static class CreditSupportProviderElectionImpl
    implements CreditSupportProviderElection {
        private final Party party;
        private final CreditSupportProviderTermsEnum creditSupportProviderTerms;
        private final List<? extends LegalEntity> creditSupportProvider;
        private final String bespokeCreditSuppportProvider;

        protected CreditSupportProviderElectionImpl(CreditSupportProviderElectionBuilder builder) {
            this.party = Optional.ofNullable(builder.getParty()).map(f -> f.build()).orElse(null);
            this.creditSupportProviderTerms = builder.getCreditSupportProviderTerms();
            this.creditSupportProvider = Optional.ofNullable(builder.getCreditSupportProvider()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.bespokeCreditSuppportProvider = builder.getBespokeCreditSuppportProvider();
        }

        @Override
        @RosettaAttribute(value="party")
        @RuneAttribute(value="party")
        public Party getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="creditSupportProviderTerms")
        @RuneAttribute(value="creditSupportProviderTerms")
        public CreditSupportProviderTermsEnum getCreditSupportProviderTerms() {
            return this.creditSupportProviderTerms;
        }

        @Override
        @RosettaAttribute(value="creditSupportProvider")
        @RuneAttribute(value="creditSupportProvider")
        public List<? extends LegalEntity> getCreditSupportProvider() {
            return this.creditSupportProvider;
        }

        @Override
        @RosettaAttribute(value="bespokeCreditSuppportProvider")
        @RuneAttribute(value="bespokeCreditSuppportProvider")
        public String getBespokeCreditSuppportProvider() {
            return this.bespokeCreditSuppportProvider;
        }

        @Override
        public CreditSupportProviderElection build() {
            return this;
        }

        @Override
        public CreditSupportProviderElectionBuilder toBuilder() {
            CreditSupportProviderElectionBuilder builder = CreditSupportProviderElection.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditSupportProviderElectionBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getCreditSupportProviderTerms()).ifPresent(builder::setCreditSupportProviderTerms);
            Optional.ofNullable(this.getCreditSupportProvider()).ifPresent(builder::setCreditSupportProvider);
            Optional.ofNullable(this.getBespokeCreditSuppportProvider()).ifPresent(builder::setBespokeCreditSuppportProvider);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditSupportProviderElection _that = this.getType().cast(o);
            if (!Objects.equals(this.party, _that.getParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.creditSupportProviderTerms, (Object)_that.getCreditSupportProviderTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditSupportProvider, _that.getCreditSupportProvider())) {
                return false;
            }
            return Objects.equals(this.bespokeCreditSuppportProvider, _that.getBespokeCreditSuppportProvider());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportProviderTerms != null ? ((Object)((Object)this.creditSupportProviderTerms)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditSupportProvider != null ? this.creditSupportProvider.hashCode() : 0);
            _result = 31 * _result + (this.bespokeCreditSuppportProvider != null ? this.bespokeCreditSuppportProvider.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditSupportProviderElection {party=" + this.party + ", creditSupportProviderTerms=" + (Object)((Object)this.creditSupportProviderTerms) + ", creditSupportProvider=" + this.creditSupportProvider + ", bespokeCreditSuppportProvider=" + this.bespokeCreditSuppportProvider + '}';
        }
    }
}

